/*
 * Decompiled with CFR 0.152.
 */
package dev.decobr.betterenchants.config;

import com.google.gson.Gson;
import dev.decobr.betterenchants.BetterEnchants;
import dev.decobr.betterenchants.config.ConfigurationJSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Configuration {
    public static final Configuration INSTANCE = new Configuration();
    public final File configurationFile;
    public boolean fixEnchantCommand;

    public Configuration() {
        this.configurationFile = new File(class_310.method_1551().field_1697, "config/betterenchants.json");
    }

    public void loadConfig() throws IOException {
        if (!this.configurationFile.exists()) {
            if (this.configurationFile.createNewFile()) {
                BetterEnchants.INSTANCE.logger.info("Created config file!");
            } else {
                BetterEnchants.INSTANCE.logger.warn("Failed to create config file");
            }
        } else {
            BufferedReader reader = new BufferedReader(new FileReader(this.configurationFile));
            ConfigurationJSON config = (ConfigurationJSON)new Gson().fromJson((Reader)reader, ConfigurationJSON.class);
            ((Reader)reader).close();
            this.fixEnchantCommand = config.fixEnchantCommand;
        }
    }

    public void saveConfig() {
        try {
            if (!this.configurationFile.exists()) {
                if (this.configurationFile.createNewFile()) {
                    BetterEnchants.INSTANCE.logger.info("Created config file!");
                } else {
                    BetterEnchants.INSTANCE.logger.warn("Failed to create config file :(");
                    return;
                }
            }
            FileWriter writer = new FileWriter(this.configurationFile);
            new Gson().toJson((Object)new ConfigurationJSON(this.fixEnchantCommand), (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            BetterEnchants.INSTANCE.logger.warn("Failed to save configuration: " + e.getLocalizedMessage());
        }
    }
}

