/*
 * Decompiled with CFR 0.152.
 */
package retr0.bedrockwaters;

import java.io.File;
import java.io.IOException;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1059;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5458;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retr0.bedrockwaters.Config;
import retr0.bedrockwaters.WaterPropertiesReplacer;

public class BedrockWaters
implements ModInitializer {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "bedrockwaters";
    public static final String MOD_NAME = "BedrockWaters";

    public void onInitialize() {
        BedrockWaters.log(Level.INFO, "BedrockWaters initialized!");
        class_2960 bedrockWaterStillSpriteId = new class_2960(MOD_ID, "block/water_still");
        class_2960 bedrockWaterFlowSpriteId = new class_2960(MOD_ID, "block/water_flow");
        ClientSpriteRegistryCallback.event((class_2960)class_1059.field_5275).register((atlasTexture, registry) -> {
            registry.register(bedrockWaterStillSpriteId);
            registry.register(bedrockWaterFlowSpriteId);
        });
        try {
            Config.init(new File("./config/bedrockwaters/"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BedrockWaters.log(Level.INFO, "Modifying vanilla biome water attributes...");
        class_5458.field_25933.forEach(Biome -> {
            WaterPropertiesReplacer.setBiomeWaterProperties(Biome);
            BedrockWaters.log(Level.DEBUG, "Modified " + class_5458.field_25933.method_10221(Biome) + " properties -> WaterColor: #" + Integer.toHexString(Biome.method_8687()) + ", WaterFogColor: #" + Integer.toHexString(Biome.method_8713()));
        });
        BedrockWaters.log(Level.INFO, "Finished!");
        RegistryEntryAddedCallback.event((class_2378)class_5458.field_25933).register((i, identifier, biome) -> {
            WaterPropertiesReplacer.setBiomeWaterProperties(biome);
            BedrockWaters.log(Level.DEBUG, "Modified " + identifier + " properties -> WaterColor: #" + Integer.toHexString(biome.method_8687()) + ", WaterFogColor: #" + Integer.toHexString(biome.method_8713()));
        });
    }

    public static void log(Level level, String message) {
        LOGGER.log(level, "[BedrockWaters] " + message);
    }
}

