/*
 * Decompiled with CFR 0.152.
 */
package retr0.bedrockwaters.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_746;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_758.class})
public abstract class BackgroundRendererMixin {
    private static final float DEFAULT_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(15);
    private static final float SWAMP_BIOME_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(8);
    private static final float RIVER_BIOME_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(30);
    private static final float FROZEN_RIVER_BIOME_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(20);
    private static final float BEACH_BIOME_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(60);
    private static final float SNOWY_BEACH_BIOME_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(50);
    private static final float OCEAN_BIOME_FOG_DISTANCE = BackgroundRendererMixin.getModifiedFogModeEXP2Distance(60);
    private static final float TRANSITION_TIME_MS = 5000.0f;
    private static boolean transitioning = false;
    private static float waterFogDistance = DEFAULT_FOG_DISTANCE;
    private static class_746 clientPlayerEntity;
    private static class_1959 biome;
    private static float startingFogDistance;
    private static float startingNextWaterFogDistance;
    private static long startingTime;

    @Inject(method={"applyFog"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;fogStart(F)V")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void onApplyFogAboveWater(class_4184 camera, class_758.class_4596 fogType, float viewDistance, boolean thickFog, CallbackInfo ci, class_3610 fluidState, class_1297 entity) {
        clientPlayerEntity = (class_746)entity;
        biome = BackgroundRendererMixin.clientPlayerEntity.field_6002.method_23753(clientPlayerEntity.method_24515());
        waterFogDistance = BackgroundRendererMixin.getWaterFogDistance(biome);
    }

    @Inject(method={"applyFog"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;fogDensity(F)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void onApplyFogUnderWater(class_4184 camera, class_758.class_4596 fogType, float viewDistance, boolean thickFog, CallbackInfo ci, class_3610 fluidState, class_1297 entity) {
        clientPlayerEntity = (class_746)entity;
        biome = BackgroundRendererMixin.clientPlayerEntity.field_6002.method_23753(clientPlayerEntity.method_24515());
        float nextWaterFogDistance = BackgroundRendererMixin.getWaterFogDistance(biome);
        if ((double)class_3532.method_15379((float)(waterFogDistance - nextWaterFogDistance)) > 2.0E-4) {
            if (!transitioning || startingNextWaterFogDistance != nextWaterFogDistance) {
                startingFogDistance = waterFogDistance;
                startingNextWaterFogDistance = nextWaterFogDistance;
                startingTime = class_156.method_658();
                transitioning = true;
            }
            float time = class_3532.method_15363((float)((float)(class_156.method_658() - startingTime) / 5000.0f), (float)0.0f, (float)1.0f);
            waterFogDistance = class_3532.method_16439((float)time, (float)startingFogDistance, (float)nextWaterFogDistance);
        } else {
            transitioning = false;
        }
        RenderSystem.fogDensity((float)(waterFogDistance - clientPlayerEntity.method_3140() * clientPlayerEntity.method_3140() * 0.03f));
    }

    private static float getModifiedFogModeEXP2Distance(int distance) {
        return class_3532.method_15368((double)Math.log(distance)) / (float)distance + 0.03f;
    }

    private static float getWaterFogDistance(class_1959 biome) {
        if (biome.method_8688() == class_1959.class_1961.field_9364) {
            return SWAMP_BIOME_FOG_DISTANCE;
        }
        if (biome.method_8688() == class_1959.class_1961.field_9369) {
            return biome.method_8712() < 0.2f ? FROZEN_RIVER_BIOME_FOG_DISTANCE : RIVER_BIOME_FOG_DISTANCE;
        }
        if (biome.method_8688() == class_1959.class_1961.field_9363) {
            return biome.method_8712() < 0.2f ? BEACH_BIOME_FOG_DISTANCE : SNOWY_BEACH_BIOME_FOG_DISTANCE;
        }
        if (biome.method_8688() == class_1959.class_1961.field_9367) {
            return OCEAN_BIOME_FOG_DISTANCE;
        }
        return DEFAULT_FOG_DISTANCE;
    }
}

