/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.config;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.gui.GuiBetterAdvancementTab;
import betteradvancements.gui.GuiScreenBetterAdvancements;
import betteradvancements.util.ColorHelper;
import betteradvancements.util.CriteriaDetail;
import betteradvancements.util.CriterionGrid;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    private static File configDir;

    public static void init(File configDir) {
        if (ConfigHandler.configDir == null) {
            configDir = new File(configDir, "betteradvancements");
            configDir.mkdir();
            ConfigHandler.configDir = configDir;
        }
        if (config == null) {
            config = new Configuration(new File(configDir, "betteradvancements.cfg"));
            ConfigHandler.loadConfig();
        }
    }

    public static File getConfigDir() {
        return configDir;
    }

    private static void loadConfig() {
        BetterDisplayInfo.defaultUncompletedIconColor = ColorHelper.RGB(config.get("general", "defaultUncompletedIconColor", "#FFFFFF").getString());
        BetterDisplayInfo.defaultUncompletedTitleColor = ColorHelper.RGB(config.get("general", "defaultUncompletedTitleColor", "#0489C1").getString());
        BetterDisplayInfo.defaultCompletedIconColor = ColorHelper.RGB(config.get("general", "defaultCompletedIconColor", "#DBA213").getString());
        BetterDisplayInfo.defaultCompletedTitleColor = ColorHelper.RGB(config.get("general", "defaultCompletedTitleColor", "#DBA213").getString());
        GuiBetterAdvancementTab.doFade = config.get("general", "doAdvancementsBackgroundFade", true).getBoolean();
        GuiScreenBetterAdvancements.showDebugCoordinates = config.get("general", "showDebugCoordinates", false).getBoolean();
        GuiScreenBetterAdvancements.orderTabsAlphabetically = config.get("general", "orderTabsAlphabetically", false).getBoolean();
        GuiScreenBetterAdvancements.uiScaling = config.get("general", "uiScaling", 100, "Values below 50% might give odd results, use on own risk ;)", 1, 100).getInt();
        String criteriaDetailString = config.get("general", "criteriaDetail", CriteriaDetail.DEFAULT.getName(), CriteriaDetail.comments(), CriteriaDetail.names()).getString();
        CriterionGrid.detailLevel = CriteriaDetail.fromName(criteriaDetailString);
        CriterionGrid.requiresShift = config.get("general", "criteriaDetailRequiresShift", false).getBoolean();
        BetterDisplayInfo.defaultDrawDirectLines = config.get("general", "defaultDrawDirectLines", false).getBoolean();
        BetterDisplayInfo.defaultHideLines = config.get("general", "defaultHideLines", false).getBoolean();
        BetterDisplayInfo.defaultCompletedLineColor = ColorHelper.RGB(config.get("general", "defaultCompletedLineColor", "#FFFFFF").getString());
        BetterDisplayInfo.defaultUncompletedLineColor = ColorHelper.RGB(config.get("general", "defaultUncompletedLineColor", "#FFFFFF").getString());
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("betteradvancements")) {
            ConfigHandler.loadConfig();
        }
    }
}

