/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.util;

import betteradvancements.util.CriteriaDetail;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CriterionGrid {
    public static CriteriaDetail detailLevel = CriteriaDetail.DEFAULT;
    public static boolean requiresShift = false;
    private static final CriterionGrid empty = new CriterionGrid();
    private final List<String> cellContents;
    private final int[] cellWidths;
    private final int fontHeight;
    private final int numColumns;
    public final int numRows;
    public List<Column> columns;
    public int width;
    public int height;
    public double aspectRatio;

    private CriterionGrid() {
        this.cellContents = Collections.emptyList();
        this.cellWidths = new int[0];
        this.fontHeight = 0;
        this.numColumns = 0;
        this.numRows = 0;
        this.columns = Collections.emptyList();
        this.width = 0;
        this.height = 0;
        this.aspectRatio = Double.NaN;
    }

    public CriterionGrid(List<String> cellContents, int[] cellWidths, int fontHeight, int numColumns) {
        this.cellContents = cellContents;
        this.cellWidths = cellWidths;
        this.fontHeight = fontHeight;
        this.numColumns = numColumns;
        this.numRows = (int)Math.ceil((double)cellContents.size() / (double)numColumns);
    }

    public void init() {
        this.columns = new ArrayList<Column>();
        this.width = 0;
        for (int c = 0; c < this.numColumns; ++c) {
            int cellIndex;
            ArrayList<String> column = new ArrayList<String>();
            int columnWidth = 0;
            for (int r = 0; r < this.numRows && (cellIndex = c * this.numRows + r) < this.cellContents.size(); ++r) {
                String str = this.cellContents.get(cellIndex);
                column.add(str);
                columnWidth = Math.max(columnWidth, this.cellWidths[cellIndex]);
            }
            this.columns.add(new Column(column, columnWidth));
            this.width += columnWidth;
        }
        this.height = this.numRows * this.fontHeight;
        this.aspectRatio = 1.0f * (float)this.width / (float)this.height;
    }

    public static CriterionGrid findOptimalCriterionGrid(Advancement advancement, AdvancementProgress progress, double maxAspectRatio, FontRenderer renderer) {
        if (progress == null || progress.func_192105_a() || detailLevel.equals((Object)CriteriaDetail.OFF)) {
            return empty;
        }
        Map criteria = advancement.func_192073_f();
        if (criteria.size() <= 1) {
            return empty;
        }
        int numUnobtained = 0;
        ArrayList<String> cellContents = new ArrayList<String>();
        for (String criterion : criteria.keySet()) {
            TextComponentString text2;
            TextComponentString text;
            if (progress.func_192106_c(criterion).func_192151_a()) {
                if (!detailLevel.showObtained()) continue;
                text = new TextComponentString(" + ");
                text.func_150256_b().func_150238_a(TextFormatting.GREEN);
                text2 = new TextComponentString(criterion);
                text2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                text.func_150257_a((ITextComponent)text2);
                cellContents.add(text.func_150254_d());
                continue;
            }
            if (detailLevel.showUnobtained()) {
                text = new TextComponentString(" x ");
                text.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                text2 = new TextComponentString(criterion);
                text2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                text.func_150257_a((ITextComponent)text2);
                cellContents.add(text.func_150254_d());
            }
            ++numUnobtained;
        }
        if (!detailLevel.showUnobtained()) {
            TextComponentString text = new TextComponentString(" x ");
            text.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
            TextComponentString text2 = new TextComponentString(numUnobtained + " remaining");
            text2.func_150256_b().func_150238_a(TextFormatting.WHITE);
            text2.func_150256_b().func_150217_b(Boolean.valueOf(true));
            text.func_150257_a((ITextComponent)text2);
            cellContents.add(text.func_150254_d());
        }
        int[] cellWidths = new int[cellContents.size()];
        for (int i = 0; i < cellWidths.length; ++i) {
            cellWidths[i] = renderer.func_78256_a((String)cellContents.get(i));
        }
        int numCols = 0;
        CriterionGrid prevGrid = null;
        CriterionGrid currGrid = null;
        do {
            CriterionGrid newGrid = new CriterionGrid(cellContents, cellWidths, renderer.field_78288_b, ++numCols);
            if (prevGrid != null && newGrid.numRows == prevGrid.numRows) continue;
            newGrid.init();
            prevGrid = currGrid;
            currGrid = newGrid;
        } while (numCols <= cellContents.size() && currGrid.aspectRatio <= maxAspectRatio);
        return prevGrid != null ? prevGrid : currGrid;
    }

    public class Column {
        public final List<String> cells;
        public final int width;

        public Column(List<String> cells, int width) {
            this.cells = cells;
            this.width = width;
        }
    }
}

