/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.config;

import betteradvancements.BetterAdvancements;
import betteradvancements.config.ConfigValues;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;

public class Config {
    public static Config instance = new Config();
    public static final ForgeConfigSpec CLIENT = ConfigValues.build();

    private Config() {
    }

    public void loadConfig(ForgeConfigSpec spec, Path path) {
        BetterAdvancements.log.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        BetterAdvancements.log.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        BetterAdvancements.log.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
        ConfigValues.pushChanges();
    }

    @SubscribeEvent
    public void onLoad(ModConfig.Loading configEvent) {
        BetterAdvancements.log.debug("Loaded {} config file {}", (Object)"betteradvancements", (Object)configEvent.getConfig().getFileName());
        ConfigValues.pushChanges();
    }

    @SubscribeEvent
    public void onFileChange(ModConfig.ConfigReloading configEvent) {
        BetterAdvancements.log.debug("Reloaded {} config file {}", (Object)"betteradvancements", (Object)configEvent.getConfig().getFileName());
        ConfigValues.pushChanges();
    }
}

