/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.gui;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.api.event.AdvancementDrawConnectionsEvent;
import betteradvancements.gui.BetterAdvancementTabGui;
import betteradvancements.gui.BetterAdvancementsScreen;
import betteradvancements.reference.Resources;
import betteradvancements.util.CriterionGrid;
import betteradvancements.util.RenderUtil;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.advancements.AdvancementState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class BetterAdvancementEntryGui
extends AbstractGui {
    protected static final int ADVANCEMENT_SIZE = 26;
    private static final int CORNER_SIZE = 10;
    private static final int WIDGET_WIDTH = 256;
    private static final int WIDGET_HEIGHT = 26;
    private static final int TITLE_SIZE = 32;
    private static final int ICON_OFFSET = 128;
    private static final int ICON_SIZE = 26;
    private final BetterAdvancementTabGui betterAdvancementTabGui;
    private final Advancement advancement;
    protected final BetterDisplayInfo betterDisplayInfo;
    private final DisplayInfo displayInfo;
    private final String title;
    private int width;
    private List<String> description;
    private CriterionGrid criterionGrid;
    private final Minecraft minecraft;
    private BetterAdvancementEntryGui parent;
    private final List<BetterAdvancementEntryGui> children = Lists.newArrayList();
    private AdvancementProgress advancementProgress;
    protected int x;
    protected int y;
    private final int screenScale;

    public BetterAdvancementEntryGui(BetterAdvancementTabGui betterAdvancementTabGui, Minecraft mc, Advancement advancement, DisplayInfo displayInfo) {
        this.betterAdvancementTabGui = betterAdvancementTabGui;
        this.advancement = advancement;
        this.betterDisplayInfo = betterAdvancementTabGui.getBetterDisplayInfo(advancement);
        this.displayInfo = displayInfo;
        this.minecraft = mc;
        this.title = mc.field_71466_p.func_78269_a(displayInfo.func_192297_a().func_150254_d(), 163);
        this.x = this.betterDisplayInfo.getPosX() != null ? this.betterDisplayInfo.getPosX() : MathHelper.func_76141_d((float)(displayInfo.func_192299_e() * 32.0f));
        this.y = this.betterDisplayInfo.getPosY() != null ? this.betterDisplayInfo.getPosY() : MathHelper.func_76141_d((float)(displayInfo.func_192296_f() * 27.0f));
        this.refreshHover();
        this.screenScale = mc.field_195558_d.func_216521_a(0, false);
    }

    private void refreshHover() {
        Minecraft mc = this.minecraft;
        int k = 0;
        if (this.advancement.func_193124_g() > 1) {
            int strLengthRequirementCount = String.valueOf(this.advancement.func_193124_g()).length();
            k = mc.field_71466_p.func_78256_a("  ") + mc.field_71466_p.func_78256_a("0") * strLengthRequirementCount * 2 + mc.field_71466_p.func_78256_a("/");
        }
        int titleWidth = 29 + mc.field_71466_p.func_78256_a(this.title) + k;
        BetterAdvancementsScreen screen = this.betterAdvancementTabGui.getScreen();
        this.criterionGrid = CriterionGrid.findOptimalCriterionGrid(this.advancement, this.advancementProgress, screen.width / 2, mc.field_71466_p);
        int maxWidth = !CriterionGrid.requiresShift || Screen.hasShiftDown() ? Math.max(titleWidth, this.criterionGrid.width) : titleWidth;
        String s = this.displayInfo.func_193222_b().func_150254_d();
        this.description = this.findOptimalLines(s, maxWidth);
        for (String line : this.description) {
            maxWidth = Math.max(maxWidth, mc.field_71466_p.func_78256_a(line));
        }
        this.width = maxWidth + 8;
    }

    private List<String> findOptimalLines(String line, int width) {
        if (line.isEmpty()) {
            return Collections.emptyList();
        }
        List list = this.minecraft.field_71466_p.func_78271_c(line, width);
        if (list.size() > 1) {
            width = Math.max(width, this.betterAdvancementTabGui.getScreen().internalWidth / 4);
            list = this.minecraft.field_71466_p.func_78271_c(line, width);
        }
        while (list.size() > 5 && (double)width < 384.0 && (double)width < (double)this.betterAdvancementTabGui.getScreen().internalWidth / 2.5) {
            width += width / 4;
            list = this.minecraft.field_71466_p.func_78271_c(line, width);
        }
        return list;
    }

    @Nullable
    private BetterAdvancementEntryGui getFirstVisibleParent(Advancement advancementIn) {
        while ((advancementIn = advancementIn.func_192070_b()) != null && advancementIn.func_192068_c() == null) {
        }
        if (advancementIn != null && advancementIn.func_192068_c() != null) {
            return this.betterAdvancementTabGui.getAdvancementGui(advancementIn);
        }
        return null;
    }

    public void drawConnectivity(int scrollX, int scrollY, boolean drawInside) {
        if (!this.betterDisplayInfo.hideLines().booleanValue()) {
            if (this.parent != null) {
                this.drawConnection(this.parent, scrollX, scrollY, drawInside);
            }
            AdvancementDrawConnectionsEvent event = new AdvancementDrawConnectionsEvent(this.advancement);
            MinecraftForge.EVENT_BUS.post((Event)event);
            for (Advancement parent : event.getExtraConnections()) {
                BetterAdvancementEntryGui parentGui = this.betterAdvancementTabGui.getAdvancementGui(parent);
                if (parentGui == null) continue;
                this.drawConnection(parentGui, scrollX, scrollY, drawInside);
            }
        }
        for (BetterAdvancementEntryGui betterAdvancementEntryGui : this.children) {
            betterAdvancementEntryGui.drawConnectivity(scrollX, scrollY, drawInside);
        }
    }

    public void drawConnection(BetterAdvancementEntryGui parent, int scrollX, int scrollY, boolean drawInside) {
        int innerLineColor = this.advancementProgress != null && this.advancementProgress.func_192105_a() ? this.betterDisplayInfo.getCompletedLineColor() : this.betterDisplayInfo.getUnCompletedLineColor();
        int borderLineColor = -16777216;
        if (this.betterDisplayInfo.drawDirectLines().booleanValue()) {
            boolean perpendicular;
            double x1 = scrollX + this.x + 13 + 3;
            double y1 = scrollY + this.y + 13;
            double x2 = scrollX + parent.x + 13 + 3;
            double y2 = scrollY + parent.y + 13;
            boolean bl = perpendicular = x1 == x2 || y1 == y2;
            if (!perpendicular) {
                double width;
                switch (this.screenScale) {
                    case 1: {
                        width = drawInside ? 1.5 : 0.5;
                        break;
                    }
                    case 2: {
                        width = drawInside ? 2.25 : 0.75;
                        break;
                    }
                    case 3: {
                        width = drawInside ? 2.0 : 0.6666666666666667;
                        break;
                    }
                    case 4: {
                        width = drawInside ? 2.125 : 0.625;
                        break;
                    }
                    default: {
                        double d = width = drawInside ? 3.0 : 1.0;
                    }
                }
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 0.75, y1 - 0.75, x2 - 0.75, y2 - 0.75, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            } else {
                double width;
                double d = width = drawInside ? 3.0 : 1.0;
                if (drawInside) {
                    RenderUtil.drawRect(x1 - 1.0, y1 - 1.0, x2 - 1.0, y2 - 1.0, width, borderLineColor);
                } else {
                    RenderUtil.drawRect(x1, y1, x2, y2, width, innerLineColor);
                }
            }
        } else {
            int startX = scrollX + parent.x + 13;
            int endXHalf = scrollX + parent.x + 26 + 6;
            int startY = scrollY + parent.y + 13;
            int endX = scrollX + this.x + 13;
            int endY = scrollY + this.y + 13;
            if (drawInside) {
                this.hLine(endXHalf, startX, startY - 1, borderLineColor);
                this.hLine(endXHalf + 1, startX, startY, borderLineColor);
                this.hLine(endXHalf, startX, startY + 1, borderLineColor);
                this.hLine(endX, endXHalf - 1, endY - 1, borderLineColor);
                this.hLine(endX, endXHalf - 1, endY, borderLineColor);
                this.hLine(endX, endXHalf - 1, endY + 1, borderLineColor);
                this.vLine(endXHalf - 1, endY, startY, borderLineColor);
                this.vLine(endXHalf + 1, endY, startY, borderLineColor);
            } else {
                this.hLine(endXHalf, startX, startY, innerLineColor);
                this.hLine(endX, endXHalf, endY, innerLineColor);
                this.vLine(endXHalf, endY, startY, innerLineColor);
            }
        }
    }

    public void draw(int scrollX, int scrollY) {
        if (!this.displayInfo.func_193224_j() || this.advancementProgress != null && this.advancementProgress.func_192105_a()) {
            float f = this.advancementProgress == null ? 0.0f : this.advancementProgress.func_192103_c();
            AdvancementState advancementState = f >= 1.0f ? AdvancementState.OBTAINED : AdvancementState.UNOBTAINED;
            this.minecraft.func_110434_K().func_110577_a(Resources.Gui.WIDGETS);
            RenderUtil.setColor(this.betterDisplayInfo.getIconColor(advancementState));
            GlStateManager.enableBlend();
            this.blit(scrollX + this.x + 3, scrollY + this.y, this.displayInfo.func_192291_d().func_192309_b(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(advancementState), 26, 26);
            RenderHelper.func_74520_c();
            this.minecraft.func_175599_af().func_184391_a(null, this.displayInfo.func_192298_b(), scrollX + this.x + 8, scrollY + this.y + 5);
        }
        for (BetterAdvancementEntryGui betterAdvancementEntryGui : this.children) {
            betterAdvancementEntryGui.draw(scrollX, scrollY);
        }
    }

    public void getAdvancementProgress(AdvancementProgress advancementProgressIn) {
        this.advancementProgress = advancementProgressIn;
        this.refreshHover();
    }

    public void addGuiAdvancement(BetterAdvancementEntryGui betterAdvancementEntryGui) {
        this.children.add(betterAdvancementEntryGui);
    }

    public void drawHover(int scrollX, int scrollY, float fade, int left, int top) {
        int boxHeight;
        AdvancementState stateIcon;
        AdvancementState stateTitleRight;
        AdvancementState stateTitleLeft;
        boolean drawTop;
        int i;
        this.refreshHover();
        boolean drawLeft = left + scrollX + this.x + this.width + 26 >= this.betterAdvancementTabGui.getScreen().internalWidth;
        String s = this.advancementProgress == null ? null : this.advancementProgress.func_193126_d();
        int n = i = s == null ? 0 : this.minecraft.field_71466_p.func_78256_a(s);
        if (!CriterionGrid.requiresShift || Screen.hasShiftDown()) {
            if (this.criterionGrid.height < this.betterAdvancementTabGui.getScreen().height) {
                int n2 = this.description.size();
                this.minecraft.field_71466_p.getClass();
                drawTop = top + scrollY + this.y + n2 * 9 + this.criterionGrid.height + 50 >= this.betterAdvancementTabGui.getScreen().height;
            } else {
                drawTop = false;
            }
        } else {
            int n3 = this.description.size();
            this.minecraft.field_71466_p.getClass();
            drawTop = top + scrollY + this.y + n3 * 9 + 50 >= this.betterAdvancementTabGui.getScreen().height;
        }
        float percentageObtained = this.advancementProgress == null ? 0.0f : this.advancementProgress.func_192103_c();
        int j = MathHelper.func_76141_d((float)(percentageObtained * (float)this.width));
        if (percentageObtained >= 1.0f) {
            j = this.width / 2;
            stateTitleLeft = AdvancementState.OBTAINED;
            stateTitleRight = AdvancementState.OBTAINED;
            stateIcon = AdvancementState.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementState.UNOBTAINED;
            stateTitleRight = AdvancementState.UNOBTAINED;
            stateIcon = AdvancementState.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            stateTitleLeft = AdvancementState.OBTAINED;
            stateTitleRight = AdvancementState.OBTAINED;
            stateIcon = AdvancementState.UNOBTAINED;
        } else {
            stateTitleLeft = AdvancementState.OBTAINED;
            stateTitleRight = AdvancementState.UNOBTAINED;
            stateIcon = AdvancementState.UNOBTAINED;
        }
        int k = this.width - j;
        this.minecraft.func_110434_K().func_110577_a(Resources.Gui.WIDGETS);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        int drawY = scrollY + this.y;
        int drawX = drawLeft ? scrollX + this.x - this.width + 26 + 6 : scrollX + this.x;
        if (!CriterionGrid.requiresShift || Screen.hasShiftDown()) {
            int n4 = this.description.size();
            this.minecraft.field_71466_p.getClass();
            boxHeight = 32 + n4 * 9 + this.criterionGrid.height;
        } else {
            int n5 = this.description.size();
            this.minecraft.field_71466_p.getClass();
            boxHeight = 32 + n5 * 9;
        }
        if (!this.description.isEmpty()) {
            if (drawTop) {
                this.render9Sprite(drawX, drawY + 26 - boxHeight, this.width, boxHeight, 10, 256, 26, 0, 52);
            } else {
                this.render9Sprite(drawX, drawY, this.width, boxHeight, 10, 256, 26, 0, 52);
            }
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleLeft));
        int left_side = Math.min(j, 240);
        this.blit(drawX, drawY, 0, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, left_side, 26);
        if (left_side < j) {
            this.blit(drawX + left_side, drawY, 16, this.betterDisplayInfo.getTitleYMultiplier(stateTitleLeft) * 26, j - left_side, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getTitleColor(stateTitleRight));
        int right_side = Math.min(k, 240);
        this.blit(drawX + j, drawY, 256 - right_side, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, right_side, 26);
        if (right_side < k) {
            this.blit(drawX + j + right_side, drawY, 256 - k + right_side, this.betterDisplayInfo.getTitleYMultiplier(stateTitleRight) * 26, k - right_side, 26);
        }
        RenderUtil.setColor(this.betterDisplayInfo.getIconColor(stateIcon));
        this.blit(scrollX + this.x + 3, scrollY + this.y, this.displayInfo.func_192291_d().func_192309_b(), 128 + 26 * this.betterDisplayInfo.getIconYMultiplier(stateIcon), 26, 26);
        if (drawLeft) {
            this.minecraft.field_71466_p.func_175063_a(this.title, (float)(drawX + 5), (float)(scrollY + this.y + 9), -1);
            if (s != null) {
                this.minecraft.field_71466_p.func_175063_a(s, (float)(scrollX + this.x - i), (float)(scrollY + this.y + 9), -1);
            }
        } else {
            this.minecraft.field_71466_p.func_175063_a(this.title, (float)(scrollX + this.x + 32), (float)(scrollY + this.y + 9), -1);
            if (s != null) {
                this.minecraft.field_71466_p.func_175063_a(s, (float)(scrollX + this.x + this.width - i - 5), (float)(scrollY + this.y + 9), -1);
            }
        }
        int yOffset = drawTop ? drawY + 26 - boxHeight + 7 : scrollY + this.y + 9 + 17;
        for (int k1 = 0; k1 < this.description.size(); ++k1) {
            FontRenderer fontRenderer = this.minecraft.field_71466_p;
            float f = drawX + 5;
            this.minecraft.field_71466_p.getClass();
            fontRenderer.func_211126_b(this.description.get(k1), f, (float)(yOffset + k1 * 9), -5592406);
        }
        if (this.criterionGrid != null && !CriterionGrid.requiresShift || Screen.hasShiftDown()) {
            int xOffset = drawX + 5;
            int n6 = this.description.size();
            this.minecraft.field_71466_p.getClass();
            yOffset += n6 * 9;
            for (int colIndex = 0; colIndex < this.criterionGrid.columns.size(); ++colIndex) {
                CriterionGrid.Column col = this.criterionGrid.columns.get(colIndex);
                for (int rowIndex = 0; rowIndex < col.cells.size(); ++rowIndex) {
                    FontRenderer fontRenderer = this.minecraft.field_71466_p;
                    float f = xOffset;
                    this.minecraft.field_71466_p.getClass();
                    fontRenderer.func_211126_b(col.cells.get(rowIndex), f, (float)(yOffset + rowIndex * 9), -5592406);
                }
                xOffset += col.width;
            }
        }
        RenderHelper.func_74520_c();
        this.minecraft.func_175599_af().func_184391_a(null, this.displayInfo.func_192298_b(), scrollX + this.x + 8, scrollY + this.y + 5);
    }

    protected void render9Sprite(int x, int y, int width, int height, int textureHeight, int textureWidth, int textureDistance, int textureX, int textureY) {
        this.blit(x, y, textureX, textureY, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY, textureWidth - textureHeight - textureHeight, textureDistance);
        this.blit(x + width - textureHeight, y, textureX + textureWidth - textureHeight, textureY, textureHeight, textureHeight);
        this.blit(x, y + height - textureHeight, textureX, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y + height - textureHeight, width - textureHeight - textureHeight, textureHeight, textureX + textureHeight, textureY + textureDistance - textureHeight, textureWidth - textureHeight - textureHeight, textureDistance);
        this.blit(x + width - textureHeight, y + height - textureHeight, textureX + textureWidth - textureHeight, textureY + textureDistance - textureHeight, textureHeight, textureHeight);
        RenderUtil.renderRepeating(this, x, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, x + textureHeight, y + textureHeight, width - textureHeight - textureHeight, height - textureHeight - textureHeight, textureX + textureHeight, textureY + textureHeight, textureWidth - textureHeight - textureHeight, textureDistance - textureHeight - textureHeight);
        RenderUtil.renderRepeating(this, x + width - textureHeight, y + textureHeight, textureHeight, height - textureHeight - textureHeight, textureX + textureWidth - textureHeight, textureY + textureHeight, textureWidth, textureDistance - textureHeight - textureHeight);
    }

    public boolean isMouseOver(double scrollX, double scrollY, double mouseX, double mouseY) {
        if (!this.displayInfo.func_193224_j() || this.advancementProgress != null && this.advancementProgress.func_192105_a()) {
            double left = scrollX + (double)this.x;
            double right = left + 26.0;
            double top = scrollY + (double)this.y;
            double bottom = top + 26.0;
            return mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom;
        }
        return false;
    }

    public void attachToParent() {
        if (this.parent == null && this.advancement.func_192070_b() != null) {
            this.parent = this.getFirstVisibleParent(this.advancement);
            if (this.parent != null) {
                this.parent.addGuiAdvancement(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public Advancement getAdvancement() {
        return this.advancement;
    }
}

