/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import com.yungnickyoung.minecraft.bettercaves.world.feature.CarverFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BCFeature {
    public static final CarverFeature BETTERCAVES_FEATURE = new CarverFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final ConfiguredFeature<?, ?> CONFIGURED_BETTERCAVES_FEATURE = new ConfiguredFeature((Feature)BETTERCAVES_FEATURE, (IFeatureConfig)new NoFeatureConfig());

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BCFeature::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BCFeature::configChanged);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, BCFeature::registerFeature);
        MinecraftForge.EVENT_BUS.addListener(BCFeature::worldUnload);
    }

    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        Registry.func_218322_a((Registry)Registry.field_218379_q, (ResourceLocation)new ResourceLocation("bettercaves", "bettercaves"), (Object)((Object)BETTERCAVES_FEATURE));
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(BCFeature::lateSetup);
    }

    private static void lateSetup() {
        BetterCaves.LOGGER.info("Replacing biome carvers with Better Caves carvers...");
        for (Biome biome : WorldGenRegistries.field_243657_i) {
            BCFeature.convertImmutableFeatures(biome);
            List defaultAirCarvers = biome.func_242440_e().func_242489_a(GenerationStage.Carving.AIR);
            List defaultLiquidCarvers = biome.func_242440_e().func_242489_a(GenerationStage.Carving.LIQUID);
            BetterCaves.defaultBiomeAirCarvers.put(biome.toString(), BCFeature.convertImmutableList(defaultAirCarvers));
            BetterCaves.defaultBiomeLiquidCarvers.put(biome.toString(), BCFeature.convertImmutableList(defaultLiquidCarvers));
            biome.func_242440_e().field_242483_e = Maps.newHashMap();
            List biomeFeatures = biome.func_242440_e().field_242484_f;
            while (biomeFeatures.size() <= GenerationStage.Decoration.RAW_GENERATION.ordinal()) {
                biomeFeatures.add(Lists.newArrayList());
            }
            List rawGenSuppliers = BCFeature.convertImmutableList((List)biomeFeatures.get(GenerationStage.Decoration.RAW_GENERATION.ordinal()));
            rawGenSuppliers.add(0, () -> CONFIGURED_BETTERCAVES_FEATURE);
            biomeFeatures.set(GenerationStage.Decoration.RAW_GENERATION.ordinal(), rawGenSuppliers);
        }
    }

    public static void worldUnload(WorldEvent.Unload event) {
        BetterCaves.LOGGER.debug("UNLOADING WORLD");
        try {
            String key = Objects.requireNonNull(((World)event.getWorld()).func_234923_W_().func_240901_a_()).toString();
            BetterCaves.activeCarversMap.remove(key);
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to unload carver for dimension!");
        }
    }

    public static void configChanged(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == Configuration.SPEC) {
            String rawStringofList = (String)Configuration.whitelistedDimensions.get();
            int strLen = rawStringofList.length();
            if (strLen < 2 || rawStringofList.charAt(0) != '[' || rawStringofList.charAt(strLen - 1) != ']') {
                BetterCaves.LOGGER.error("INVALID VALUE FOR SETTING 'Whitelisted Dimension IDs'. Using empty list instead...");
                BetterCaves.whitelistedDimensions = Lists.newArrayList();
                return;
            }
            ArrayList inputListOfDimensionStrings = Lists.newArrayList((Object[])rawStringofList.substring(1, strLen - 1).split(",\\s*"));
            ArrayList whitelistedDimensions = Lists.newArrayList();
            whitelistedDimensions.addAll(inputListOfDimensionStrings);
            BetterCaves.whitelistedDimensions = whitelistedDimensions;
        }
    }

    private static void convertImmutableFeatures(Biome biome) {
        if (biome.func_242440_e().field_242484_f instanceof ImmutableList) {
            biome.func_242440_e().field_242484_f = biome.func_242440_e().field_242484_f.stream().map(Lists::newArrayList).collect(Collectors.toList());
        }
    }

    private static <T> List<T> convertImmutableList(List<T> list) {
        return new ArrayList<T>(list);
    }
}

