/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.io.ConfigLoader;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.util.ColPos;
import com.yungnickyoung.minecraft.bettercaves.world.carver.bedrock.FlattenBedrock;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.CaveCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.CavernCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.RavineController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.WaterRegionController;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;

public class BetterCavesCarver {
    private ISeedReader world;
    public long seed = 0L;
    public ConfigHolder config;
    private CaveCarverController caveCarverController;
    private CavernCarverController cavernCarverController;
    private WaterRegionController waterRegionController;
    private RavineController ravineController;

    public void carve(IChunk chunkIn, int chunkX, int chunkZ) {
        BitSet airCarvingMask = ((ChunkPrimer)chunkIn).func_230345_b_(GenerationStage.Carving.AIR);
        BitSet liquidCarvingMask = ((ChunkPrimer)chunkIn).func_230345_b_(GenerationStage.Carving.LIQUID);
        if (this.config.flattenBedrock.get().booleanValue()) {
            FlattenBedrock.flattenBedrock(chunkIn, this.config.bedrockWidth.get());
        }
        int[][] surfaceAltitudes = new int[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                surfaceAltitudes[x][z] = this.config.overrideSurfaceDetection.get() != false ? 1 : Math.min(chunkIn.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, x, z), chunkIn.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z));
            }
        }
        HashMap<Long, Biome> biomeMap = new HashMap<Long, Biome>();
        for (int x = chunkX * 16 - 2; x <= chunkX * 16 + 17; ++x) {
            for (int z = chunkZ * 16 - 2; z <= chunkZ * 16 + 17; ++z) {
                ColPos pos = new ColPos(x, z);
                biomeMap.put(pos.toLong(), this.world.func_226691_t_(pos.toBlockPos()));
            }
        }
        BlockState[][] liquidBlocks = this.waterRegionController.getLiquidBlocksForChunk(chunkX, chunkZ);
        this.ravineController.carveChunk(chunkIn, chunkX, chunkZ, liquidBlocks, biomeMap, airCarvingMask, liquidCarvingMask);
        this.caveCarverController.carveChunk(chunkIn, chunkX, chunkZ, surfaceAltitudes, liquidBlocks, biomeMap, airCarvingMask, liquidCarvingMask);
        this.cavernCarverController.carveChunk(chunkIn, chunkX, chunkZ, surfaceAltitudes, liquidBlocks, biomeMap, airCarvingMask, liquidCarvingMask);
        ((ChunkPrimer)chunkIn).func_205767_a(GenerationStage.Carving.AIR, airCarvingMask);
        ((ChunkPrimer)chunkIn).func_205767_a(GenerationStage.Carving.LIQUID, liquidCarvingMask);
    }

    public void initialize(ISeedReader worldIn) {
        this.world = worldIn;
        this.seed = worldIn.func_72905_C();
        String dimensionName = "";
        try {
            dimensionName = Objects.requireNonNull(this.world.func_201672_e().func_234923_W_().func_240901_a_()).toString();
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! This could be a problem...");
        }
        this.config = dimensionName.equals("") ? new ConfigHolder() : ConfigLoader.loadConfigFromFileForDimension(dimensionName);
        this.caveCarverController = new CaveCarverController(worldIn, this.config);
        this.cavernCarverController = new CavernCarverController(worldIn, this.config);
        this.waterRegionController = new WaterRegionController(worldIn, this.config);
        this.ravineController = new RavineController(worldIn, this.config);
        BetterCaves.LOGGER.debug(String.format("BETTER CAVES WORLD CARVER INITIALIZED WITH SEED %d IN %s", this.seed, dimensionName));
    }

    public void setWorld(ISeedReader worldIn) {
        this.world = worldIn;
        this.caveCarverController.setWorld(worldIn);
        this.cavernCarverController.setWorld(worldIn);
        this.waterRegionController.setWorld(worldIn);
        this.ravineController.setWorld(worldIn);
    }

    public long getSeed() {
        return this.seed;
    }
}

