/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.init;

import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.init.BMStructurePieces;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftFeatureConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.BadlandsBiome;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DesertLakesBiome;
import net.minecraft.world.biome.IceSpikesBiome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class BMFeature {
    public static final Structure<BetterMineshaftFeatureConfig> betterMineshaft = new BetterMineshaftStructure(BetterMineshaftFeatureConfig::deserialize);

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BMFeature::registerFeature);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BMFeature::commonSetup);
    }

    public static void registerFeature(RegistryEvent.Register<Feature<?>> event) {
        if (event.getRegistry().getRegistryName().toString().equals("minecraft:feature")) {
            betterMineshaft.setRegistryName("minecraft:mineshaft");
            event.getRegistry().register(betterMineshaft);
        }
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            BMStructurePieces.init();
            Set biomesList = ForgeRegistries.BIOMES.getEntries();
            for (Map.Entry entry : biomesList) {
                Biome biome = (Biome)entry.getValue();
                if (!biome.func_201858_a(Feature.field_202329_g) || biome.func_201856_r() == Biome.Category.OCEAN || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) continue;
                BetterMineshaftStructure.Type type = biome.func_201856_r() == Biome.Category.MESA || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) ? (biome instanceof BadlandsBiome || BMFeature.isRare(biome) ? BMFeature.getType(BetterMineshaftStructure.Type.RED_DESERT) : BMFeature.getType(BetterMineshaftStructure.Type.MESA)) : (biome.func_201856_r() == Biome.Category.JUNGLE || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) ? BMFeature.getType(BetterMineshaftStructure.Type.JUNGLE) : (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || biome.func_201856_r() == Biome.Category.ICY || biome.func_201856_r() == Biome.Category.TAIGA ? (biome instanceof IceSpikesBiome || BMFeature.isRare(biome) ? BMFeature.getType(BetterMineshaftStructure.Type.ICE) : BMFeature.getType(BetterMineshaftStructure.Type.SNOW)) : (biome.func_201856_r() == Biome.Category.DESERT || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) ? (biome instanceof DesertLakesBiome || BMFeature.isRare(biome) ? BMFeature.getType(BetterMineshaftStructure.Type.RED_DESERT) : BMFeature.getType(BetterMineshaftStructure.Type.DESERT)) : (biome.func_201856_r() == Biome.Category.MUSHROOM || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) ? BMFeature.getType(BetterMineshaftStructure.Type.MUSHROOM) : (biome.func_201856_r() == Biome.Category.SAVANNA || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) ? BMFeature.getType(BetterMineshaftStructure.Type.SAVANNA) : BetterMineshaftStructure.Type.NORMAL)))));
                BetterMineshaftFeatureConfig config = new BetterMineshaftFeatureConfig(BMConfig.mineshaftSpawnRate, type);
                biome.func_226711_a_(betterMineshaft.func_225566_b_((IFeatureConfig)config));
            }
        });
    }

    private static BetterMineshaftStructure.Type getType(BetterMineshaftStructure.Type type) {
        if (type == BetterMineshaftStructure.Type.RED_DESERT) {
            if (BMConfig.redDesertEnabled) {
                return BetterMineshaftStructure.Type.RED_DESERT;
            }
            if (BMConfig.desertEnabled) {
                return BetterMineshaftStructure.Type.DESERT;
            }
        } else if (type == BetterMineshaftStructure.Type.DESERT) {
            if (BMConfig.desertEnabled) {
                return BetterMineshaftStructure.Type.DESERT;
            }
        } else if (type == BetterMineshaftStructure.Type.MESA) {
            if (BMConfig.mesaEnabled) {
                return BetterMineshaftStructure.Type.MESA;
            }
            if (BMConfig.redDesertEnabled) {
                return BetterMineshaftStructure.Type.RED_DESERT;
            }
        } else if (type == BetterMineshaftStructure.Type.ICE) {
            if (BMConfig.iceEnabled) {
                return BetterMineshaftStructure.Type.ICE;
            }
            if (BMConfig.snowEnabled) {
                return BetterMineshaftStructure.Type.SNOW;
            }
        } else if (type == BetterMineshaftStructure.Type.SNOW) {
            if (BMConfig.snowEnabled) {
                return BetterMineshaftStructure.Type.SNOW;
            }
        } else if (type == BetterMineshaftStructure.Type.JUNGLE) {
            if (BMConfig.jungleEnabled) {
                return BetterMineshaftStructure.Type.JUNGLE;
            }
        } else if (type == BetterMineshaftStructure.Type.SAVANNA) {
            if (BMConfig.savannaEnabled) {
                return BetterMineshaftStructure.Type.SAVANNA;
            }
        } else if (type == BetterMineshaftStructure.Type.MUSHROOM && BMConfig.mushroomEnabled) {
            return BetterMineshaftStructure.Type.MUSHROOM;
        }
        return BetterMineshaftStructure.Type.NORMAL;
    }

    private static boolean isRare(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RARE);
    }
}

