/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.bettermineshafts.util.BlockSetSelector;
import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;

public class BigTunnel
extends MineshaftPiece {
    private final List<BlockPos> smallShaftLeftEntrances = Lists.newLinkedList();
    private final List<BlockPos> smallShaftRightEntrances = Lists.newLinkedList();
    private final List<MutableBoundingBox> sideRoomEntrances = Lists.newLinkedList();
    private final List<Integer> bigSupports = Lists.newLinkedList();
    private final List<Integer> smallSupports = Lists.newLinkedList();
    private final List<Pair<Integer, Integer>> gravelDeposits = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 8;
    private static final int MAIN_AXIS_LEN = 24;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 7;
    private static final int LOCAL_Z_END = 23;
    private static final float SMALL_SHAFT_SPAWN_CHANCE = 0.07f;
    private static final float SIDE_ROOM_SPAWN_CHANCE = 0.025f;

    public BigTunnel(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.BIG_TUNNEL, compoundTag);
        int i;
        ListNBT listTag1 = compoundTag.func_150295_c("SmallShaftLeftEntrances", 11);
        ListNBT listTag2 = compoundTag.func_150295_c("SmallShaftRightEntrances", 11);
        ListNBT listTag3 = compoundTag.func_150295_c("SideRoomEntrances", 11);
        ListNBT listTag4 = compoundTag.func_150295_c("BigSupports", 3);
        ListNBT listTag5 = compoundTag.func_150295_c("SmallSupports", 3);
        ListNBT listTag6 = compoundTag.func_150295_c("GravelDeposits", 11);
        for (i = 0; i < listTag1.size(); ++i) {
            this.smallShaftLeftEntrances.add(new BlockPos(listTag1.func_150306_c(i)[0], listTag1.func_150306_c(i)[1], listTag1.func_150306_c(i)[2]));
        }
        for (i = 0; i < listTag2.size(); ++i) {
            this.smallShaftRightEntrances.add(new BlockPos(listTag2.func_150306_c(i)[0], listTag2.func_150306_c(i)[1], listTag2.func_150306_c(i)[2]));
        }
        for (i = 0; i < listTag3.size(); ++i) {
            this.sideRoomEntrances.add(new MutableBoundingBox(listTag3.func_150306_c(i)));
        }
        for (i = 0; i < listTag4.size(); ++i) {
            this.bigSupports.add(listTag4.func_186858_c(i));
        }
        for (i = 0; i < listTag5.size(); ++i) {
            this.smallSupports.add(listTag5.func_186858_c(i));
        }
        for (i = 0; i < listTag6.size(); ++i) {
            this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)listTag6.func_150306_c(i)[0], (Object)listTag6.func_150306_c(i)[1]));
        }
    }

    public BigTunnel(int i, int pieceChainLen, Random random, MutableBoundingBox blockBox, Direction direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.BIG_TUNNEL, i, pieceChainLen, type);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
        ListNBT listTag1 = new ListNBT();
        ListNBT listTag2 = new ListNBT();
        ListNBT listTag3 = new ListNBT();
        ListNBT listTag4 = new ListNBT();
        ListNBT listTag5 = new ListNBT();
        ListNBT listTag6 = new ListNBT();
        this.smallShaftLeftEntrances.forEach(pos -> listTag1.add((Object)new IntArrayNBT(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})));
        this.smallShaftRightEntrances.forEach(pos -> listTag2.add((Object)new IntArrayNBT(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})));
        this.sideRoomEntrances.forEach(blockBox -> listTag3.add((Object)blockBox.func_151535_h()));
        this.bigSupports.forEach(z -> listTag4.add((Object)IntNBT.func_229692_a_((int)z)));
        this.smallSupports.forEach(z -> listTag5.add((Object)IntNBT.func_229692_a_((int)z)));
        this.gravelDeposits.forEach(pair -> listTag6.add((Object)new IntArrayNBT(new int[]{(Integer)pair.getFirst(), (Integer)pair.getSecond()})));
        tag.func_218657_a("SmallShaftLeftEntrances", (INBT)listTag1);
        tag.func_218657_a("SmallShaftRightEntrances", (INBT)listTag2);
        tag.func_218657_a("SideRoomEntrances", (INBT)listTag3);
        tag.func_218657_a("BigSupports", (INBT)listTag4);
        tag.func_218657_a("SmallSupports", (INBT)listTag5);
        tag.func_218657_a("GravelDeposits", (INBT)listTag6);
    }

    public static MutableBoundingBox determineBoxPosition(int x, int y, int z, Direction direction) {
        return BoxUtil.boxFromCoordsWithRotation(x, y, z, 9, 8, 24, direction);
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, direction, this.func_74877_c(), this.pieceChainLen);
            }
        }
        int pieceLen = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? this.field_74887_e.func_78880_d() : this.field_74887_e.func_78883_b();
        this.buildSideRoomsLeft(structurePiece, list, random, direction, pieceLen);
        this.buildSideRoomsRight(structurePiece, list, random, direction, pieceLen);
        this.buildSmallShaftsLeft(structurePiece, list, random, direction, pieceLen);
        this.buildSmallShaftsRight(structurePiece, list, random, direction, pieceLen);
        this.buildSupports(random);
        this.buildGravelDeposits(random);
    }

    @ParametersAreNonnullByDefault
    public boolean func_225577_a_(IWorld world, ChunkGenerator<?> generator, Random random, MutableBoundingBox box, ChunkPos pos) {
        float chance = this.mineshaftType == BetterMineshaftStructure.Type.SNOW || this.mineshaftType == BetterMineshaftStructure.Type.ICE || this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM ? 0.95f : 0.6f;
        this.chanceReplaceNonAir(world, box, random, chance, 0, 0, 0, 8, 7, 23, this.getMainSelector());
        this.fill(world, box, 1, 1, 0, 7, 4, 23, field_202556_l);
        this.fill(world, box, 2, 4, 0, 6, 5, 23, field_202556_l);
        this.fill(world, box, 3, 6, 0, 5, 6, 23, field_202556_l);
        this.replaceAir(world, box, 1, 0, 0, 7, 0, 23, this.getMainBlock());
        if (this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
            this.chanceReplaceNonAir(world, box, random, 0.8f, 1, 0, 0, 7, 0, 23, Blocks.field_150391_bh.func_176223_P());
        }
        this.smallShaftLeftEntrances.forEach(entrancePos -> this.generateSmallShaftEntranceLeft(world, box, random, entrancePos.func_177958_n(), entrancePos.func_177956_o(), entrancePos.func_177952_p()));
        this.smallShaftRightEntrances.forEach(entrancePos -> this.generateSmallShaftEntranceRight(world, box, random, entrancePos.func_177958_n(), entrancePos.func_177956_o(), entrancePos.func_177952_p()));
        this.sideRoomEntrances.forEach(roomBox -> this.generateSideRoomOpening(world, box, (MutableBoundingBox)roomBox, random));
        this.generateLegs(world, box, random);
        this.generateRails(world, box, random);
        this.generateLanterns(world, box, random);
        this.generateChestCarts(world, box, random, LootTables.field_186424_f);
        this.generateTntCarts(world, box, random);
        this.bigSupports.forEach(z -> this.generateBigSupport(world, box, random, (int)z));
        this.smallSupports.forEach(z -> this.generateSmallSupport(world, box, random, (int)z));
        this.gravelDeposits.forEach(pair -> this.generateGravelDeposit(world, box, random, (Integer)pair.getFirst(), (Integer)pair.getSecond()));
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 8, 6, 23);
        this.addVines(world, box, random, this.getVineChance(), 1, 0, 1, 7, 7, 22);
        return true;
    }

    private void generateLegs(IWorld world, MutableBoundingBox box, Random random) {
        if (this.mineshaftType == BetterMineshaftStructure.Type.ICE || this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
            this.generateLegsVariant(world, box, random);
            return;
        }
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof FourWayBlock) {
            supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
        }
        BlockSetSelector selector = this.getLegSelector();
        this.generateLeg(world, random, 1, 0, selector);
        this.replaceAir(world, box, 1, -1, 1, 1, -1, 5, supportBlock);
        this.replaceAir(world, box, 1, -2, 1, 1, -2, 3, supportBlock);
        this.replaceAir(world, box, 1, -3, 1, 1, -3, 2, supportBlock);
        this.replaceAir(world, box, 1, -5, 1, 1, -4, 1, supportBlock);
        this.replaceAir(world, box, 1, -1, 6, 1, -1, 10, supportBlock);
        this.replaceAir(world, box, 1, -2, 8, 1, -2, 10, supportBlock);
        this.replaceAir(world, box, 1, -3, 9, 1, -3, 10, supportBlock);
        this.replaceAir(world, box, 1, -5, 10, 1, -4, 10, supportBlock);
        this.generateLeg(world, random, 1, 11, selector);
        this.generateLeg(world, random, 1, 12, selector);
        this.replaceAir(world, box, 1, -1, 13, 1, -1, 17, supportBlock);
        this.replaceAir(world, box, 1, -2, 13, 1, -2, 15, supportBlock);
        this.replaceAir(world, box, 1, -3, 13, 1, -3, 14, supportBlock);
        this.replaceAir(world, box, 1, -5, 13, 1, -4, 13, supportBlock);
        this.replaceAir(world, box, 1, -1, 18, 1, -1, 22, supportBlock);
        this.replaceAir(world, box, 1, -2, 20, 1, -2, 22, supportBlock);
        this.replaceAir(world, box, 1, -3, 21, 1, -3, 22, supportBlock);
        this.replaceAir(world, box, 1, -5, 22, 1, -4, 22, supportBlock);
        this.generateLeg(world, random, 1, 23, selector);
        this.generateLeg(world, random, 7, 0, selector);
        this.replaceAir(world, box, 7, -1, 1, 7, -1, 5, supportBlock);
        this.replaceAir(world, box, 7, -2, 1, 7, -2, 3, supportBlock);
        this.replaceAir(world, box, 7, -3, 1, 7, -3, 2, supportBlock);
        this.replaceAir(world, box, 7, -5, 1, 7, -4, 1, supportBlock);
        this.replaceAir(world, box, 7, -1, 6, 7, -1, 10, supportBlock);
        this.replaceAir(world, box, 7, -2, 8, 7, -2, 10, supportBlock);
        this.replaceAir(world, box, 7, -3, 9, 7, -3, 10, supportBlock);
        this.replaceAir(world, box, 7, -5, 10, 7, -4, 10, supportBlock);
        this.generateLeg(world, random, 7, 11, selector);
        this.generateLeg(world, random, 7, 12, selector);
        this.replaceAir(world, box, 7, -1, 13, 7, -1, 17, supportBlock);
        this.replaceAir(world, box, 7, -2, 13, 7, -2, 15, supportBlock);
        this.replaceAir(world, box, 7, -3, 13, 7, -3, 14, supportBlock);
        this.replaceAir(world, box, 7, -5, 13, 7, -4, 13, supportBlock);
        this.replaceAir(world, box, 7, -1, 18, 7, -1, 22, supportBlock);
        this.replaceAir(world, box, 7, -2, 20, 7, -2, 22, supportBlock);
        this.replaceAir(world, box, 7, -3, 21, 7, -3, 22, supportBlock);
        this.replaceAir(world, box, 7, -5, 22, 7, -4, 22, supportBlock);
        this.generateLeg(world, random, 7, 23, selector);
    }

    private void generateLegsVariant(IWorld world, MutableBoundingBox box, Random random) {
        BlockSetSelector selector = this.getLegSelector();
        for (int z = 0; z <= 23; z += 7) {
            this.generateLeg(world, random, 2, z + 1, selector);
            this.generateLeg(world, random, 6, z + 1, selector);
            this.replaceAir(world, box, random, 1, -1, z, 7, -1, z + 2, selector);
            this.replaceAir(world, box, random, 2, -1, z + 3, 2, -1, z + 3, selector);
            this.replaceAir(world, box, random, 6, -1, z + 3, 6, -1, z + 3, selector);
            this.replaceAir(world, box, random, 3, -1, z + 3, 5, -1, z + 6, selector);
            this.replaceAir(world, box, random, 2, -1, z + 6, 2, -1, z + 6, selector);
            this.replaceAir(world, box, random, 6, -1, z + 6, 6, -1, z + 6, selector);
            this.replaceAir(world, box, random, 2, -2, z, 2, -2, z, selector);
            this.replaceAir(world, box, random, 6, -2, z, 6, -2, z, selector);
            this.replaceAir(world, box, random, 2, -2, z + 2, 2, -2, z + 2, selector);
            this.replaceAir(world, box, random, 6, -2, z + 2, 6, -2, z + 2, selector);
            this.replaceAir(world, box, random, 1, -2, z + 1, 1, -2, z + 1, selector);
            this.replaceAir(world, box, random, 7, -2, z + 1, 7, -2, z + 1, selector);
            this.replaceAir(world, box, random, 3, -2, z + 1, 3, -2, z + 1, selector);
            this.replaceAir(world, box, random, 5, -2, z + 1, 5, -2, z + 1, selector);
        }
    }

    private void generateGravelDeposit(IWorld world, MutableBoundingBox box, Random random, int z, int side) {
        switch (side) {
            default: {
                this.replaceAir(world, box, 1, 1, z, 1, 2, z + 2, this.getGravel());
                this.replaceAir(world, box, 1, 3, z + 1, 1, 3 + random.nextInt(2), z + 1, this.getGravel());
                this.chanceReplaceAir(world, box, random, 0.5f, 1, 3, z, 1, 3, z + 2, this.getGravel());
                this.replaceAir(world, box, 2, 1, z + 1, 2, 2 + random.nextInt(2), z + 1, this.getGravel());
                this.replaceAir(world, box, 2, 1, z, 2, 1 + random.nextInt(2), z + 2, this.getGravel());
                this.chanceReplaceAir(world, box, random, 0.5f, 3, 1, z, 3, 1, z + 2, this.getGravel());
                break;
            }
            case 1: {
                this.replaceAir(world, box, 7, 1, z, 7, 2, z + 2, this.getGravel());
                this.replaceAir(world, box, 7, 3, z + 1, 7, 3 + random.nextInt(2), z + 1, this.getGravel());
                this.chanceReplaceAir(world, box, random, 0.5f, 7, 3, z, 7, 3, z + 2, this.getGravel());
                this.replaceAir(world, box, 6, 1, z + 1, 6, 2 + random.nextInt(2), z + 1, this.getGravel());
                this.replaceAir(world, box, 6, 1, z, 6, 1 + random.nextInt(2), z + 2, this.getGravel());
                this.chanceReplaceAir(world, box, random, 0.5f, 5, 1, z, 5, 1, z + 2, this.getGravel());
            }
        }
    }

    private void generateChestCarts(IWorld world, MutableBoundingBox box, Random random, ResourceLocation lootTableId) {
        for (int z = 0; z <= 23; ++z) {
            BlockPos blockPos;
            if (random.nextInt(100) != 0 || !box.func_175898_b((Vec3i)(blockPos = new BlockPos(this.func_74865_a(4, z), this.func_74862_a(1), this.func_74873_b(4, z)))) || world.func_180495_p(blockPos.func_177977_b()).func_196958_f()) continue;
            ChestMinecartEntity chestMinecartEntity = new ChestMinecartEntity(world.func_201672_e(), (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            chestMinecartEntity.func_184289_a(lootTableId, random.nextLong());
            world.func_217376_c((Entity)chestMinecartEntity);
        }
    }

    private void generateTntCarts(IWorld world, MutableBoundingBox box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            BlockPos blockPos;
            if (random.nextInt(400) != 0 || !box.func_175898_b((Vec3i)(blockPos = new BlockPos(this.func_74865_a(4, z), this.func_74862_a(1), this.func_74873_b(4, z)))) || world.func_180495_p(blockPos.func_177977_b()).func_196958_f()) continue;
            TNTMinecartEntity tntMinecartEntity = new TNTMinecartEntity(world.func_201672_e(), (double)((float)blockPos.func_177958_n() + 0.5f), (double)((float)blockPos.func_177956_o() + 0.5f), (double)((float)blockPos.func_177952_p() + 0.5f));
            world.func_217376_c((Entity)tntMinecartEntity);
        }
    }

    private void generateBigSupport(IWorld world, MutableBoundingBox box, Random random, int z) {
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof FourWayBlock) {
            supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
        }
        this.chanceFill(world, box, random, 0.6f, 1, 1, z, 2, 1, z + 2, this.getMainSlab());
        this.chanceFill(world, box, random, 0.6f, 6, 1, z, 7, 1, z + 2, this.getMainSlab());
        this.func_175811_a(world, this.getMainBlock(), 1, 1, z + 1, box);
        this.func_175811_a(world, this.getMainBlock(), 7, 1, z + 1, box);
        this.func_175811_a(world, this.getMainBlock(), 1, 4, z + 1, box);
        this.func_175811_a(world, this.getMainBlock(), 7, 4, z + 1, box);
        this.fill(world, box, 2, 5, z + 1, 6, 5, z + 1, this.getMainBlock());
        this.fill(world, box, 1, 2, z + 1, 1, 3, z + 1, this.getSupportBlock());
        this.fill(world, box, 7, 2, z + 1, 7, 3, z + 1, this.getSupportBlock());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 2, 5, z + 1, 6, 5, z + 1, supportBlock);
    }

    private void generateSmallSupport(IWorld world, MutableBoundingBox box, Random random, int z) {
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.func_177230_c() instanceof FourWayBlock) {
            supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((IProperty)WallBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)WallBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
        }
        this.func_175811_a(world, this.getMainBlock(), 2, 1, z, box);
        this.func_175811_a(world, this.getMainBlock(), 6, 1, z, box);
        this.func_175811_a(world, this.getSupportBlock(), 2, 2, z, box);
        this.func_175811_a(world, this.getSupportBlock(), 6, 2, z, box);
        this.func_175811_a(world, this.getMainBlock(), 2, 3, z, box);
        this.func_175811_a(world, this.getMainBlock(), 6, 3, z, box);
        this.fill(world, box, 3, 4, z, 5, 4, z, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.5f, 3, 4, z, 5, 4, z, supportBlock);
        this.chanceFill(world, box, random, 0.4f, 2, 3, z, 6, 3, z, supportBlock);
        this.func_175811_a(world, supportBlock, 3, 3, z, box);
        this.func_175811_a(world, supportBlock, 5, 3, z, box);
    }

    private void generateLanterns(IWorld world, MutableBoundingBox box, Random random) {
        BlockState LANTERN = (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((IProperty)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true));
        for (int z = 0; z <= 23; ++z) {
            for (int x = 3; x <= 5; ++x) {
                if (random.nextInt(150) != 0 || this.func_175807_a((IBlockReader)world, x, 7, z, box).func_196958_f()) continue;
                this.func_175811_a(world, LANTERN, x, 6, z, box);
                z += 20;
            }
        }
    }

    private void generateRails(IWorld world, MutableBoundingBox box, Random random) {
        this.chanceFill(world, box, random, 0.5f, 4, 1, 0, 4, 1, 23, Blocks.field_150448_aq.func_176223_P());
        int blocksSinceLastRail = 0;
        for (int n = 0; n <= 23; ++n) {
            if (random.nextInt(20) != 0 && ++blocksSinceLastRail <= 25) continue;
            this.func_175811_a(world, (BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((IProperty)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(true)), 4, 1, n, box);
            blocksSinceLastRail = 0;
        }
    }

    private void generateSmallShaftEntranceRight(IWorld world, MutableBoundingBox box, Random random, int x, int y, int z) {
        this.replaceAir(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
        this.fill(world, box, x + 1, y, z, x + 1, y, z + 2, field_202556_l);
        this.func_175811_a(world, this.getSupportBlock(), x + 1, y + 1, z, box);
        this.func_175811_a(world, this.getSupportBlock(), x + 1, y + 1, z + 2, box);
        this.fill(world, box, x, y, z, x, y + 1, z, this.getSupportBlock());
        this.fill(world, box, x, y, z + 2, x, y + 1, z + 2, this.getSupportBlock());
        this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
        this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, field_202556_l);
    }

    private void generateSmallShaftEntranceLeft(IWorld world, MutableBoundingBox box, Random random, int x, int y, int z) {
        this.fill(world, box, x, y, z, x, y, z + 2, field_202556_l);
        this.func_175811_a(world, this.getSupportBlock(), x, y + 1, z, box);
        this.func_175811_a(world, this.getSupportBlock(), x, y + 1, z + 2, box);
        this.fill(world, box, x + 1, y, z, x + 1, y + 1, z, this.getSupportBlock());
        this.fill(world, box, x + 1, y, z + 2, x + 1, y + 1, z + 2, this.getSupportBlock());
        this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
        this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, field_202556_l);
        this.replaceAir(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
    }

    private void generateSideRoomOpening(IWorld world, MutableBoundingBox chunkBox, MutableBoundingBox entranceBox, Random random) {
        this.replaceAir(world, chunkBox, random, entranceBox.field_78897_a, 0, entranceBox.field_78896_c, entranceBox.field_78893_d, 0, entranceBox.field_78892_f, this.getBrickSelector());
        switch (random.nextInt(3)) {
            case 0: {
                this.fill(world, chunkBox, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 2, entranceBox.field_78893_d, entranceBox.field_78894_e, entranceBox.field_78892_f - 2, field_202556_l);
                return;
            }
            case 1: {
                this.fill(world, chunkBox, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 2, entranceBox.field_78893_d, entranceBox.field_78894_e - 1, entranceBox.field_78896_c + 2, field_202556_l);
                this.fill(world, chunkBox, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 4, entranceBox.field_78893_d, entranceBox.field_78894_e - 1, entranceBox.field_78896_c + 5, field_202556_l);
                this.fill(world, chunkBox, entranceBox.field_78897_a, entranceBox.field_78895_b, entranceBox.field_78896_c + 7, entranceBox.field_78893_d, entranceBox.field_78894_e - 1, entranceBox.field_78896_c + 7, field_202556_l);
                return;
            }
        }
    }

    private void buildGravelDeposits(Random random) {
        for (int z = 0; z <= 21; ++z) {
            int r = random.nextInt(20);
            int currPos = z;
            if (r == 0) {
                this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)currPos, (Object)0));
                z += 5;
                continue;
            }
            if (r != 1) continue;
            this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)currPos, (Object)1));
            z += 5;
        }
    }

    private void buildSupports(Random random) {
        int counter = 0;
        int MAX_COUNT = 10;
        for (int z = 0; z <= 21; ++z) {
            ++counter;
            boolean blockingEntrance = false;
            for (BlockPos entrancePos : this.smallShaftLeftEntrances) {
                if (entrancePos.func_177952_p() > z + 2 || z > entrancePos.func_177952_p() + 2) continue;
                blockingEntrance = true;
                break;
            }
            for (BlockPos entrancePos : this.smallShaftRightEntrances) {
                if (entrancePos.func_177952_p() > z + 2 || z > entrancePos.func_177952_p() + 2) continue;
                blockingEntrance = true;
                break;
            }
            if (blockingEntrance) continue;
            int r = random.nextInt(8);
            if (r == 0 || counter >= 10) {
                this.bigSupports.add(z);
                counter = 0;
                z += 3;
                continue;
            }
            if (r != 1) continue;
            this.smallSupports.add(z);
            counter = 0;
            z += 3;
        }
    }

    private void buildSideRoomsLeft(StructurePiece structurePiece, List<StructurePiece> list, Random random, Direction direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!(random.nextFloat() < 0.025f)) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n - 9, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n + 9, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n - 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n + 9, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(0, 1, n, 0, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSideRoomsRight(StructurePiece structurePiece, List<StructurePiece> list, Random random, Direction direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!(random.nextFloat() < 0.025f)) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 5, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 5, nextPieceDirection, this.func_74877_c(), this.pieceChainLen);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new MutableBoundingBox(8, 1, n, 8, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSmallShaftsLeft(StructurePiece structurePiece, List<StructurePiece> list, Random random, Direction direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 4; ++n) {
            if (!(random.nextFloat() < 0.07f)) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n + 1));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n + 1));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n + 1));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n + 1));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }

    private void buildSmallShaftsRight(StructurePiece structurePiece, List<StructurePiece> list, Random random, Direction direction, int pieceLen) {
        for (int n = 5; n < pieceLen; ++n) {
            if (!(random.nextFloat() < 0.07f)) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n - 3));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + n, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n - 3));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n - 3));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, nextPieceDirection, this.func_74877_c(), 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n - 3));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }
}

