/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.ImmutableSet;
import com.yungnickyoung.minecraft.bettermineshafts.util.BlockSetSelector;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CactusBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public abstract class MineshaftPiece
extends StructurePiece {
    public BetterMineshaftStructure.Type mineshaftType;
    protected int pieceChainLen;
    private static final Set<Material> LIQUIDS = ImmutableSet.of((Object)Material.field_151587_i, (Object)Material.field_151586_h);

    public MineshaftPiece(IStructurePieceType structurePieceType, int i, int pieceChainLen, BetterMineshaftStructure.Type type) {
        super(structurePieceType, i);
        this.mineshaftType = type;
        this.pieceChainLen = pieceChainLen;
    }

    public MineshaftPiece(IStructurePieceType structurePieceType, CompoundNBT compoundTag) {
        super(structurePieceType, compoundTag);
        this.mineshaftType = BetterMineshaftStructure.Type.byIndex(compoundTag.func_74762_e("MST"));
    }

    protected void toNbt(CompoundNBT tag) {
        tag.func_74768_a("MST", this.mineshaftType.ordinal());
    }

    public void setBoundingBox(MutableBoundingBox boundingBox) {
        this.field_74887_e = boundingBox;
    }

    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
    }

    protected BlockSetSelector getMainSelector() {
        switch (this.mineshaftType) {
            case MESA: {
                return BlockSetSelector.MESA;
            }
            case JUNGLE: {
                return BlockSetSelector.JUNGLE;
            }
            case SNOW: {
                return BlockSetSelector.SNOW;
            }
            case ICE: {
                return BlockSetSelector.ICE;
            }
            case DESERT: {
                return BlockSetSelector.DESERT;
            }
            case RED_DESERT: {
                return BlockSetSelector.RED_DESERT;
            }
            case MUSHROOM: {
                return BlockSetSelector.MUSHROOM;
            }
            case SAVANNA: {
                return BlockSetSelector.ACACIA;
            }
        }
        return BlockSetSelector.NORMAL;
    }

    protected BlockSetSelector getBrickSelector() {
        switch (this.mineshaftType) {
            case JUNGLE: {
                return BlockSetSelector.STONE_BRICK_JUNGLE;
            }
            case SNOW: {
                return BlockSetSelector.STONE_BRICK_SNOW;
            }
            case ICE: {
                return BlockSetSelector.STONE_BRICK_ICE;
            }
            case DESERT: {
                return BlockSetSelector.STONE_BRICK_DESERT;
            }
            case RED_DESERT: {
                return BlockSetSelector.STONE_BRICK_RED_DESERT;
            }
            case MUSHROOM: {
                return BlockSetSelector.STONE_BRICK_MUSHROOM;
            }
        }
        return BlockSetSelector.STONE_BRICK_NORMAL;
    }

    protected BlockSetSelector getLegSelector() {
        switch (this.mineshaftType) {
            case MESA: {
                return BlockSetSelector.from((BlockState)Blocks.field_203209_W.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            }
            case JUNGLE: {
                return BlockSetSelector.from((BlockState)Blocks.field_203207_U.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            }
            case SNOW: {
                return BlockSetSelector.from((BlockState)Blocks.field_203205_S.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            }
            case ICE: {
                return BlockSetSelector.STONE_BRICK_ICE;
            }
            case DESERT: {
                return BlockSetSelector.STONE_BRICK_DESERT;
            }
            case RED_DESERT: {
                return BlockSetSelector.STONE_BRICK_RED_DESERT;
            }
            case MUSHROOM: {
                return BlockSetSelector.STONE_BRICK_MUSHROOM;
            }
            case SAVANNA: {
                return BlockSetSelector.from((BlockState)Blocks.field_203208_V.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            }
        }
        return BlockSetSelector.from((BlockState)Blocks.field_203204_R.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
    }

    protected BlockState getMainBlock() {
        switch (this.mineshaftType) {
            case MESA: {
                return Blocks.field_196672_s.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_196668_q.func_176223_P();
            }
            case SNOW: {
                return Blocks.field_196664_o.func_176223_P();
            }
            case ICE: {
                return Blocks.field_205164_gk.func_176223_P();
            }
            case DESERT: {
                return Blocks.field_150322_A.func_176223_P();
            }
            case RED_DESERT: {
                return Blocks.field_180395_cM.func_176223_P();
            }
            case MUSHROOM: {
                return Blocks.field_150419_aX.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_196670_r.func_176223_P();
            }
        }
        return Blocks.field_196662_n.func_176223_P();
    }

    protected BlockState getSupportBlock() {
        switch (this.mineshaftType) {
            case MESA: {
                return Blocks.field_180406_aS.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_180403_aR.func_176223_P();
            }
            case SNOW: {
                return Blocks.field_180408_aP.func_176223_P();
            }
            case ICE: {
                return Blocks.field_205164_gk.func_176223_P();
            }
            case DESERT: {
                return Blocks.field_222417_lF.func_176223_P();
            }
            case RED_DESERT: {
                return Blocks.field_222461_ly.func_176223_P();
            }
            case MUSHROOM: {
                return Blocks.field_196706_do.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_180405_aT.func_176223_P();
            }
        }
        return Blocks.field_180407_aO.func_176223_P();
    }

    protected BlockState getMainSlab() {
        switch (this.mineshaftType) {
            case MESA: {
                return Blocks.field_196635_bv.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_196630_bt.func_176223_P();
            }
            case SNOW: {
                return Blocks.field_196624_br.func_176223_P();
            }
            case ICE: {
                return Blocks.field_205164_gk.func_176223_P();
            }
            case DESERT: {
                return Blocks.field_196640_bx.func_176223_P();
            }
            case RED_DESERT: {
                return Blocks.field_196578_bE.func_176223_P();
            }
            case MUSHROOM: {
                return Blocks.field_150420_aW.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_196632_bu.func_176223_P();
            }
        }
        return Blocks.field_196622_bq.func_176223_P();
    }

    protected BlockState getBrickBlock() {
        switch (this.mineshaftType) {
            case SNOW: {
                return Blocks.field_196604_cC.func_176223_P();
            }
            case ICE: {
                return Blocks.field_205164_gk.func_176223_P();
            }
            case DESERT: {
                return Blocks.field_150322_A.func_176223_P();
            }
            case RED_DESERT: {
                return Blocks.field_180395_cM.func_176223_P();
            }
            case MUSHROOM: {
                return Blocks.field_150419_aX.func_176223_P();
            }
        }
        return Blocks.field_196696_di.func_176223_P();
    }

    protected BlockState getGravel() {
        switch (this.mineshaftType) {
            case DESERT: {
                return Blocks.field_150354_m.func_176223_P();
            }
            case RED_DESERT: {
                return Blocks.field_196611_F.func_176223_P();
            }
            case SNOW: 
            case ICE: {
                return Blocks.field_196604_cC.func_176223_P();
            }
        }
        return Blocks.field_150351_n.func_176223_P();
    }

    protected BlockState getMainDoorwayWall() {
        switch (this.mineshaftType) {
            case SNOW: {
                return Blocks.field_196604_cC.func_176223_P();
            }
            case ICE: {
                return Blocks.field_205164_gk.func_176223_P();
            }
            case DESERT: {
                return Blocks.field_222417_lF.func_176223_P();
            }
            case RED_DESERT: {
                return Blocks.field_222461_ly.func_176223_P();
            }
            case MUSHROOM: {
                return Blocks.field_196706_do.func_176223_P();
            }
        }
        return Blocks.field_222413_lB.func_176223_P();
    }

    protected BlockState getMainDoorwaySlab() {
        switch (this.mineshaftType) {
            case SNOW: {
                return Blocks.field_196604_cC.func_176223_P();
            }
            case ICE: {
                return Blocks.field_205164_gk.func_176223_P();
            }
            case DESERT: {
                return (BlockState)Blocks.field_196640_bx.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
            }
            case RED_DESERT: {
                return (BlockState)Blocks.field_196578_bE.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
            }
            case MUSHROOM: {
                return Blocks.field_196706_do.func_176223_P();
            }
        }
        return (BlockState)Blocks.field_196573_bB.func_176223_P().func_206870_a((IProperty)SlabBlock.field_196505_a, (Comparable)SlabType.TOP);
    }

    protected BlockState getTrapdoor() {
        switch (this.mineshaftType) {
            case MESA: 
            case RED_DESERT: {
                return Blocks.field_196684_db.func_176223_P();
            }
            case JUNGLE: {
                return Blocks.field_196644_cZ.func_176223_P();
            }
            case SNOW: 
            case ICE: {
                return Blocks.field_196638_cX.func_176223_P();
            }
            case SAVANNA: {
                return Blocks.field_196682_da.func_176223_P();
            }
        }
        return Blocks.field_196636_cW.func_176223_P();
    }

    protected float getVineChance() {
        switch (this.mineshaftType) {
            case JUNGLE: {
                return 0.6f;
            }
        }
        return 0.25f;
    }

    protected boolean addBarrel(IWorld world, MutableBoundingBox boundingBox, Random random, BlockPos pos, ResourceLocation lootTableId) {
        if (boundingBox.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_222422_lK) {
            world.func_180501_a(pos, (BlockState)Blocks.field_222422_lK.func_176223_P().func_206870_a((IProperty)BarrelBlock.field_220092_a, (Comparable)Direction.UP), 2);
            TileEntity blockEntity = world.func_175625_s(pos);
            if (blockEntity instanceof BarrelTileEntity) {
                ((BarrelTileEntity)blockEntity).func_189404_a(lootTableId, random.nextLong());
            }
            return true;
        }
        return false;
    }

    protected boolean addBarrel(IWorld world, MutableBoundingBox boundingBox, Random random, int x, int y, int z, ResourceLocation lootTableId) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        return this.addBarrel(world, boundingBox, random, blockPos, lootTableId);
    }

    protected void addVines(IWorld world, MutableBoundingBox boundingBox, Direction facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.func_181079_c(x, y, z);
                    BlockState nextBlock = this.func_175807_a((IBlockReader)world, x + facing.func_82601_c(), y + facing.func_96559_d(), z + facing.func_82599_e(), boundingBox);
                    if (!this.func_175807_a((IBlockReader)world, x, y, z, boundingBox).func_196958_f() || !Block.func_208061_a((VoxelShape)nextBlock.func_196952_d((IBlockReader)world, (BlockPos)mutable), (Direction)facing.func_176734_d()) || nextBlock.func_177230_c().func_176223_P() == Blocks.field_150468_ap.func_176223_P() || !(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((IProperty)VineBlock.func_176267_a((Direction)(facing.func_176740_k() == Direction.Axis.X ? facing : facing.func_176734_d())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(IWorld world, MutableBoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.addVines(world, boundingBox, Direction.EAST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.WEST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.NORTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.SOUTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(IWorld world, MutableBoundingBox box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    float r;
                    BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                    if (this.mineshaftType == BetterMineshaftStructure.Type.SNOW) {
                        if (this.func_175807_a((IBlockReader)world, x, y, z, box) != field_202556_l || !Blocks.field_150433_aE.func_196260_a(field_202556_l, (IWorldReader)world, blockPos)) continue;
                        this.func_175811_a(world, (BlockState)Blocks.field_150433_aE.func_176223_P().func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                        continue;
                    }
                    if (this.mineshaftType == BetterMineshaftStructure.Type.DESERT || this.mineshaftType == BetterMineshaftStructure.Type.RED_DESERT) {
                        r = random.nextFloat();
                        if (r < 0.1f) {
                            if (this.func_175807_a((IBlockReader)world, x, y, z, box) != field_202556_l || !Blocks.field_150434_aF.func_196260_a(field_202556_l, (IWorldReader)world, blockPos)) continue;
                            this.func_175811_a(world, (BlockState)Blocks.field_150434_aF.func_176223_P().func_206870_a((IProperty)CactusBlock.field_176587_a, (Comparable)Integer.valueOf(0)), x, y, z, box);
                            continue;
                        }
                        if (!(r < 0.2f)) continue;
                        Block floor = this.func_175807_a((IBlockReader)world, x, y - 1, z, box).func_177230_c();
                        if (this.func_175807_a((IBlockReader)world, x, y, z, box) != field_202556_l || floor != Blocks.field_150354_m && floor != Blocks.field_196611_F && floor != Blocks.field_150405_ch && floor != Blocks.field_196777_fo && floor != Blocks.field_196778_fp && floor != Blocks.field_196783_fs && floor != Blocks.field_196719_fA && floor != Blocks.field_150346_d) continue;
                        this.func_175811_a(world, Blocks.field_196555_aI.func_176223_P(), x, y, z, box);
                        continue;
                    }
                    if (this.mineshaftType == BetterMineshaftStructure.Type.MESA) {
                        if (!(random.nextFloat() < 0.1f)) continue;
                        Block floor = this.func_175807_a((IBlockReader)world, x, y - 1, z, box).func_177230_c();
                        if (this.func_175807_a((IBlockReader)world, x, y, z, box) != field_202556_l || floor != Blocks.field_150354_m && floor != Blocks.field_196611_F && floor != Blocks.field_150405_ch && floor != Blocks.field_196777_fo && floor != Blocks.field_196778_fp && floor != Blocks.field_196783_fs && floor != Blocks.field_196719_fA && floor != Blocks.field_150346_d) continue;
                        this.func_175811_a(world, Blocks.field_196555_aI.func_176223_P(), x, y, z, box);
                        continue;
                    }
                    if (this.mineshaftType != BetterMineshaftStructure.Type.MUSHROOM) continue;
                    r = random.nextFloat();
                    if (r < 0.2f) {
                        if (this.func_175807_a((IBlockReader)world, x, y, z, box) != field_202556_l || !Blocks.field_150337_Q.func_196260_a(field_202556_l, (IWorldReader)world, blockPos)) continue;
                        this.func_175811_a(world, Blocks.field_150337_Q.func_176223_P(), x, y, z, box);
                        continue;
                    }
                    if (!(r < 0.4f) || this.func_175807_a((IBlockReader)world, x, y, z, box) != field_202556_l || !Blocks.field_150338_P.func_196260_a(field_202556_l, (IWorldReader)world, blockPos)) continue;
                    this.func_175811_a(world, Blocks.field_150338_P.func_176223_P(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(IWorld world, Random random, int x, int z, BlockSetSelector selector) {
        BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(-1), this.func_74873_b(x, z));
        while (mutable.func_177956_o() > 0 && (world.func_180495_p((BlockPos)mutable) == field_202556_l || LIQUIDS.contains(world.func_180495_p((BlockPos)mutable).func_185904_a()))) {
            world.func_180501_a((BlockPos)mutable, selector.get(random), 2);
            mutable.func_189536_c(Direction.DOWN);
        }
    }

    protected void fill(IWorld world, MutableBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void fill(IWorld world, MutableBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(IWorld world, MutableBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceAir(IWorld world, MutableBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(IWorld world, MutableBoundingBox blockBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void replaceNonAir(IWorld world, MutableBoundingBox blockBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox);
                    if (currState == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(IWorld world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceFill(IWorld world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(IWorld world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(IWorld world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || !currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(IWorld world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, blockState, x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(IWorld world, MutableBoundingBox blockBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockStateFromPosFixed((IBlockReader)world, x, y, z, blockBox)) == null || currState.func_196958_f()) continue;
                    this.func_175811_a(world, selector.get(random), x, y, z, blockBox);
                }
            }
        }
    }

    protected void chanceAddBlock(IWorld world, Random random, float chance, BlockState block, int x, int y, int z, MutableBoundingBox blockBox) {
        if (random.nextFloat() < chance) {
            this.func_175811_a(world, block, x, y, z, blockBox);
        }
    }

    protected BlockState getBlockStateFromPosFixed(IBlockReader blockView, int x, int y, int z, MutableBoundingBox blockBox) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        BlockPos blockPos = new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z));
        return !blockBox.func_175898_b((Vec3i)blockPos) ? null : blockView.func_180495_p(blockPos);
    }

    protected boolean method_14719(IBlockReader blockView, MutableBoundingBox blockBox, int xMin, int xMax, int y, int z) {
        for (int x = xMin; x <= xMax; ++x) {
            if (!this.func_175807_a(blockView, x, y + 1, z, blockBox).func_196958_f()) continue;
            return false;
        }
        return true;
    }
}

