/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.init;

import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.init.ModStructurePieces;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.BadlandsBiome;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DesertLakesBiome;
import net.minecraft.world.biome.IceSpikesBiome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"minecraft");
    public static final RegistryObject<Structure<BetterMineshaftConfig>> BETTERMINESHAFT = ModStructures.register("Mineshaft", new BetterMineshaftStructure(BetterMineshaftConfig.field_236541_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES);

    private static <T extends Structure<?>> RegistryObject<T> register(String name, T structure, GenerationStage.Decoration stage) {
        Structure.field_236385_u_.put(structure, stage);
        Structure.field_236365_a_.put((Object)name, structure);
        return STRUCTURES.register(name.toLowerCase(Locale.ROOT), () -> structure);
    }

    public static void init() {
        STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModStructures::commonSetup);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            ModStructurePieces.init();
            Set biomesList = ForgeRegistries.BIOMES.getEntries();
            for (Map.Entry entry : biomesList) {
                Biome biome = (Biome)entry.getValue();
                if (!biome.func_201858_a(Structure.field_236367_c_)) continue;
                biome.field_201874_aj.remove(Structure.field_236367_c_);
                BetterMineshaftStructure.Type type = biome.func_201856_r() == Biome.Category.MESA || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA) ? (biome instanceof BadlandsBiome || ModStructures.isRare(biome) ? ModStructures.getType(BetterMineshaftStructure.Type.RED_DESERT) : ModStructures.getType(BetterMineshaftStructure.Type.MESA)) : (biome.func_201856_r() == Biome.Category.JUNGLE || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) ? ModStructures.getType(BetterMineshaftStructure.Type.JUNGLE) : (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || biome.func_201856_r() == Biome.Category.ICY || biome.func_201856_r() == Biome.Category.TAIGA ? (biome instanceof IceSpikesBiome || ModStructures.isRare(biome) ? ModStructures.getType(BetterMineshaftStructure.Type.ICE) : ModStructures.getType(BetterMineshaftStructure.Type.SNOW)) : (biome.func_201856_r() == Biome.Category.DESERT || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) ? (biome instanceof DesertLakesBiome || ModStructures.isRare(biome) ? ModStructures.getType(BetterMineshaftStructure.Type.RED_DESERT) : ModStructures.getType(BetterMineshaftStructure.Type.DESERT)) : (biome.func_201856_r() == Biome.Category.MUSHROOM || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM) ? ModStructures.getType(BetterMineshaftStructure.Type.MUSHROOM) : (biome.func_201856_r() == Biome.Category.SAVANNA || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA) ? ModStructures.getType(BetterMineshaftStructure.Type.SAVANNA) : BetterMineshaftStructure.Type.NORMAL)))));
                BetterMineshaftConfig config = new BetterMineshaftConfig(BMConfig.mineshaftSpawnRate, type);
                biome.func_235063_a_(((Structure)BETTERMINESHAFT.get()).func_236391_a_((IFeatureConfig)config));
            }
        });
    }

    private static BetterMineshaftStructure.Type getType(BetterMineshaftStructure.Type type) {
        if (type == BetterMineshaftStructure.Type.RED_DESERT) {
            if (BMConfig.redDesertEnabled) {
                return BetterMineshaftStructure.Type.RED_DESERT;
            }
            if (BMConfig.desertEnabled) {
                return BetterMineshaftStructure.Type.DESERT;
            }
        } else if (type == BetterMineshaftStructure.Type.DESERT) {
            if (BMConfig.desertEnabled) {
                return BetterMineshaftStructure.Type.DESERT;
            }
        } else if (type == BetterMineshaftStructure.Type.MESA) {
            if (BMConfig.mesaEnabled) {
                return BetterMineshaftStructure.Type.MESA;
            }
            if (BMConfig.redDesertEnabled) {
                return BetterMineshaftStructure.Type.RED_DESERT;
            }
        } else if (type == BetterMineshaftStructure.Type.ICE) {
            if (BMConfig.iceEnabled) {
                return BetterMineshaftStructure.Type.ICE;
            }
            if (BMConfig.snowEnabled) {
                return BetterMineshaftStructure.Type.SNOW;
            }
        } else if (type == BetterMineshaftStructure.Type.SNOW) {
            if (BMConfig.snowEnabled) {
                return BetterMineshaftStructure.Type.SNOW;
            }
        } else if (type == BetterMineshaftStructure.Type.JUNGLE) {
            if (BMConfig.jungleEnabled) {
                return BetterMineshaftStructure.Type.JUNGLE;
            }
        } else if (type == BetterMineshaftStructure.Type.SAVANNA) {
            if (BMConfig.savannaEnabled) {
                return BetterMineshaftStructure.Type.SAVANNA;
            }
        } else if (type == BetterMineshaftStructure.Type.MUSHROOM && BMConfig.mushroomEnabled) {
            return BetterMineshaftStructure.Type.MUSHROOM;
        }
        return BetterMineshaftStructure.Type.NORMAL;
    }

    private static boolean isRare(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RARE);
    }
}

