/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

@MethodsReturnNonnullByDefault
public class BetterMineshaftStructure
extends Structure<BetterMineshaftConfig> {
    public BetterMineshaftStructure(Codec<BetterMineshaftConfig> codec) {
        super(codec);
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long seed, SharedSeedRandom random, int x, int z, Biome biome, ChunkPos chunkPos, BetterMineshaftConfig config) {
        random.func_202425_c(seed, x, z);
        return random.nextDouble() < config.probability;
    }

    public Structure.IStartFactory<BetterMineshaftConfig> func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return "Mineshaft";
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("normal"),
        MESA("mesa"),
        JUNGLE("jungle"),
        SNOW("snow"),
        ICE("ice"),
        DESERT("desert"),
        RED_DESERT("red_desert"),
        SAVANNA("savanna"),
        MUSHROOM("mushroom");

        public static final Codec<Type> field_236324_c_;
        private static final Map<String, Type> BY_NAME;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Type byName(String p_214715_0_) {
            return BY_NAME.get(p_214715_0_);
        }

        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : NORMAL;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            field_236324_c_ = IStringSerializable.func_233023_a_(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, type -> type));
        }
    }

    public static class Start
    extends StructureStart<BetterMineshaftConfig> {
        public Start(Structure<BetterMineshaftConfig> structureFeature, int chunkX, int chunkZ, MutableBoundingBox blockBox, int i, long l) {
            super(structureFeature, chunkX, chunkZ, blockBox, i, l);
        }

        @ParametersAreNonnullByDefault
        public void func_230364_a_(ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, BetterMineshaftConfig config) {
            Direction direction = Direction.NORTH;
            SharedSeedRandom rand = new SharedSeedRandom();
            rand.func_202422_a(chunkX, chunkZ);
            int r = rand.nextInt(4);
            switch (r) {
                case 0: {
                    direction = Direction.NORTH;
                    break;
                }
                case 1: {
                    direction = Direction.SOUTH;
                    break;
                }
                case 2: {
                    direction = Direction.EAST;
                    break;
                }
                case 3: {
                    direction = Direction.WEST;
                }
            }
            int y = this.field_214631_d.nextInt(BMConfig.maxY - BMConfig.minY + 1) + BMConfig.minY;
            BlockPos.Mutable startingPos = new BlockPos.Mutable((chunkX << 4) + 2, y, (chunkZ << 4) + 2);
            VerticalEntrance entryPoint = new VerticalEntrance(0, -1, (Random)this.field_214631_d, startingPos, direction, config.type);
            this.field_75075_a.add(entryPoint);
            ((MineshaftPiece)entryPoint).func_74861_a(entryPoint, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }
    }
}

