/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SideRoomDungeon
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 4;
    private static final int MAIN_AXIS_LEN = 9;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 3;
    private static final int LOCAL_Z_END = 8;

    public SideRoomDungeon(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM_DUNGEON, compoundTag);
    }

    public SideRoomDungeon(int i, int pieceChainLen, Random random, MutableBoundingBox blockBox, Direction direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM_DUNGEON, i, pieceChainLen, type);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = new MutableBoundingBox(x, y, z, x, y + 4 - 1, z);
        switch (direction) {
            default: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78897_a = x - 4;
                blockBox.field_78896_c = z - 8;
                break;
            }
            case SOUTH: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78897_a = x - 4;
                blockBox.field_78892_f = z + 8;
                break;
            }
            case WEST: {
                blockBox.field_78897_a = x - 8;
                blockBox.field_78892_f = z + 4;
                blockBox.field_78896_c = z - 4;
                break;
            }
            case EAST: {
                blockBox.field_78893_d = x + 8;
                blockBox.field_78892_f = z + 4;
                blockBox.field_78896_c = z - 4;
            }
        }
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        this.fill((IWorld)world, box, random, 0, 0, 0, 8, 3, 8, this.getBrickSelector());
        this.fill((IWorld)world, box, 1, 1, 1, 7, 2, 7, field_202556_l);
        this.generateLegs((IWorld)world, random);
        BlockState LADDER = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)Direction.NORTH);
        this.fill((IWorld)world, box, 4, 1, 1, 4, 3, 1, LADDER);
        BlockPos spawnerPos = new BlockPos(this.func_74865_a(4, 5), this.func_74862_a(1), this.func_74873_b(4, 5));
        world.func_180501_a(spawnerPos, Blocks.field_150474_ac.func_176223_P(), 2);
        TileEntity blockEntity = world.func_175625_s(spawnerPos);
        if (blockEntity instanceof MobSpawnerTileEntity) {
            ((MobSpawnerTileEntity)blockEntity).func_145881_a().func_200876_a(EntityType.field_200794_h);
        }
        this.chanceReplaceAir((IWorld)world, box, random, 0.9f, 3, 1, 4, 5, 2, 6, Blocks.field_196553_aF.func_176223_P());
        this.chanceReplaceAir((IWorld)world, box, random, 0.1f, 1, 1, 1, 7, 2, 8, Blocks.field_196553_aF.func_176223_P());
        this.func_186167_a((IWorld)world, box, random, 1, 1, 7, LootTables.field_186424_f);
        if (random.nextInt(2) == 0) {
            this.func_186167_a((IWorld)world, box, random, 7, 1, 7, LootTables.field_186428_j);
        }
        this.addBiomeDecorations((IWorld)world, box, random, 0, 0, 0, 8, 2, 8);
        return true;
    }

    private void generateLegs(IWorld world, Random random) {
        this.generateLeg(world, random, 1, 1, this.getBrickSelector());
        this.generateLeg(world, random, 1, 7, this.getBrickSelector());
        this.generateLeg(world, random, 7, 1, this.getBrickSelector());
        this.generateLeg(world, random, 7, 7, this.getBrickSelector());
    }
}

