/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RailBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SmallTunnelTurn
extends MineshaftPiece {
    private TurnDirection turnDirection;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 4;

    public SmallTunnelTurn(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_TURN, compoundTag);
        this.turnDirection = TurnDirection.valueOf(compoundTag.func_74762_e("TurnDirection"));
    }

    public SmallTunnelTurn(int i, int chunkPieceLen, Random random, MutableBoundingBox blockBox, Direction direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL_TURN, i, chunkPieceLen, type);
        this.func_186164_a(direction);
        this.turnDirection = random.nextBoolean() ? TurnDirection.LEFT : TurnDirection.RIGHT;
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
        tag.func_74768_a("TurnDirection", this.turnDirection.value);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 5, 5, 5, direction);
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        Direction nextDirection = this.turnDirection == TurnDirection.LEFT ? direction.func_176735_f() : direction.func_176746_e();
        switch (nextDirection) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, nextDirection, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, nextDirection, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, nextDirection, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, nextDirection, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        Direction direction = this.func_186165_e();
        float chance = this.mineshaftType == BetterMineshaftStructure.Type.ICE || this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM ? 0.95f : 0.6f;
        this.chanceReplaceNonAir((IWorld)world, box, random, chance, 0, 0, 0, 4, 4, 4, this.getMainSelector());
        this.fill((IWorld)world, box, 1, 1, 0, 3, 3, 3, field_202556_l);
        this.replaceAir((IWorld)world, box, 1, 0, 0, 3, 0, 4, this.getMainBlock());
        if (this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
            this.chanceReplaceNonAir((IWorld)world, box, random, 0.8f, 1, 0, 0, 3, 0, 4, Blocks.field_150391_bh.func_176223_P());
        }
        this.fill((IWorld)world, box, 2, 1, 0, 2, 1, 1, Blocks.field_150448_aq.func_176223_P());
        if (this.turnDirection == TurnDirection.LEFT) {
            if (direction == Direction.NORTH || direction == Direction.EAST) {
                this.generateLeftTurn((IWorld)world, box);
            } else {
                this.generateRightTurn((IWorld)world, box);
            }
        } else if (direction == Direction.NORTH || direction == Direction.EAST) {
            this.generateRightTurn((IWorld)world, box);
        } else {
            this.generateLeftTurn((IWorld)world, box);
        }
        this.addBiomeDecorations((IWorld)world, box, random, 0, 0, 0, 4, 3, 4);
        this.addVines((IWorld)world, box, random, this.getVineChance(), 1, 0, 1, 3, 4, 3);
        return true;
    }

    private void generateLeftTurn(IWorld world, MutableBoundingBox box) {
        this.fill(world, box, 0, 1, 1, 0, 3, 3, field_202556_l);
        this.fill(world, box, 0, 0, 0, 0, 0, 3, this.getMainBlock());
        this.fill(world, box, 2, 1, 2, 2, 1, 2, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.SOUTH_WEST));
        this.fill(world, box, 0, 1, 2, 1, 1, 2, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST));
    }

    private void generateRightTurn(IWorld world, MutableBoundingBox box) {
        this.fill(world, box, 4, 1, 1, 4, 3, 3, field_202556_l);
        this.fill(world, box, 4, 0, 0, 4, 0, 3, this.getMainBlock());
        this.fill(world, box, 2, 1, 2, 2, 1, 2, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.SOUTH_EAST));
        this.fill(world, box, 3, 1, 2, 4, 1, 2, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST));
    }

    public static enum TurnDirection {
        LEFT(0),
        RIGHT(1);

        private final int value;

        private TurnDirection(int value) {
            this.value = value;
        }

        public static TurnDirection valueOf(int value) {
            return Arrays.stream(TurnDirection.values()).filter(dir -> dir.value == value).findFirst().get();
        }
    }
}

