/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.util.SurfaceUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class VerticalEntrance
extends MineshaftPiece {
    private BlockPos centerPos;
    private int yAxisLen = 0;
    private int localYEnd = 0;
    private int tunnelLength = 0;
    private int tunnelFloorAltitude = 0;
    private Direction tunnelDirection = Direction.NORTH;
    private boolean hasTunnel = false;
    private static final int SHAFT_LOCAL_XZ_START = 22;
    private static final int SHAFT_LOCAL_XZ_END = 26;

    public VerticalEntrance(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.VERTICAL_ENTRANCE, compoundTag);
        int centerPosX = compoundTag.func_74759_k("centerPos")[0];
        int centerPosY = compoundTag.func_74759_k("centerPos")[1];
        int centerPosZ = compoundTag.func_74759_k("centerPos")[2];
        this.centerPos = new BlockPos(centerPosX, centerPosY, centerPosZ);
        this.yAxisLen = compoundTag.func_74762_e("yAxisLen");
        this.localYEnd = this.yAxisLen - 1;
        this.tunnelLength = compoundTag.func_74762_e("tunnelLen");
        this.tunnelFloorAltitude = compoundTag.func_74762_e("floorAltitude");
        int tunnelDirInt = compoundTag.func_74762_e("tunnelDir");
        this.tunnelDirection = tunnelDirInt == -1 ? null : Direction.func_176731_b((int)tunnelDirInt);
        this.hasTunnel = compoundTag.func_74767_n("hasTunnel");
    }

    public VerticalEntrance(int i, int pieceChainLen, Random random, BlockPos.Mutable centerPos, Direction direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.VERTICAL_ENTRANCE, i, pieceChainLen, type);
        this.func_186164_a(direction);
        this.centerPos = new BlockPos((Vector3i)centerPos);
        this.field_74887_e = VerticalEntrance.getInitialMutableBoundingBox((BlockPos)centerPos);
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
        tag.func_74783_a("centerPos", new int[]{this.centerPos.func_177958_n(), this.centerPos.func_177956_o(), this.centerPos.func_177952_p()});
        tag.func_74768_a("yAxisLen", this.yAxisLen);
        tag.func_74768_a("tunnelLen", this.tunnelLength);
        tag.func_74768_a("floorAltitude", this.tunnelFloorAltitude);
        tag.func_74768_a("tunnelDir", this.tunnelDirection.func_176736_b());
        tag.func_74757_a("hasTunnel", this.hasTunnel);
    }

    private static MutableBoundingBox getInitialMutableBoundingBox(BlockPos centerPos) {
        return new MutableBoundingBox(centerPos.func_177958_n() - 24, centerPos.func_177956_o(), centerPos.func_177952_p() - 24, centerPos.func_177958_n() + 24, 256, centerPos.func_177952_p() + 24);
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() - 4, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() - 3, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() + 4, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() + 3, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() - 3, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() + 4, direction, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.centerPos.func_177958_n() + 3, this.centerPos.func_177956_o(), this.centerPos.func_177952_p() - 4, direction, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (!this.hasTunnel) {
            this.determineDirection((IWorld)world);
        }
        if (this.hasTunnel) {
            this.generateVerticalShaft((IWorld)world, random, box);
            this.generateSurfaceTunnel((IWorld)world, random, box);
            return true;
        }
        return false;
    }

    private void generateVerticalShaft(IWorld world, Random random, MutableBoundingBox box) {
        this.fill(world, box, random, 22, 0, 22, 26, this.localYEnd, 26, this.getMainSelector());
        this.fill(world, box, 23, 1, 23, 25, this.localYEnd - 1, 25, field_202556_l);
        this.replaceAir(world, box, 23, 0, 23, 25, 0, 25, this.getMainBlock());
        if (this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
            this.chanceReplaceNonAir(world, box, random, 0.8f, 23, 0, 23, 25, 0, 25, Blocks.field_150391_bh.func_176223_P());
        }
        this.replaceAir(world, box, 24, 1, 22, 24, this.localYEnd - 4, 22, this.getMainBlock());
        this.fill(world, box, 24, 1, 23, 24, this.localYEnd - 4, 23, Blocks.field_150468_ap.func_176223_P());
        this.fill(world, box, 23, 1, 26, 25, 2, 26, this.getMainDoorwayWall());
        this.fill(world, box, 24, 3, 26, 24, 3, 26, this.getMainDoorwaySlab());
        this.fill(world, box, 24, 1, 26, 24, 2, 26, field_202556_l);
        this.addBiomeDecorations(world, box, random, 23, 0, 23, 25, 1, 25);
        this.addVines(world, box, random, this.getVineChance(), 23, 0, 23, 25, this.localYEnd - 4, 25);
    }

    private void generateSurfaceTunnel(IWorld world, Random random, MutableBoundingBox box) {
        RailShape railShape;
        int x;
        int r;
        int z;
        BlockState supportBlock;
        BlockState floorBlock;
        boolean[] validPositions;
        int tunnelStartX = 0;
        int tunnelStartZ = 0;
        int tunnelEndX = 0;
        int tunnelEndZ = 0;
        Direction facing = this.func_186165_e();
        float rotationDifference = facing.func_185119_l() - this.tunnelDirection.func_185119_l();
        Direction relativeTunnelDir = Direction.func_176733_a((double)(Direction.NORTH.func_185119_l() - rotationDifference));
        if (relativeTunnelDir == Direction.NORTH) {
            tunnelStartX = 22;
            tunnelStartZ = 26;
            tunnelEndX = 26;
            tunnelEndZ = 26 + this.tunnelLength;
        } else if (relativeTunnelDir == Direction.WEST && facing != Direction.SOUTH && facing != Direction.WEST || relativeTunnelDir == Direction.EAST && (facing == Direction.SOUTH || facing == Direction.WEST)) {
            tunnelStartX = 22 - this.tunnelLength;
            tunnelStartZ = 22;
            tunnelEndX = 22;
            tunnelEndZ = 26;
        } else if (relativeTunnelDir == Direction.SOUTH) {
            tunnelStartX = 22;
            tunnelStartZ = 22 - this.tunnelLength;
            tunnelEndX = 26;
            tunnelEndZ = 22;
        } else if (relativeTunnelDir == Direction.EAST || relativeTunnelDir == Direction.WEST) {
            tunnelStartX = 26;
            tunnelStartZ = 22;
            tunnelEndX = 26 + this.tunnelLength;
            tunnelEndZ = 26;
        }
        this.chanceReplaceNonAir(world, box, random, 0.6f, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX, this.tunnelFloorAltitude + 4, tunnelEndZ, this.getMainSelector());
        if (facing.func_176740_k() == this.tunnelDirection.func_176740_k()) {
            this.replaceAir(world, box, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude, tunnelEndZ, this.getMainBlock());
            if (this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
                this.chanceReplaceNonAir(world, box, random, 0.8f, tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude, tunnelEndZ, Blocks.field_150391_bh.func_176223_P());
            }
            this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, tunnelStartZ, tunnelEndX - 1, this.tunnelFloorAltitude + 3, tunnelEndZ, field_202556_l);
        } else {
            this.replaceAir(world, box, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude, tunnelEndZ - 1, this.getMainBlock());
            if (this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
                this.chanceReplaceNonAir(world, box, random, 0.8f, tunnelStartX, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude, tunnelEndZ - 1, Blocks.field_150391_bh.func_176223_P());
            }
            this.fill(world, box, tunnelStartX, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, tunnelEndX, this.tunnelFloorAltitude + 3, tunnelEndZ - 1, field_202556_l);
        }
        this.addVines(world, box, random, this.getVineChance(), tunnelStartX + 1, this.tunnelFloorAltitude, tunnelStartZ + 1, tunnelEndX - 1, this.tunnelFloorAltitude + 4, tunnelEndZ - 1);
        if (facing.func_176740_k() == this.tunnelDirection.func_176740_k()) {
            validPositions = new boolean[tunnelEndZ - tunnelStartZ + 1];
            for (int z2 = 0; z2 < validPositions.length; ++z2) {
                floorBlock = this.func_175807_a((IBlockReader)world, tunnelStartX + 2, this.tunnelFloorAltitude, tunnelStartZ + z2, box);
                if (!floorBlock.func_185904_a().func_76220_a()) continue;
                validPositions[z2] = true;
            }
        } else {
            validPositions = new boolean[tunnelEndX - tunnelStartX + 1];
            for (int x2 = 0; x2 < validPositions.length; ++x2) {
                floorBlock = this.func_175807_a((IBlockReader)world, tunnelStartX + x2, this.tunnelFloorAltitude, tunnelStartZ + 2, box);
                if (!floorBlock.func_185904_a().func_76220_a()) continue;
                validPositions[x2] = true;
            }
        }
        if (facing.func_176740_k() == this.tunnelDirection.func_176740_k()) {
            supportBlock = this.getSupportBlock();
            if (supportBlock.func_177230_c() instanceof WallBlock) {
                supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((Property)WallBlock.field_235612_b_, (Comparable)WallHeight.TALL)).func_206870_a((Property)WallBlock.field_235615_e_, (Comparable)WallHeight.TALL);
            } else if (supportBlock.func_177230_c() instanceof FourWayBlock) {
                supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
            }
            for (z = tunnelStartZ; z <= tunnelEndZ; ++z) {
                r = random.nextInt(4);
                if (r != 0 || !validPositions[z - tunnelStartZ]) continue;
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 1, z, tunnelStartX + 1, this.tunnelFloorAltitude + 2, z, this.getSupportBlock());
                this.fill(world, box, tunnelStartX + 3, this.tunnelFloorAltitude + 1, z, tunnelStartX + 3, this.tunnelFloorAltitude + 2, z, this.getSupportBlock());
                this.fill(world, box, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, this.getMainBlock());
                this.chanceReplaceNonAir(world, box, random, 0.25f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z, supportBlock);
                this.chanceReplaceAir(world, box, random, 0.15f, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 1, this.tunnelFloorAltitude + 3, z + 1, Blocks.field_196553_aF.func_176223_P());
                this.chanceReplaceAir(world, box, random, 0.15f, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z - 1, tunnelStartX + 3, this.tunnelFloorAltitude + 3, z + 1, Blocks.field_196553_aF.func_176223_P());
                z += 3;
            }
        } else {
            supportBlock = this.getSupportBlock();
            if (supportBlock.func_177230_c() instanceof WallBlock) {
                supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((Property)WallBlock.field_235613_c_, (Comparable)WallHeight.TALL)).func_206870_a((Property)WallBlock.field_235614_d_, (Comparable)WallHeight.TALL);
            } else if (supportBlock.func_177230_c() instanceof FourWayBlock) {
                supportBlock = (BlockState)((BlockState)supportBlock.func_206870_a((Property)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(true));
            }
            for (x = tunnelStartX; x <= tunnelEndX; ++x) {
                r = random.nextInt(4);
                if (r != 0 || !validPositions[x - tunnelStartX]) continue;
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 1, this.getSupportBlock());
                this.fill(world, box, x, this.tunnelFloorAltitude + 1, tunnelStartZ + 3, x, this.tunnelFloorAltitude + 2, tunnelStartZ + 3, this.getSupportBlock());
                this.fill(world, box, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, this.getMainBlock());
                this.chanceReplaceNonAir(world, box, random, 0.25f, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, supportBlock);
                this.chanceReplaceAir(world, box, random, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 1, Blocks.field_196553_aF.func_176223_P());
                this.chanceReplaceAir(world, box, random, 0.15f, x - 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, x + 1, this.tunnelFloorAltitude + 3, tunnelStartZ + 3, Blocks.field_196553_aF.func_176223_P());
                x += 3;
            }
        }
        RailShape railShape2 = railShape = relativeTunnelDir.func_176740_k() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST;
        if (facing.func_176740_k() == this.tunnelDirection.func_176740_k()) {
            for (z = 0; z < tunnelEndZ - tunnelStartZ + 1; ++z) {
                if (!validPositions[z] || !((double)random.nextFloat() < 0.5)) continue;
                this.func_175811_a(world, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)railShape), tunnelStartX + 2, this.tunnelFloorAltitude + 1, tunnelStartZ + z, box);
            }
        } else {
            for (x = 0; x < tunnelEndX - tunnelStartX + 1; ++x) {
                if (!validPositions[x] || !((double)random.nextFloat() < 0.5)) continue;
                this.func_175811_a(world, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)railShape), tunnelStartX + x, this.tunnelFloorAltitude + 1, tunnelStartZ + 2, box);
            }
        }
    }

    private void determineDirection(IWorld world) {
        int minSurfaceHeight = 255;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                try {
                    int realX = this.centerPos.func_177958_n() + xOffset;
                    int realZ = this.centerPos.func_177952_p() + zOffset;
                    int chunkX = realX >> 4;
                    int chunkZ = realZ >> 4;
                    int surfaceHeight = SurfaceUtil.getSurfaceHeight(world.func_212866_a_(chunkX, chunkZ), new ColumnPos(realX, realZ));
                    if (surfaceHeight <= 1) continue;
                    minSurfaceHeight = Math.min(minSurfaceHeight, surfaceHeight);
                    continue;
                }
                catch (NullPointerException e) {
                    BetterMineshafts.LOGGER.error("Unexpected YUNG's Better Mineshafts error. Please report this!");
                    BetterMineshafts.LOGGER.error(e.toString());
                    BetterMineshafts.LOGGER.error(e.getMessage());
                }
            }
        }
        if (minSurfaceHeight < 60 || minSurfaceHeight == 255) {
            return;
        }
        int ceilingHeight = minSurfaceHeight - 2;
        int floorHeight = ceilingHeight - 4;
        this.yAxisLen = ceilingHeight - this.centerPos.func_177956_o() + 1;
        this.localYEnd = this.yAxisLen - 1;
        BlockPos.Mutable mutable = this.centerPos.func_239590_i_();
        int radius = 8;
        int maxRadialDist = 3;
        for (int radialDist = 0; radialDist < maxRadialDist; ++radialDist) {
            for (Direction direction : Direction.values()) {
                if (direction == Direction.UP || direction == Direction.DOWN) continue;
                mutable.func_189533_g((Vector3i)this.centerPos.func_177967_a(direction, radius * radialDist + 2));
                for (int i = radialDist * radius; i < radialDist * radius + radius; ++i) {
                    int surfaceHeight = SurfaceUtil.getSurfaceHeight(world.func_217349_x((BlockPos)mutable), new ColumnPos(mutable.func_177958_n(), mutable.func_177952_p()));
                    if (surfaceHeight <= floorHeight && surfaceHeight > 1) {
                        this.hasTunnel = true;
                        this.tunnelDirection = direction;
                        this.tunnelFloorAltitude = ceilingHeight - 4 - this.field_74887_e.field_78895_b;
                        this.tunnelLength = i;
                        return;
                    }
                    mutable.func_189536_c(direction);
                }
            }
        }
    }
}

