/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.enums;

import biomesoplenty.init.ModBiomes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;

public enum BOPClimates {
    ICE_CAP,
    TUNDRA,
    WET_BOREAL,
    DRY_BOREAL,
    WET_TEMPERATE,
    DRY_TEMPERATE,
    COOL_TEMPERATE,
    WARM_TEMPERATE,
    SUBTROPICAL,
    TROPICAL,
    MEDITERRANEAN,
    SAVANNA,
    HOT_DESERT,
    WASTELAND,
    NETHER;

    private int totalBiomesWeight;
    private int totalIslandBiomesWeight;
    private ArrayList<WeightedBiomeEntry> landBiomes = Lists.newArrayList();
    private ArrayList<WeightedBiomeEntry> islandBiomes = Lists.newArrayList();
    private static BOPClimates[] values;
    private static final BOPClimates[] climateMapping;

    public BOPClimates addBiome(int weight, RegistryKey<Biome> biome) {
        return this.addBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addBiome(WeightedBiomeEntry biomeEntry) {
        this.totalBiomesWeight += biomeEntry.weight;
        this.landBiomes.add(biomeEntry);
        return this;
    }

    public BOPClimates addIslandBiome(int weight, RegistryKey<Biome> biome) {
        return this.addIslandBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addIslandBiome(WeightedBiomeEntry biomeEntry) {
        this.totalIslandBiomesWeight += biomeEntry.weight;
        this.islandBiomes.add(biomeEntry);
        return this;
    }

    public RegistryKey<Biome> getRandomBiome(INoiseRandom context, RegistryKey<Biome> fallback) {
        WeightedBiomeEntry item;
        if (this.totalBiomesWeight == 0) {
            return fallback;
        }
        int weight = context.func_202696_a(this.totalBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.landBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public RegistryKey<Biome> getRandomIslandBiome(INoiseRandom context, RegistryKey<Biome> fallback) {
        WeightedBiomeEntry item;
        if (this.totalIslandBiomesWeight == 0) {
            return fallback;
        }
        int weight = context.func_202696_a(this.totalIslandBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.islandBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public RegistryKey<Biome> getRandomOceanBiome(INoiseRandom context, boolean deep) {
        return deep ? Biomes.field_150575_M : Biomes.field_76771_b;
    }

    public ImmutableList<WeightedBiomeEntry> getLandBiomes() {
        return this.landBiomes.isEmpty() ? ImmutableList.of((Object)this.getDefaultWeightedBiomeEntry()) : ImmutableList.copyOf(this.landBiomes);
    }

    public ImmutableList<WeightedBiomeEntry> getIslandBiomes() {
        return this.islandBiomes.isEmpty() ? ImmutableList.of((Object)this.getDefaultWeightedBiomeEntry()) : ImmutableList.copyOf(this.islandBiomes);
    }

    private WeightedBiomeEntry getDefaultWeightedBiomeEntry() {
        return new WeightedBiomeEntry(100, (RegistryKey<Biome>)Biomes.field_76771_b);
    }

    public static BOPClimates lookup(int i) {
        return values[i];
    }

    public static int[] getClimateMappingInts() {
        int[] out = new int[108];
        for (int i = 0; i < 108; ++i) {
            out[i] = climateMapping[i].ordinal();
        }
        return out;
    }

    public static ImmutableSet<RegistryKey<Biome>> getOverworldBiomes() {
        HashSet set = Sets.newHashSet();
        for (BOPClimates climate : BOPClimates.values()) {
            if (climate == NETHER) continue;
            set.addAll(climate.getLandBiomes().stream().map(weightedBiomeEntry -> weightedBiomeEntry.biome).collect(Collectors.toSet()));
            set.addAll(climate.getIslandBiomes().stream().map(weightedBiomeEntry -> weightedBiomeEntry.biome).collect(Collectors.toSet()));
        }
        ModBiomes.subBiomes.values().forEach(weightedSubBiome -> set.add(weightedSubBiome.biome));
        return ImmutableSet.copyOf((Collection)set);
    }

    public static void printWeights() {
        for (BOPClimates climate : BOPClimates.values()) {
            for (WeightedBiomeEntry entry : climate.landBiomes) {
                System.out.println(climate.name() + " " + entry.biome.getRegistryName() + " " + entry.weight);
            }
        }
    }

    static {
        values = BOPClimates.values();
        climateMapping = new BOPClimates[]{WET_BOREAL, TUNDRA, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, TUNDRA, DRY_BOREAL, WET_BOREAL, WET_BOREAL, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, DRY_BOREAL, DRY_BOREAL, WET_TEMPERATE, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, SUBTROPICAL, SUBTROPICAL, SUBTROPICAL, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, SAVANNA, SAVANNA, SAVANNA, TROPICAL, TROPICAL, SUBTROPICAL, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, SUBTROPICAL, SUBTROPICAL, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, SAVANNA, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, TROPICAL, SUBTROPICAL, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, WASTELAND};
    }

    public static class WeightedBiomeEntry {
        public final int weight;
        public final RegistryKey<Biome> biome;

        public WeightedBiomeEntry(int weight, RegistryKey<Biome> biome) {
            this.weight = weight;
            this.biome = biome;
        }
    }
}

