/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.common.biome.BiomeTemplate;
import biomesoplenty.common.world.gen.feature.BOPConfiguredFeatures;
import biomesoplenty.core.ClientProxy;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;

public class RainbowValleyBiome
extends BiomeTemplate {
    public RainbowValleyBiome() {
        this.setBeachBiome(null);
        this.setGrassColorFunction(this::getGrassColor);
    }

    @Override
    protected void configureBiome(Biome.Builder builder) {
        builder.func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.FOREST).func_205421_a(0.5f).func_205420_b(0.5f).func_205414_c(0.55f).func_205417_d(1.0f);
        builder.func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4566514).func_235248_c_(267827).func_235239_a_(12638463).func_242539_d(RainbowValleyBiome.calculateSkyColor(0.55f)).func_242541_f(7720589).func_242540_e(this.getFoliageColor()).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_());
    }

    @Override
    protected void configureGeneration(BiomeGenerationSettings.Builder builder) {
        builder.func_242517_a(new ConfiguredSurfaceBuilder(SurfaceBuilder.field_215396_G, (ISurfaceBuilderConfig)SurfaceBuilder.field_215425_v));
        DefaultBiomeFeatures.func_243733_b((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243754_n((BiomeGenerationSettings.Builder)builder);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.RAINBOW_VALLEY_TREES);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.RAINBOW_VALLEY_FLOWERS);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.BLUE_HYDRANGEA_4);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.GOLDENROD_2);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.LILAC_2);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.PEONY_1);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.ROSE_BUSH_4);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.SPROUTS_5);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BOPConfiguredFeatures.STANDARD_GRASS_12);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243823_aV);
        builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243824_aW);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)builder);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)builder);
    }

    @Override
    protected void configureMobSpawns(MobSpawnInfo.Builder builder) {
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_220356_B, 8, 2, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200737_ac, 12, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200784_X, 10, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200795_i, 10, 4, 4));
        builder.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_200796_j, 8, 4, 4));
        builder.func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
    }

    public int getGrassColor(double x, double z) {
        if (ClientProxy.isAprilFools) {
            return 0xFFFFFF;
        }
        double d0 = Biome.field_180281_af.func_215464_a(x * 0.0225, z * 0.0225, false);
        return d0 < -0.1 ? 7851647 : 7720589;
    }

    public int getFoliageColor() {
        if (ClientProxy.isAprilFools) {
            return 0xFFFFFF;
        }
        return 7720589;
    }
}

