/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.biome;

import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.init.ModBiomes;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeUtil {
    public static RegistryKey<Biome> createKey(Biome biome) {
        return biome == null ? null : RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.delegate.name());
    }

    public static RegistryKey<Biome> createKey(int id) {
        return BiomeUtil.createKey(BiomeUtil.getBiome(id));
    }

    public static Biome getBiome(RegistryKey<Biome> key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_());
        if (biome == null) {
            throw new RuntimeException("Attempted to get unregistered biome " + key);
        }
        return biome;
    }

    public static Biome getBiome(int id) {
        if (id == -1) {
            throw new RuntimeException("Attempted to get biome with id -1");
        }
        return BiomeUtil.getBiome((RegistryKey<Biome>)((ForgeRegistry)ForgeRegistries.BIOMES).getKey(id));
    }

    public static int getBiomeId(Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Attempted to get id of null biome");
        }
        int id = ((ForgeRegistry)ForgeRegistries.BIOMES).getID((IForgeRegistryEntry)biome);
        if (id == -1) {
            throw new RuntimeException("Biome id is -1 for biome " + biome.delegate.name());
        }
        return id;
    }

    public static int getBiomeId(RegistryKey<Biome> key) {
        return BiomeUtil.getBiomeId(BiomeUtil.getBiome(key));
    }

    public static boolean hasMetadata(RegistryKey<Biome> key) {
        return ModBiomes.biomeMetadata.containsKey(key);
    }

    public static boolean hasMetadata(Biome biome) {
        return BiomeUtil.hasMetadata(BiomeUtil.createKey(biome));
    }

    public static BiomeMetadata getMetadata(RegistryKey<Biome> key) {
        return ModBiomes.biomeMetadata.get(key);
    }

    public static BiomeMetadata getMetadata(Biome biome) {
        return BiomeUtil.getMetadata(BiomeUtil.createKey(biome));
    }

    public static boolean exists(RegistryKey<Biome> key) {
        return ForgeRegistries.BIOMES.containsKey(key.func_240901_a_());
    }

    public static boolean exists(int id) {
        return BiomeUtil.getBiome(id) != null;
    }

    public static RegistryKey<Biome> getClientKey(Biome biome) {
        return (RegistryKey)Minecraft.func_71410_x().field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biome).get();
    }
}

