/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.common.world.BOPBiomeProvider;
import biomesoplenty.common.world.BOPDimensionType;
import biomesoplenty.common.world.BOPNetherBiomeProvider;
import biomesoplenty.core.BiomesOPlenty;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.NetherBiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.ServerWorldInfo;

public class BOPWorldTypeUtil {
    private static boolean isServerLevelTypeBop(DedicatedServer server) {
        String levelType = Optional.ofNullable((String)server.func_213221_d_().field_73672_b.get("level-type")).map(str -> str.toLowerCase(Locale.ROOT)).orElse("default");
        return levelType.equals("biomesoplenty") || levelType.equals("biomesop");
    }

    public static boolean isUsingBopWorldType(DimensionGeneratorSettings settings) {
        ArrayList dimensions = Lists.newArrayList((Iterable)settings.func_236224_e_().func_239659_c_());
        Map.Entry dimensionEntry0 = (Map.Entry)dimensions.get(0);
        Map.Entry dimensionEntry1 = (Map.Entry)dimensions.get(1);
        Map.Entry dimensionEntry2 = (Map.Entry)dimensions.get(2);
        if (dimensionEntry0.getKey() != Dimension.field_236053_b_ || dimensionEntry1.getKey() != Dimension.field_236054_c_ && dimensionEntry2.getKey() != Dimension.field_236055_d_) {
            return false;
        }
        Dimension overworld = (Dimension)dimensionEntry0.getValue();
        Dimension nether = (Dimension)dimensionEntry1.getValue();
        Dimension end = (Dimension)dimensionEntry2.getValue();
        if (!(overworld.func_236064_c_() instanceof NoiseChunkGenerator && nether.func_236064_c_() instanceof NoiseChunkGenerator && end.func_236064_c_() instanceof NoiseChunkGenerator)) {
            return false;
        }
        return overworld.func_236064_c_().func_202090_b() instanceof BOPBiomeProvider && (nether.func_236064_c_().func_202090_b() instanceof BOPNetherBiomeProvider || nether.func_236064_c_().func_202090_b() instanceof NetherBiomeProvider);
    }

    public static ChunkGenerator makeOverworld(Registry<Biome> biomes, Registry<DimensionSettings> noiseGeneratorSettings, long seed) {
        return new NoiseChunkGenerator((BiomeProvider)new BOPBiomeProvider(seed, biomes), seed, () -> (DimensionSettings)noiseGeneratorSettings.func_243576_d(DimensionSettings.field_242734_c));
    }

    public static DimensionGeneratorSettings createDimensionGeneratorSettings(DynamicRegistries registries, long seed, boolean generateFeatures, boolean generateBonusChest) {
        MutableRegistry biomeRegistry = registries.func_243612_b(Registry.field_239720_u_);
        MutableRegistry dimensionSettingsRegistry = registries.func_243612_b(Registry.field_243549_ar);
        MutableRegistry dimensionTypeRegistry = registries.func_243612_b(Registry.field_239698_ad_);
        return new DimensionGeneratorSettings(seed, generateFeatures, generateBonusChest, DimensionGeneratorSettings.func_242749_a((Registry)dimensionTypeRegistry, BOPDimensionType.bopDimensions((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimensionSettingsRegistry, seed), (ChunkGenerator)BOPWorldTypeUtil.makeOverworld((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimensionSettingsRegistry, seed)));
    }

    public static void setupForDedicatedServer(DedicatedServer server) {
        if (!BOPWorldTypeUtil.isServerLevelTypeBop(server)) {
            return;
        }
        ServerProperties properties = server.func_213221_d_();
        BiomesOPlenty.logger.info("Setting world generator settings to biomesoplenty");
        if (server.func_240793_aU_() instanceof ServerWorldInfo) {
            ServerWorldInfo worldInfo = (ServerWorldInfo)server.func_240793_aU_();
            worldInfo.field_237343_c_ = BOPWorldTypeUtil.createDimensionGeneratorSettings((DynamicRegistries)DynamicRegistries.func_239770_b_(), worldInfo.field_237343_c_.func_236221_b_(), worldInfo.field_237343_c_.func_236222_c_(), worldInfo.field_237343_c_.func_236223_d_());
        }
        properties.field_241082_U_ = BOPWorldTypeUtil.createDimensionGeneratorSettings((DynamicRegistries)DynamicRegistries.func_239770_b_(), properties.field_241082_U_.func_236221_b_(), properties.field_241082_U_.func_236222_c_(), properties.field_241082_U_.func_236223_d_());
    }
}

