/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ColumnConfig;
import net.minecraft.world.gen.feature.Feature;

public class BlackSandstoneColumnFeature
extends Feature<ColumnConfig> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.field_196623_P, (Object)Blocks.field_196574_ab, (Object)Blocks.field_150355_j, (Object)Blocks.field_150353_l, (Object)Blocks.field_150357_h, (Object)Blocks.field_196814_hQ, (Object)Blocks.field_150425_aM, (Object)Blocks.field_196653_dH, (Object)Blocks.field_150386_bk, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150388_bm, (Object)Blocks.field_150486_ae, (Object[])new Block[]{Blocks.field_150474_ac});

    public BlackSandstoneColumnFeature(Codec<ColumnConfig> p_i231925_1_) {
        super(p_i231925_1_);
    }

    public boolean place(ISeedReader p_230362_1_, ChunkGenerator p_230362_3_, Random rand, BlockPos p_230362_5_, ColumnConfig config) {
        int i = p_230362_3_.func_230356_f_();
        BlockPos blockpos = BlackSandstoneColumnFeature.findSurface((IWorld)p_230362_1_, i, p_230362_5_.func_239590_i_().func_239620_a_(Direction.Axis.Y, 1, p_230362_1_.func_217301_I() - 1), Integer.MAX_VALUE);
        if (blockpos == null) {
            return false;
        }
        int j = config.func_242795_b().func_242259_a(rand);
        boolean flag = rand.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.func_239585_a_((Random)rand, (int)l, (int)(blockpos.func_177958_n() - k), (int)blockpos.func_177956_o(), (int)(blockpos.func_177952_p() - k), (int)(blockpos.func_177958_n() + k), (int)blockpos.func_177956_o(), (int)(blockpos.func_177952_p() + k))) {
            int i1 = j - blockpos1.func_218139_n((Vector3i)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((IWorld)p_230362_1_, i, blockpos1, i1, config.func_242794_am_().func_242259_a(rand));
        }
        return flag1;
    }

    private boolean placeColumn(IWorld p_236248_1_, int p_236248_2_, BlockPos p_236248_3_, int p_236248_4_, int p_236248_5_) {
        boolean flag = false;
        block0: for (BlockPos blockpos : BlockPos.func_191531_b((int)(p_236248_3_.func_177958_n() - p_236248_5_), (int)p_236248_3_.func_177956_o(), (int)(p_236248_3_.func_177952_p() - p_236248_5_), (int)(p_236248_3_.func_177958_n() + p_236248_5_), (int)p_236248_3_.func_177956_o(), (int)(p_236248_3_.func_177952_p() + p_236248_5_))) {
            int i = blockpos.func_218139_n((Vector3i)p_236248_3_);
            BlockPos blockpos1 = BlackSandstoneColumnFeature.isAirOrLavaOcean(p_236248_1_, p_236248_2_, blockpos) ? BlackSandstoneColumnFeature.findSurface(p_236248_1_, p_236248_2_, blockpos.func_239590_i_(), i) : BlackSandstoneColumnFeature.findAir(p_236248_1_, blockpos.func_239590_i_(), i);
            if (blockpos1 == null) continue;
            BlockPos.Mutable blockpos$mutable = blockpos1.func_239590_i_();
            for (int j = p_236248_4_ - i / 2; j >= 0; --j) {
                if (BlackSandstoneColumnFeature.isAirOrLavaOcean(p_236248_1_, p_236248_2_, (BlockPos)blockpos$mutable)) {
                    this.func_230367_a_((IWorldWriter)p_236248_1_, (BlockPos)blockpos$mutable, BOPBlocks.black_sandstone.func_176223_P());
                    blockpos$mutable.func_189536_c(Direction.UP);
                    flag = true;
                    continue;
                }
                if (!p_236248_1_.func_180495_p((BlockPos)blockpos$mutable).func_203425_a(BOPBlocks.black_sandstone)) continue block0;
                blockpos$mutable.func_189536_c(Direction.UP);
            }
        }
        return flag;
    }

    @Nullable
    private static BlockPos findSurface(IWorld p_236246_0_, int p_236246_1_, BlockPos.Mutable p_236246_2_, int p_236246_3_) {
        while (p_236246_2_.func_177956_o() > 1 && p_236246_3_ > 0) {
            --p_236246_3_;
            if (BlackSandstoneColumnFeature.isAirOrLavaOcean(p_236246_0_, p_236246_1_, (BlockPos)p_236246_2_)) {
                BlockState blockstate = p_236246_0_.func_180495_p((BlockPos)p_236246_2_.func_189536_c(Direction.DOWN));
                p_236246_2_.func_189536_c(Direction.UP);
                if (!(blockstate.func_196958_f() || blockstate.func_177230_c() instanceof BushBlock || CANNOT_PLACE_ON.contains((Object)blockstate.func_177230_c()))) {
                    return p_236246_2_;
                }
            }
            p_236246_2_.func_189536_c(Direction.DOWN);
        }
        return null;
    }

    @Nullable
    private static BlockPos findAir(IWorld p_236249_0_, BlockPos.Mutable p_236249_1_, int p_236249_2_) {
        while (p_236249_1_.func_177956_o() < p_236249_0_.func_217301_I() && p_236249_2_ > 0) {
            --p_236249_2_;
            BlockState blockstate = p_236249_0_.func_180495_p((BlockPos)p_236249_1_);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.func_177230_c())) {
                return null;
            }
            if (blockstate.func_196958_f() || blockstate.func_177230_c() instanceof BushBlock) {
                return p_236249_1_;
            }
            p_236249_1_.func_189536_c(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(IWorld p_236247_0_, int p_236247_1_, BlockPos p_236247_2_) {
        BlockState blockstate = p_236247_0_.func_180495_p(p_236247_2_);
        return blockstate.func_196958_f() || blockstate.func_203425_a(Blocks.field_150353_l) && p_236247_2_.func_177956_o() <= p_236247_1_;
    }
}

