/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.common.world.BOPWorldTypeUtil;
import biomesoplenty.core.ClientProxy;
import biomesoplenty.core.CommonProxy;
import biomesoplenty.init.ModBiomes;
import biomesoplenty.init.ModConfig;
import biomesoplenty.init.ModEntities;
import biomesoplenty.init.ModVanillaCompat;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="biomesoplenty")
public class BiomesOPlenty {
    public static final String MOD_ID = "biomesoplenty";
    public static BiomesOPlenty instance;
    public static CommonProxy proxy;
    public static Logger logger;

    public BiomesOPlenty() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        ModBiomes.setup();
        ModConfig.setup();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModVanillaCompat.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModEntities.registerRendering();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.init();
    }

    private void serverStarting(FMLServerAboutToStartEvent event) {
        if (!(event.getServer() instanceof DedicatedServer)) {
            return;
        }
        BOPWorldTypeUtil.setupForDedicatedServer((DedicatedServer)event.getServer());
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

