/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.biome.BiomeMetadata;
import biomesoplenty.common.biome.BiomeRegistry;
import biomesoplenty.common.biome.BiomeTemplate;
import biomesoplenty.common.biome.nether.CrystallineChasmBiome;
import biomesoplenty.common.biome.nether.UndergrowthBiome;
import biomesoplenty.common.biome.nether.VisceralHeapBiome;
import biomesoplenty.common.biome.nether.WitheredAbyssBiome;
import biomesoplenty.common.biome.overworld.AlpsBiome;
import biomesoplenty.common.biome.overworld.AlpsFoothillsBiome;
import biomesoplenty.common.biome.overworld.BayouBiome;
import biomesoplenty.common.biome.overworld.BogBiome;
import biomesoplenty.common.biome.overworld.BorealForestBiome;
import biomesoplenty.common.biome.overworld.BrushlandBiome;
import biomesoplenty.common.biome.overworld.ChaparralBiome;
import biomesoplenty.common.biome.overworld.CherryBlossomGroveBiome;
import biomesoplenty.common.biome.overworld.ColdDesertBiome;
import biomesoplenty.common.biome.overworld.ConiferousForestBiome;
import biomesoplenty.common.biome.overworld.DeadForestBiome;
import biomesoplenty.common.biome.overworld.FirClearingBiome;
import biomesoplenty.common.biome.overworld.FloodplainBiome;
import biomesoplenty.common.biome.overworld.FlowerMeadowBiome;
import biomesoplenty.common.biome.overworld.FungalJungleBiome;
import biomesoplenty.common.biome.overworld.GrasslandBiome;
import biomesoplenty.common.biome.overworld.GravelBeachBiome;
import biomesoplenty.common.biome.overworld.GroveBiome;
import biomesoplenty.common.biome.overworld.HighlandBiome;
import biomesoplenty.common.biome.overworld.HighlandMoorBiome;
import biomesoplenty.common.biome.overworld.LavenderFieldBiome;
import biomesoplenty.common.biome.overworld.LushGrasslandBiome;
import biomesoplenty.common.biome.overworld.LushSwampBiome;
import biomesoplenty.common.biome.overworld.MangroveBiome;
import biomesoplenty.common.biome.overworld.MapleWoodsBiome;
import biomesoplenty.common.biome.overworld.MarshBiome;
import biomesoplenty.common.biome.overworld.MeadowBiome;
import biomesoplenty.common.biome.overworld.MireBiome;
import biomesoplenty.common.biome.overworld.MuskegBiome;
import biomesoplenty.common.biome.overworld.MysticGroveBiome;
import biomesoplenty.common.biome.overworld.OasisBiome;
import biomesoplenty.common.biome.overworld.OminousWoodsBiome;
import biomesoplenty.common.biome.overworld.OrchardBiome;
import biomesoplenty.common.biome.overworld.OriginHillsBiome;
import biomesoplenty.common.biome.overworld.OutbackBiome;
import biomesoplenty.common.biome.overworld.OvergrownCliffsBiome;
import biomesoplenty.common.biome.overworld.PastureBiome;
import biomesoplenty.common.biome.overworld.PoppyFieldBiome;
import biomesoplenty.common.biome.overworld.PrairieBiome;
import biomesoplenty.common.biome.overworld.PumpkinPatchBiome;
import biomesoplenty.common.biome.overworld.RainbowValleyBiome;
import biomesoplenty.common.biome.overworld.RainforestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestBiome;
import biomesoplenty.common.biome.overworld.RedwoodForestEdgeBiome;
import biomesoplenty.common.biome.overworld.ScrublandBiome;
import biomesoplenty.common.biome.overworld.SeasonalForestBiome;
import biomesoplenty.common.biome.overworld.ShieldBiome;
import biomesoplenty.common.biome.overworld.ShrublandBiome;
import biomesoplenty.common.biome.overworld.SilkgladeBiome;
import biomesoplenty.common.biome.overworld.SnowyConiferousForestBiome;
import biomesoplenty.common.biome.overworld.SnowyFirClearingBiome;
import biomesoplenty.common.biome.overworld.SnowyForestBiome;
import biomesoplenty.common.biome.overworld.SteppeBiome;
import biomesoplenty.common.biome.overworld.TemperateRainforestBiome;
import biomesoplenty.common.biome.overworld.TemperateRainforestHillsBiome;
import biomesoplenty.common.biome.overworld.TropicBeachBiome;
import biomesoplenty.common.biome.overworld.TropicalRainforestBiome;
import biomesoplenty.common.biome.overworld.TropicsBiome;
import biomesoplenty.common.biome.overworld.TundraBiome;
import biomesoplenty.common.biome.overworld.VolcanicPlainsBiome;
import biomesoplenty.common.biome.overworld.VolcanoBiome;
import biomesoplenty.common.biome.overworld.WastelandBiome;
import biomesoplenty.common.biome.overworld.WetlandBiome;
import biomesoplenty.common.biome.overworld.WoodlandBiome;
import biomesoplenty.common.biome.overworld.XericShrublandBiome;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPBiomeGeneratorTypeScreen;
import biomesoplenty.common.world.BOPBiomeProvider;
import biomesoplenty.common.world.BOPNetherBiomeProvider;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.level.ColorResolver;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomes {
    public static BOPBiomeGeneratorTypeScreen biomeGeneratorTypeScreenBOP;
    public static Multimap<Integer, WeightedSubBiome> subBiomes;
    public static List<Integer> islandBiomeIds;
    public static Map<RegistryKey<Biome>, BiomeMetadata> biomeMetadata;

    public static void setup() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            biomeGeneratorTypeScreenBOP = new BOPBiomeGeneratorTypeScreen();
            BiomeGeneratorTypeScreens.field_239068_c_.add(biomeGeneratorTypeScreenBOP);
            ColorResolver grassColorResolver = BiomeColors.field_180291_a;
            ColorResolver foliageColorResolver = BiomeColors.field_180289_b;
            ColorResolver waterColorResolver = BiomeColors.field_180290_c;
            BiomeColors.field_180291_a = (biome, posX, posZ) -> {
                RegistryKey<Biome> key = BiomeUtil.getClientKey(biome);
                BiomeMetadata meta = BiomeUtil.getMetadata(key);
                if (meta != null && meta.getGrassColorFunction() != null) {
                    return meta.getGrassColorFunction().apply(posX, posZ);
                }
                return grassColorResolver.getColor(biome, posX, posZ);
            };
            BiomeColors.field_180289_b = (biome, posX, posZ) -> {
                RegistryKey<Biome> key = BiomeUtil.getClientKey(biome);
                BiomeMetadata meta = BiomeUtil.getMetadata(key);
                if (meta != null && meta.getFoliageColorFunction() != null) {
                    return meta.getFoliageColorFunction().apply(posX, posZ);
                }
                return foliageColorResolver.getColor(biome, posX, posZ);
            };
            BiomeColors.field_180290_c = (biome, posX, posZ) -> {
                RegistryKey<Biome> key = BiomeUtil.getClientKey(biome);
                BiomeMetadata meta = BiomeUtil.getMetadata(key);
                if (meta != null && meta.getWaterColorFunction() != null) {
                    return meta.getWaterColorFunction().apply(posX, posZ);
                }
                return waterColorResolver.getColor(biome, posX, posZ);
            };
        }
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"biomesoplenty_overworld", BOPBiomeProvider.CODEC);
        Registry.func_218325_a((Registry)Registry.field_239689_aA_, (String)"biomesoplenty_nether", BOPNetherBiomeProvider.CODEC);
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        ModBiomes.registerTechnicalBiome(new GravelBeachBiome(), "gravel_beach");
        ModBiomes.registerTechnicalBiome(new TropicBeachBiome(), "tropic_beach");
        ModBiomes.registerTechnicalBiome(new AlpsFoothillsBiome(), "alps_foothills");
        ModBiomes.registerTechnicalBiome(new RedwoodForestEdgeBiome(), "redwood_forest_edge");
        ModBiomes.registerTechnicalBiome(new VolcanicPlainsBiome(), "volcanic_plains");
        ModBiomes.registerTechnicalBiome(new OrchardBiome(), "orchard");
        BiomeRegistry.configureTechnicalBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.TECHNICAL_BIOME);
        ModBiomes.registerBiome(new MangroveBiome(), "mangrove");
        ModBiomes.registerBiome(new AlpsBiome(), "alps");
        ModBiomes.registerBiome(new BayouBiome(), "bayou");
        ModBiomes.registerBiome(new BogBiome(), "bog");
        ModBiomes.registerBiome(new BorealForestBiome(), "boreal_forest");
        ModBiomes.registerBiome(new BrushlandBiome(), "brushland");
        ModBiomes.registerBiome(new ChaparralBiome(), "chaparral");
        ModBiomes.registerBiome(new CherryBlossomGroveBiome(), "cherry_blossom_grove");
        ModBiomes.registerBiome(new ColdDesertBiome(), "cold_desert");
        ModBiomes.registerBiome(new ConiferousForestBiome(), "coniferous_forest");
        ModBiomes.registerBiome(new DeadForestBiome(), "dead_forest");
        ModBiomes.registerBiome(new FirClearingBiome(), "fir_clearing");
        ModBiomes.registerBiome(new FloodplainBiome(), "floodplain");
        ModBiomes.registerBiome(new FlowerMeadowBiome(), "flower_meadow");
        ModBiomes.registerBiome(new FungalJungleBiome(), "fungal_jungle");
        ModBiomes.registerBiome(new GrasslandBiome(), "grassland");
        ModBiomes.registerBiome(new GroveBiome(), "grove");
        ModBiomes.registerBiome(new HighlandBiome(), "highland");
        ModBiomes.registerBiome(new HighlandMoorBiome(), "highland_moor");
        ModBiomes.registerBiome(new LavenderFieldBiome(), "lavender_field");
        ModBiomes.registerBiome(new LushGrasslandBiome(), "lush_grassland");
        ModBiomes.registerBiome(new LushSwampBiome(), "lush_swamp");
        ModBiomes.registerBiome(new MapleWoodsBiome(), "maple_woods");
        ModBiomes.registerBiome(new MarshBiome(), "marsh");
        ModBiomes.registerBiome(new MeadowBiome(), "meadow");
        ModBiomes.registerBiome(new MireBiome(), "mire");
        ModBiomes.registerBiome(new MuskegBiome(), "muskeg");
        ModBiomes.registerBiome(new MysticGroveBiome(), "mystic_grove");
        ModBiomes.registerBiome(new OasisBiome(), "oasis");
        ModBiomes.registerBiome(new OminousWoodsBiome(), "ominous_woods");
        ModBiomes.registerBiome(new OriginHillsBiome(), "origin_hills");
        ModBiomes.registerBiome(new OutbackBiome(), "outback");
        ModBiomes.registerBiome(new OvergrownCliffsBiome(), "overgrown_cliffs");
        ModBiomes.registerBiome(new PastureBiome(), "pasture");
        ModBiomes.registerBiome(new PoppyFieldBiome(), "poppy_field");
        ModBiomes.registerBiome(new PrairieBiome(), "prairie");
        ModBiomes.registerBiome(new PumpkinPatchBiome(), "pumpkin_patch");
        ModBiomes.registerBiome(new RainbowValleyBiome(), "rainbow_valley");
        ModBiomes.registerBiome(new RainforestBiome(), "rainforest");
        ModBiomes.registerBiome(new RedwoodForestBiome(), "redwood_forest");
        ModBiomes.registerBiome(new ScrublandBiome(), "scrubland");
        ModBiomes.registerBiome(new SeasonalForestBiome(), "seasonal_forest");
        ModBiomes.registerBiome(new ShieldBiome(), "shield");
        ModBiomes.registerBiome(new ShrublandBiome(), "shrubland");
        ModBiomes.registerBiome(new SilkgladeBiome(), "silkglade");
        ModBiomes.registerBiome(new SnowyConiferousForestBiome(), "snowy_coniferous_forest");
        ModBiomes.registerBiome(new SnowyFirClearingBiome(), "snowy_fir_clearing");
        ModBiomes.registerBiome(new SnowyForestBiome(), "snowy_forest");
        ModBiomes.registerBiome(new SteppeBiome(), "steppe");
        ModBiomes.registerBiome(new TemperateRainforestBiome(), "temperate_rainforest");
        ModBiomes.registerBiome(new TemperateRainforestHillsBiome(), "temperate_rainforest_hills");
        ModBiomes.registerBiome(new TropicalRainforestBiome(), "tropical_rainforest");
        ModBiomes.registerBiome(new TropicsBiome(), "tropics");
        ModBiomes.registerBiome(new TundraBiome(), "tundra");
        ModBiomes.registerBiome(new VolcanoBiome(), "volcano");
        ModBiomes.registerBiome(new WastelandBiome(), "wasteland");
        ModBiomes.registerBiome(new WetlandBiome(), "wetland");
        ModBiomes.registerBiome(new WoodlandBiome(), "woodland");
        ModBiomes.registerBiome(new XericShrublandBiome(), "xeric_shrubland");
        ModBiomes.registerBiome(new CrystallineChasmBiome(), "crystalline_chasm");
        ModBiomes.registerBiome(new UndergrowthBiome(), "undergrowth");
        ModBiomes.registerBiome(new VisceralHeapBiome(), "visceral_heap");
        ModBiomes.registerBiome(new WitheredAbyssBiome(), "withered_abyss");
        BiomeRegistry.configureStandardBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.STANDARD_BIOME);
        ModBiomes.registerSubBiome((RegistryKey<Biome>)Biomes.field_76769_d, BOPBiomes.oasis, 0.1f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.brushland, BOPBiomes.xeric_shrubland, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.coniferous_forest, BOPBiomes.fir_clearing, 0.38f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.highland, BOPBiomes.highland_moor, 0.75f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.meadow, BOPBiomes.flower_meadow, 0.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.prairie, BOPBiomes.pasture, 1.0f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.seasonal_forest, BOPBiomes.pumpkin_patch, 0.45f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.snowy_coniferous_forest, BOPBiomes.snowy_fir_clearing, 0.5f, 100);
        ModBiomes.registerSubBiome(BOPBiomes.temperate_rainforest, BOPBiomes.temperate_rainforest_hills, 0.8f, 100);
        BiomeRegistry.configureSubBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.SUB_BIOME);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.COOL_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.DRY_TEMPERATE, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.origin_hills, BOPClimates.WET_TEMPERATE, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.WARM_TEMPERATE, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.MEDITERRANEAN, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.volcano, BOPClimates.SAVANNA, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_valley, BOPClimates.WET_TEMPERATE, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_valley, BOPClimates.WARM_TEMPERATE, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.rainbow_valley, BOPClimates.MEDITERRANEAN, 25);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.SUBTROPICAL, 75);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.TROPICAL, 50);
        ModBiomes.registerIslandBiome(BOPBiomes.tropics, BOPClimates.HOT_DESERT, 50);
        BiomeRegistry.configureIslandBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.ISLAND_BIOME);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76774_n, BOPClimates.ICE_CAP, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76770_e, BOPClimates.TUNDRA, 7);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150584_S, BOPClimates.TUNDRA, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76768_g, BOPClimates.WET_BOREAL, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150578_U, BOPClimates.DRY_BOREAL, 5);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150585_R, BOPClimates.WET_TEMPERATE, 5);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76780_h, BOPClimates.WET_TEMPERATE, 7);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150583_P, BOPClimates.DRY_TEMPERATE, 7);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76767_f, BOPClimates.COOL_TEMPERATE, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76772_c, BOPClimates.WARM_TEMPERATE, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76782_w, BOPClimates.TROPICAL, 15);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150588_X, BOPClimates.SAVANNA, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_76769_d, BOPClimates.HOT_DESERT, 15);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150608_ab, BOPClimates.HOT_DESERT, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_150607_aa, BOPClimates.HOT_DESERT, 3);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235251_aB_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235253_az_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235254_j_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235252_ay_, BOPClimates.NETHER, 10);
        ModBiomes.registerVanillaBiome((RegistryKey<Biome>)Biomes.field_235250_aA_, BOPClimates.NETHER, 10);
        BiomeRegistry.configureVanillaBiomes();
        BiomeRegistry.finalizeRegistrations(BiomeRegistry.RegistrationType.VANILLA_BIOME);
        ModBiomes.registerVillagerTypes();
    }

    private static void registerVillagerTypes() {
        ModBiomes.registerVillagerType(BOPBiomes.alps, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.alps_foothills, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.bayou, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.bog, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.boreal_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.brushland, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.chaparral, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.cherry_blossom_grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.cold_desert, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.coniferous_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.dead_forest, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.fir_clearing, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.floodplain, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.flower_meadow, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.fungal_jungle, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.grassland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.gravel_beach, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.highland_moor, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lavender_field, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.lush_grassland, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.lush_swamp, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.mangrove, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.maple_woods, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.marsh, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.meadow, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.mire, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.muskeg, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.mystic_grove, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.oasis, VillagerType.field_221173_a);
        ModBiomes.registerVillagerType(BOPBiomes.ominous_woods, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.orchard, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.origin_hills, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.outback, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.overgrown_cliffs, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.pasture, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.poppy_field, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.prairie, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.pumpkin_patch, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.rainbow_valley, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.rainforest, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_forest, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.redwood_forest_edge, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.scrubland, VillagerType.field_221176_d);
        ModBiomes.registerVillagerType(BOPBiomes.seasonal_forest, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.shield, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.shrubland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.silkglade, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_coniferous_forest, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_fir_clearing, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.snowy_forest, VillagerType.field_221177_e);
        ModBiomes.registerVillagerType(BOPBiomes.steppe, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.temperate_rainforest, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.temperate_rainforest_hills, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.tropical_rainforest, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tropic_beach, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tropics, VillagerType.field_221174_b);
        ModBiomes.registerVillagerType(BOPBiomes.tundra, VillagerType.field_221179_g);
        ModBiomes.registerVillagerType(BOPBiomes.volcanic_plains, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.volcano, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.wasteland, VillagerType.field_221173_a);
        ModBiomes.registerVillagerType(BOPBiomes.wetland, VillagerType.field_221178_f);
        ModBiomes.registerVillagerType(BOPBiomes.woodland, VillagerType.field_221175_c);
        ModBiomes.registerVillagerType(BOPBiomes.xeric_shrubland, VillagerType.field_221173_a);
    }

    private static void registerVillagerType(RegistryKey<Biome> key, VillagerType type) {
        if (BiomeUtil.exists(key)) {
            VillagerType.field_221180_h.put(key, type);
        }
    }

    public static void registerBiome(BiomeTemplate biome, String name) {
        BiomeRegistry.deferStandardRegistration(biome, name);
    }

    public static void registerTechnicalBiome(BiomeTemplate biome, String name) {
        BiomeRegistry.deferTechnicalBiomeRegistration(biome, name);
    }

    public static void registerSubBiome(RegistryKey<Biome> parent, RegistryKey<Biome> child, float rarity, int weight) {
        BiomeRegistry.deferSubBiomeRegistration(parent, child, weight, rarity);
    }

    public static void registerIslandBiome(RegistryKey<Biome> key, BOPClimates climate, int weight) {
        BiomeRegistry.deferIslandBiomeRegistration(key, climate, weight);
    }

    private static void registerVanillaBiome(RegistryKey<Biome> key, BOPClimates climate, int weight) {
        BiomeRegistry.deferVanillaBiomeRegistration(key, climate, weight);
    }

    static {
        subBiomes = HashMultimap.create();
        islandBiomeIds = Lists.newArrayList();
        biomeMetadata = Maps.newHashMap();
    }

    public static class WeightedSubBiome {
        public final RegistryKey<Biome> biome;
        public final float rarity;
        public final int weight;

        public WeightedSubBiome(RegistryKey<Biome> biome, float rarity, int weight) {
            this.biome = biome;
            this.rarity = rarity;
            this.weight = weight;
        }
    }
}

