/*
 * Decompiled with CFR 0.152.
 */
package com.fizix.birdsneststres;

import com.fizix.birdsneststres.Config;
import com.fizix.birdsneststres.setup.ItemListManager;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HarvestTreasureEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Boolean isSubmerged = false;

    @SubscribeEvent
    public void onDrops(BlockEvent.BreakEvent event) {
        int rarityToUse = 25;
        String blockRegistryName = "";
        String blockBiomeName = "";
        Boolean dropNest = false;
        Boolean dropBanditPouch = false;
        Boolean dropAncientTreasure = false;
        Boolean dropSunkenTreasure = false;
        Block theblock = event.getState().func_177230_c();
        Random random = new Random();
        BlockPos pos = event.getPos();
        isSubmerged = event.getPlayer().func_203005_aq() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        blockRegistryName = theblock.getRegistryName().toString();
        blockBiomeName = event.getWorld().func_226691_t_(pos).func_210773_k();
        dropNest = this.dropDiscovery("nest", theblock, blockRegistryName, blockBiomeName, (Boolean)Config.NEST_ENABLED.get());
        dropBanditPouch = this.dropDiscovery("bandit_pouch", theblock, blockRegistryName, blockBiomeName, (Boolean)Config.BANDIT_POUCH_ENABLED.get());
        dropAncientTreasure = this.dropDiscovery("ancient_treasure", theblock, blockRegistryName, blockBiomeName, (Boolean)Config.ANCIENT_TREASURE_ENABLED.get());
        dropSunkenTreasure = this.dropDiscovery("sunken_treasure", theblock, blockRegistryName, blockBiomeName, (Boolean)Config.SUNKEN_TREASURE_ENABLED.get());
        if (dropNest.booleanValue()) {
            rarityToUse = this.getNestDropRarity(theblock, blockRegistryName, blockBiomeName);
            this.spawnDrop(new ItemStack((IItemProvider)ItemListManager.BIRDSNEST, 1), event, pos, rarityToUse);
        }
        if (dropBanditPouch.booleanValue()) {
            rarityToUse = this.getBanditPouchDropRarity(theblock, blockRegistryName, blockBiomeName);
            this.spawnDrop(new ItemStack((IItemProvider)ItemListManager.BANDITPOUCH, 1), event, pos, rarityToUse);
        }
        if (dropAncientTreasure.booleanValue()) {
            rarityToUse = this.getAncientTreasureDropRarity(theblock, blockRegistryName, blockBiomeName);
            this.spawnDrop(new ItemStack((IItemProvider)ItemListManager.ANCIENTTREASURE, 1), event, pos, rarityToUse);
        }
        if (dropSunkenTreasure.booleanValue()) {
            rarityToUse = this.getSunkenTreasureDropRarity(theblock, blockRegistryName, blockBiomeName);
            this.spawnDrop(new ItemStack((IItemProvider)ItemListManager.SUNKENTREASURE, 1), event, pos, rarityToUse);
        }
    }

    private Boolean dropDiscovery(String dropType, Block inBlock, String inRegistry, String inBiome, Boolean isEnabled) {
        Boolean isActive = false;
        if (dropType == "nest" && isEnabled.booleanValue() && inBlock.func_203417_a((ITag)BlockTags.field_206952_E)) {
            isActive = true;
        }
        if (dropType == "bandit_pouch" && isEnabled.booleanValue() && (inBlock.func_203417_a((ITag)BlockTags.field_203436_u) || inRegistry == "minecraft:snow_block" || inRegistry == "minecraft:grass" || inRegistry == "minecraft:tall_grass" || inRegistry == "biomesoplenty:bush")) {
            isActive = true;
        }
        if (dropType == "ancient_treasure" && isEnabled.booleanValue() && (inBlock.func_203417_a((ITag)BlockTags.field_205213_E) || inBlock.func_203417_a((ITag)BlockTags.field_203436_u) || inRegistry == "minecraft:snow_block")) {
            if (inBlock.func_203417_a((ITag)BlockTags.field_205213_E)) {
                isActive = true;
            }
            if (inRegistry == "minecraft:snow_block" && (inBiome == "biome.minecraft.snowy_tundra" || inBiome == "biome.minecraft.snowy_mountains" || inBiome == "biome.minecraft.frozen_ocean" || inBiome == "biome.minecraft.frozen_river" || inBiome == "biome.minecraft.deep_frozen_ocean" || inBiome == "biome.biomesoplenty.alps" || inBiome == "biome.biomesoplenty.cold_desert" || inBiome == "biome.biomesoplenty.snowy_coniferous_forest" || inBiome == "biome.biomesoplenty.snowy_fir_clearing" || inBiome == "biome.biomesoplenty.snowy_forest" || inBiome == "biome.biomesoplenty.alps_foothills" || inBiome == "biome.biomesoplenty.tundra")) {
                isActive = true;
            }
            if (inBlock.func_203417_a((ITag)BlockTags.field_203436_u) && (inBiome == "biome.minecraft.desert" || inBiome == "biome.minecraft.desert_hills" || inBiome == "biome.minecraft.desert_lakes" || inBiome == "biome.minecraft.desert_lakes" || inBiome == "biome.biomesoplenty.cold_desert" || inBiome == "biome.biomesoplenty.oasis" || inBiome == "biome.biomesoplenty.outback" || inBiome == "biome.biomesoplenty.dead_reef")) {
                isActive = true;
            }
        }
        if (dropType == "sunken_treasure" && isEnabled.booleanValue()) {
            if (inBlock.func_203417_a((ITag)BlockTags.field_205598_B)) {
                isActive = true;
            }
            if ((inBiome == "biome.minecraft.frozen_ocean" || inBiome == "biome.minecraft.beach" || inBiome == "biome.minecraft.deep_ocean" || inBiome == "biome.minecraft.snowy_beach" || inBiome == "biome.minecraft.warm_ocean" || inBiome == "biome.minecraft.lukewarm_ocean" || inBiome == "biome.minecraft.cold_ocean" || inBiome == "biome.minecraft.deep_warm_ocean" || inBiome == "biome.minecraft.deep_lukewarm_ocean" || inBiome == "biome.minecraft.deep_cold_ocean" || inBiome == "biome.minecraft.deep_frozen_ocean" || inBiome == "biome.biomesoplenty.dead_reef") && inBlock.func_203417_a((ITag)BlockTags.field_203436_u)) {
                isActive = true;
            }
        }
        return isActive;
    }

    private int getNestDropRarity(Block thisblock, String thisRegistry, String thisBiome) {
        int rarity = (Integer)Config.NEST_DROP_RARITY_NORMAL.get();
        if (thisBiome == "biome.minecraft.forest" || thisBiome == "biome.minecraft.jungle" || thisBiome == "biome.minecraft.birch_forest" || thisBiome == "biome.minecraft.dark_forest" || thisBiome == "biome.minecraft.giant_tree_taiga" || thisBiome == "biome.minecraft.modified_jungle" || thisBiome == "biome.minecraft.tall_birch_forest" || thisBiome == "biome.minecraft.giant_spruce_taiga" || thisBiome == "biome.minecraft.bamboo_jungle" || thisBiome == "biome.biomesoplenty.cherry_blossom_grove" || thisBiome == "biome.biomesoplenty.coniferous_forest" || thisBiome == "biome.biomesoplenty.dead_forest" || thisBiome == "biome.biomesoplenty.grove" || thisBiome == "biome.biomesoplenty.maple_woods" || thisBiome == "biome.biomesoplenty.mystic_grove" || thisBiome == "biome.biomesoplenty.ominous_woods" || thisBiome == "biome.biomesoplenty.rainforest" || thisBiome == "biome.biomesoplenty.redwood_forest" || thisBiome == "biome.biomesoplenty.seasonal_forest" || thisBiome == "biome.biomesoplenty.snowy_coniferous_forest" || thisBiome == "biome.biomesoplenty.snowy_forest" || thisBiome == "biome.biomesoplenty.temperate_rainforest" || thisBiome == "biome.biomesoplenty.tropical_rainforest" || thisBiome == "biome.biomesoplenty.woodland" || thisBiome == "biome.biomesoplenty.ethereal_forest") {
            rarity = (Integer)Config.NEST_DROP_RARITY_HIGH.get();
        }
        return rarity;
    }

    private int getBanditPouchDropRarity(Block thisblock, String thisRegistry, String thisBiome) {
        int rarity = (Integer)Config.BANDIT_POUCH_DROP_RARITY_NORMAL.get();
        if (thisRegistry == "minecraft:grass" || thisRegistry == "minecraft:tall_grass" || thisRegistry == "biomesoplenty:bush") {
            rarity = (Integer)Config.BANDIT_POUCH_DROP_RARITY_LOW.get();
        }
        if (thisblock.func_203417_a((ITag)BlockTags.field_203436_u) || thisRegistry == "minecraft:snow_block") {
            rarity = (Integer)Config.BANDIT_POUCH_DROP_RARITY_LOW.get();
        }
        return rarity;
    }

    private int getAncientTreasureDropRarity(Block thisblock, String thisRegistry, String thisBiome) {
        int rarity = (Integer)Config.ANCIENT_TREASURE_DROP_RARITY_NORMAL.get();
        if (thisblock.func_203417_a((ITag)BlockTags.field_203436_u) || thisRegistry == "minecraft:snow_block") {
            rarity = (Integer)Config.ANCIENT_TREASURE_DROP_RARITY_LOW.get();
        }
        return rarity;
    }

    private int getSunkenTreasureDropRarity(Block thisblock, String thisRegistry, String thisBiome) {
        int rarity = (Integer)Config.SUNKEN_TREASURE_DROP_RARITY_NORMAL.get();
        if (thisblock.func_203417_a((ITag)BlockTags.field_203436_u)) {
            rarity = (Integer)Config.SUNKEN_TREASURE_DROP_RARITY_LOW.get();
            if (isSubmerged.booleanValue()) {
                rarity = (Integer)Config.SUNKEN_TREASURE_DROP_RARITY_NORMAL.get();
            }
        }
        if (thisblock.func_203417_a((ITag)BlockTags.field_205598_B)) {
            rarity = (Integer)Config.SUNKEN_TREASURE_DROP_RARITY_HIGH.get();
        }
        return rarity;
    }

    private void spawnDrop(ItemStack thisStack, BlockEvent.BreakEvent thisEvent, BlockPos thisPos, int thisRarity) {
        Random random = new Random();
        double d0 = (double)random.nextFloat() * 0.5 + 0.25;
        double d1 = (double)random.nextFloat() * 0.5 + 0.25;
        double d2 = (double)random.nextFloat() * 0.5 + 0.25;
        int randRarity = random.nextInt(thisRarity);
        if (randRarity == 0) {
            ItemEntity entityitem = new ItemEntity((World)((ServerWorld)thisEvent.getWorld()), (double)thisPos.func_177958_n() + d0, (double)thisPos.func_177956_o() + d1, (double)thisPos.func_177952_p() + d2, thisStack);
            thisEvent.getWorld().func_217376_c((Entity)entityitem);
        }
    }
}

