/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib.mixin;

import com.kotori316.scala_lib.util.LazySupplierWrapper;
import java.util.Optional;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.util.NonNullPredicate;
import net.minecraftforge.common.util.NonNullSupplier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LazyOptional.class})
public abstract class OptionalMixin<T> {
    private boolean kotori_scala_LazyOptional_wrapping = false;
    @Shadow(remap=false)
    private boolean isValid;
    @Final
    private NonNullSupplier<?> supplier;

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    public void initMixin(NonNullSupplier<?> instanceSupplier, CallbackInfo ci) {
        if (instanceSupplier instanceof LazySupplierWrapper) {
            this.kotori_scala_LazyOptional_wrapping = true;
        }
    }

    @Inject(method={"getValue"}, at={@At(value="HEAD")}, remap=false)
    private void getValueMixin(CallbackInfoReturnable<T> cir) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            throw new IllegalStateException("getValue is accessed from mixin modified optional. Did API change?");
        }
    }

    @Inject(method={"isPresent"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void isPresentMixin(CallbackInfoReturnable<Boolean> cir) {
        if (this.kotori_scala_LazyOptional_wrapping && this.isValid) {
            boolean present = ((LazySupplierWrapper)this.supplier).isPresent();
            if (!present) {
                this.invalidate();
            }
            cir.setReturnValue((Object)present);
        }
    }

    @Inject(method={"ifPresent"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void ifPresentMixin(NonNullConsumer<? super T> consumer, CallbackInfo ci) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            if (this.isValid) {
                ((LazySupplierWrapper)this.supplier).ifPresent(consumer, this::invalidate);
            }
            ci.cancel();
        }
    }

    @Inject(method={"map"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public <U> void mapMixin(NonNullFunction<? super T, ? extends U> mapper, CallbackInfoReturnable<Optional<U>> cir) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            Optional<Object> r;
            if (this.isValid) {
                LazySupplierWrapper<U> wrapper = ((LazySupplierWrapper)this.supplier).map(mapper);
                r = wrapper.getAsJava();
            } else {
                r = Optional.empty();
            }
            cir.setReturnValue(r);
        }
    }

    @Inject(method={"lazyMap"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public <U> void lazyMapMixin(NonNullFunction<? super T, ? extends U> mapper, CallbackInfoReturnable<LazyOptional<U>> cir) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            LazyOptional r;
            if (this.isValid) {
                LazySupplierWrapper<? extends U> wrapper = ((LazySupplierWrapper)this.supplier).map(mapper);
                r = LazyOptional.of(wrapper);
            } else {
                r = LazyOptional.empty();
            }
            cir.setReturnValue((Object)r);
        }
    }

    @Inject(method={"filter"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void filterMixin(NonNullPredicate<? super T> predicate, CallbackInfoReturnable<Optional<T>> cir) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            if (this.isValid) {
                LazySupplierWrapper<T> wrapper = ((LazySupplierWrapper)this.supplier).filter(predicate);
                cir.setReturnValue(wrapper.getAsJava());
            } else {
                cir.setReturnValue(Optional.empty());
            }
        }
    }

    @Inject(method={"resolve"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void resolveMixin(CallbackInfoReturnable<Optional<T>> cir) {
        if (this.kotori_scala_LazyOptional_wrapping && this.isValid) {
            cir.setReturnValue(((LazySupplierWrapper)this.supplier).getAsJava());
        }
    }

    @Inject(method={"orElse"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void orElseMixin(T other, CallbackInfoReturnable<T> cir) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            T value = this.isValid ? ((LazySupplierWrapper)this.supplier).orElse(other, this::invalidate) : other;
            cir.setReturnValue(value);
        }
    }

    @Inject(method={"orElseGet"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void orElseGetMixin(NonNullSupplier<? extends T> other, CallbackInfoReturnable<T> cir) {
        if (this.kotori_scala_LazyOptional_wrapping) {
            Object value = this.isValid ? ((LazySupplierWrapper)this.supplier).orElse(other, this::invalidate) : other.get();
            cir.setReturnValue(value);
        }
    }

    @Inject(method={"orElseThrow"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public <X extends Throwable> void orElseThrowMixin(NonNullSupplier<? extends X> exceptionSupplier, CallbackInfoReturnable<T> cir) throws X {
        if (this.kotori_scala_LazyOptional_wrapping) {
            if (this.isValid) {
                cir.setReturnValue(((LazySupplierWrapper)this.supplier).orThrow(exceptionSupplier, this::invalidate));
            } else {
                throw (Throwable)exceptionSupplier.get();
            }
        }
    }

    @Shadow(remap=false)
    public abstract void invalidate();
}

