/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib.test;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraftforge.common.util.LazyOptional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OptionalTest1 {
    OptionalTest1() {
    }

    @Test
    void test1() {
        LazyOptional lazyOptional = LazyOptional.of(() -> "TNT");
        Assertions.assertEquals((Object)"TNT", (Object)lazyOptional.orElse((Object)"NULL"));
        lazyOptional.invalidate();
        Assertions.assertEquals((Object)"NULL", (Object)lazyOptional.orElse((Object)"NULL"));
    }

    @Test
    void test2() {
        AtomicReference<String> reference = new AtomicReference<String>("First");
        LazyOptional lazyOptional = LazyOptional.of(reference::get);
        reference.set("Second");
        Assertions.assertEquals((Object)"Second", (Object)lazyOptional.orElse((Object)"NULL"));
        reference.set("Third");
        Assertions.assertEquals((Object)"Second", (Object)lazyOptional.orElse((Object)"NULL"));
        lazyOptional.invalidate();
        Assertions.assertEquals((Object)"NULL", (Object)lazyOptional.orElse((Object)"NULL"));
    }

    @Test
    void test3() {
        AtomicReference<String> reference = new AtomicReference<String>("First");
        LazyOptional lazyOptional = LazyOptional.of(reference::get).lazyMap(s -> s + s);
        Optional normalOptional = LazyOptional.of(reference::get).map(s -> s + s);
        reference.set("Second");
        Assertions.assertEquals((Object)"SecondSecond", (Object)lazyOptional.orElse((Object)"NULL"));
        Assertions.assertEquals((Object)"FirstFirst", (Object)normalOptional.orElse("NULL"));
        lazyOptional.invalidate();
        Assertions.assertEquals((Object)"NULL", (Object)lazyOptional.orElse((Object)"NULL"));
    }
}

