/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib.test;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@Mod(value="slp_test")
class SLPTest {
    public static final String modID = "slp_test";
    private static final Logger LOGGER = LogManager.getLogger((String)"SLPTest");

    public SLPTest() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dataEvent);
    }

    public void dataEvent(GatherDataEvent event) {
        if (event.includeDev()) {
            event.getGenerator().addProvider((IDataProvider)new TestProvider());
        }
    }

    private static class TestProvider
    implements IDataProvider {
        private TestProvider() {
        }

        private static boolean isInCI() {
            return Boolean.parseBoolean(System.getenv("GITHUB_ACTIONS"));
        }

        public void act(DirectoryCache cache) {
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)SLPTest.class.getPackage().getName())}).build();
            if (TestProvider.isInCI()) {
                try {
                    Files.createFile(Paths.get("..", "test_started.txt"), new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOGGER.error("File IO", (Throwable)e);
                }
            }
            Launcher launcher = LauncherFactory.create();
            SummaryGeneratingListener listener = new SummaryGeneratingListener();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary summary = listener.getSummary();
            StringWriter stream = new StringWriter();
            summary.printTo(new PrintWriter(stream));
            LOGGER.info(stream.toString());
            List<Throwable> errors = summary.getFailures().stream().map(TestExecutionSummary.Failure::getException).collect(Collectors.toList());
            errors.forEach(t -> LOGGER.fatal("Test failed.", t));
            if (TestProvider.isInCI() && !errors.isEmpty()) {
                try (BufferedWriter w = Files.newBufferedWriter(Paths.get("..", "error-trace.txt"), new OpenOption[0]);
                     PrintWriter writer = new PrintWriter(w);){
                    errors.forEach(t -> t.printStackTrace(writer));
                }
                catch (IOException e) {
                    LOGGER.error("File IO", (Throwable)e);
                }
            }
        }

        public String getName() {
            return "TestProvider of SLP";
        }
    }
}

