/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks.base;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.state.VerticalSlabState;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BaseVerticalSlab
extends BaseDerivativeBlock
implements IWaterLoggable {
    public static final EnumProperty<VerticalSlabState> TYPE = EnumProperty.func_177709_a((String)"type", VerticalSlabState.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public BaseVerticalSlab(String name, Block source) {
        super(name + "_vertical_slab", source);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)VerticalSlabState.NORTH))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VerticalSlabState slabtype = (VerticalSlabState)((Object)state.func_177229_b(TYPE));
        switch (slabtype) {
            case DOUBLEX: {
                return VoxelShapes.func_197868_b();
            }
            case DOUBLEZ: {
                return VoxelShapes.func_197868_b();
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    private VerticalSlabState getDoubleState(VerticalSlabState s) {
        if (s == VerticalSlabState.EAST || s == VerticalSlabState.WEST) {
            return VerticalSlabState.DOUBLEX;
        }
        return VerticalSlabState.DOUBLEZ;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext c) {
        BlockPos blockpos = c.func_195995_a();
        BlockState blockstate = c.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this) {
            return (BlockState)((BlockState)blockstate.func_206870_a(TYPE, (Comparable)((Object)this.getDoubleState((VerticalSlabState)((Object)blockstate.func_177229_b(TYPE)))))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        IFluidState ifluidstate = c.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)VerticalSlabState.NORTH))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction face = c.func_196000_l();
        double flagdx = c.func_221532_j().field_72450_a - (double)c.func_195995_a().func_177958_n() - 0.5;
        double flagdz = c.func_221532_j().field_72449_c - (double)c.func_195995_a().func_177952_p() - 0.5;
        VerticalSlabState vss = VerticalSlabState.forFacings(face, c.func_195992_f());
        if (flagdz > 0.0 && this.difg(flagdz, flagdx)) {
            vss = VerticalSlabState.SOUTH;
        }
        if (flagdz < 0.0 && this.difg(flagdz, flagdx)) {
            vss = VerticalSlabState.NORTH;
        }
        if (flagdx > 0.0 && this.difg(flagdx, flagdz)) {
            vss = VerticalSlabState.EAST;
        }
        if (flagdx < 0.0 && this.difg(flagdx, flagdz)) {
            vss = VerticalSlabState.WEST;
        }
        return (BlockState)blockstate1.func_206870_a(TYPE, (Comparable)((Object)vss));
    }

    private boolean difg(double d1, double d2) {
        return Math.abs(d1) > Math.abs(d2);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext c) {
        ItemStack itemstack = c.func_195996_i();
        VerticalSlabState slabtype = (VerticalSlabState)((Object)state.func_177229_b(TYPE));
        if (slabtype != VerticalSlabState.DOUBLEX && slabtype != VerticalSlabState.DOUBLEZ && itemstack.func_77973_b() == this.func_199767_j()) {
            if (c.func_196012_c()) {
                if (c.func_196000_l() == Direction.NORTH && slabtype == VerticalSlabState.SOUTH) {
                    return true;
                }
                if (c.func_196000_l() == Direction.EAST && slabtype == VerticalSlabState.WEST) {
                    return true;
                }
                if (c.func_196000_l() == Direction.SOUTH && slabtype == VerticalSlabState.NORTH) {
                    return true;
                }
                return c.func_196000_l() == Direction.WEST && slabtype == VerticalSlabState.EAST;
            }
            return true;
        }
        return false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        return state.func_177229_b(TYPE) != VerticalSlabState.DOUBLEX && state.func_177229_b(TYPE) != VerticalSlabState.DOUBLEZ ? super.func_204509_a(worldIn, pos, state, fluidStateIn) : false;
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(TYPE) != VerticalSlabState.DOUBLEX && state.func_177229_b(TYPE) != VerticalSlabState.DOUBLEZ ? super.func_204510_a(worldIn, pos, state, fluidIn) : false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

