/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.corelib.config.ConfigBase;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerConfig
extends ConfigBase {
    public final ForgeConfigSpec.IntValue imageCooldown;
    private final ForgeConfigSpec.ConfigValue<String> cameraConsumeItemSpec;
    public final ForgeConfigSpec.IntValue cameraConsumeItemAmount;
    public final ForgeConfigSpec.IntValue maxImageSize;
    public final ForgeConfigSpec.DoubleValue imageCompression;
    public final ForgeConfigSpec.BooleanValue allowImageUpload;
    public final ForgeConfigSpec.BooleanValue frameOnlyOwnerModify;
    public Item cameraConsumeItem;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
        this.imageCooldown = builder.comment("The time in milliseconds the camera will be on cooldown after taking an image").defineInRange("camera.cooldown", 5000, 100, Integer.MAX_VALUE);
        this.cameraConsumeItemSpec = builder.comment("The item that is consumed when taking an image").define("camera.consumed_item.item", (Object)"minecraft:paper");
        this.cameraConsumeItemAmount = builder.comment("The amount of the item that is consumed when taking an image").defineInRange("camera.consumed_item.amount", 1, 1, Short.MAX_VALUE);
        this.maxImageSize = builder.comment(new String[]{"The maximum size of an image in bytes when transferred to the server", "Higher values mean more delay/lag between taking an image and getting it into your inventory"}).defineInRange("image.max_size", 200000, 50000, 1000000);
        this.imageCompression = builder.comment(new String[]{"The amount of jpeg compression applied to the image", "If the image exceeds the 'max_image_size', it will get compressed anyways"}).defineInRange("image.compression", 0.5, 0.1, 1.0);
        this.allowImageUpload = builder.comment("If it is allowed to upload custom images").define("image.allow_upload", true);
        this.frameOnlyOwnerModify = builder.comment("If only the owner can modify or break the image frame").define("image_frame.only_owner_modify", false);
    }

    @Override
    public void onReload(ModConfig.ModConfigEvent event) {
        super.onReload(event);
        this.cameraConsumeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)this.cameraConsumeItemSpec.get()));
        if (this.cameraConsumeItem == null) {
            this.cameraConsumeItem = Items.field_151121_aF;
        }
    }
}

