/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;

public class ImageRenderer
extends EntityRenderer<ImageEntity> {
    private static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private static final ResourceLocation EMPTY_IMAGE = new ResourceLocation("camera", "textures/images/empty_image.png");
    private static final ResourceLocation FRAME_SIDE = new ResourceLocation("camera", "textures/images/frame_side.png");
    private static final ResourceLocation FRAME_BACK = new ResourceLocation("camera", "textures/images/frame_back.png");
    private static final float THICKNESS = 0.0625f;
    public static final UUID DEFAULT_IMAGE_UUID = new UUID(0L, 0L);
    private static Minecraft mc;

    public ImageRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        mc = Minecraft.func_71410_x();
    }

    public void render(ImageEntity entity, float f1, float f2, MatrixStack matrixStack, IRenderTypeBuffer buffer1, int light) {
        int imageLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)entity.getCenterPosition());
        ImageRenderer.renderImage(entity.getImageUUID().orElse(null), entity.getFacing(), entity.getFrameWidth(), entity.getFrameHeight(), matrixStack, buffer1, imageLight);
        ImageRenderer.renderBoundingBox(entity, matrixStack, buffer1);
        super.func_225623_a_((Entity)entity, f1, f2, matrixStack, buffer1, light);
    }

    public static void renderImage(UUID imageUUID, Direction facing, float width, float height, MatrixStack matrixStack, IRenderTypeBuffer buffer1, int light) {
        float ratioY;
        float ratioX;
        matrixStack.func_227860_a_();
        float imageRatio = 1.0f;
        boolean stretch = true;
        ResourceLocation resourceLocation = EMPTY_IMAGE;
        if (DEFAULT_IMAGE_UUID.equals(imageUUID)) {
            resourceLocation = DEFAULT_IMAGE;
            imageRatio = 1.5f;
            stretch = false;
        } else if (imageUUID != null) {
            ResourceLocation rl = TextureCache.instance().getImage(imageUUID);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage image = TextureCache.instance().getNativeImage(imageUUID);
                imageRatio = (float)image.func_195702_a() / (float)image.func_195714_b();
                stretch = false;
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
                stretch = false;
            }
        }
        matrixStack.func_227861_a_(-0.5, 0.0, -0.5);
        ImageRenderer.rotate(facing, matrixStack);
        float frameRatio = width / height;
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX *= width;
            ratioY *= height;
        }
        IVertexBuilder builderFront = buffer1.getBuffer(ImageRenderer.getRenderType(resourceLocation));
        ImageRenderer.vertex(builderFront, matrixStack, 0.0f + ratioX, ratioY, 0.0625f, 0.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, ratioY, 0.0625f, 1.0f, 1.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f, 0.0f, light);
        ImageRenderer.vertex(builderFront, matrixStack, ratioX, height - ratioY, 0.0625f, 0.0f, 0.0f, light);
        IVertexBuilder builderSide = buffer1.getBuffer(ImageRenderer.getRenderType(FRAME_SIDE));
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 1.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.9375f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.9375f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 1.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 0.0f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 0.0f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 0.0625f, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 0.0625f, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, height - ratioY, 0.0625f, 0.0f + ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0625f, 1.0f - ratioX, 0.9375f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f, light);
        ImageRenderer.vertex(builderSide, matrixStack, width - ratioX, 0.0f + ratioY, 0.0625f, 1.0f - ratioX, 0.0625f, light);
        ImageRenderer.vertex(builderSide, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.0f + ratioX, 0.0625f, light);
        IVertexBuilder builderBack = buffer1.getBuffer(ImageRenderer.getRenderType(FRAME_BACK));
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f + ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f - ratioY, light);
        ImageRenderer.vertex(builderBack, matrixStack, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f - ratioY, light);
        matrixStack.func_227865_b_();
    }

    private static void vertex(IVertexBuilder builder, MatrixStack matrixStack, float x, float y, float z, float u, float v, int light) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = entry.func_227870_a_();
        Matrix3f matrix3f = entry.func_227872_b_();
        builder.func_227888_a_(matrix4f, x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(matrix3f, 0.0f, 0.0f, -1.0f).func_181675_d();
    }

    private static RenderType getRenderType(ResourceLocation resourceLocation) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(resourceLocation, false, false)).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228719_a_(new RenderState.LightmapState(true)).func_228722_a_(new RenderState.OverlayState(true)).func_228714_a_(new RenderState.CullState(true)).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_cutout", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    private static void renderBoundingBox(ImageEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        if (ImageRenderer.getEntityLookingAt() != entity) {
            return;
        }
        if (ImageRenderer.mc.field_71474_y.field_74319_N) {
            return;
        }
        matrixStack.func_227860_a_();
        ImageRenderer.renderBoundingBox(matrixStack, buffer, entity);
        matrixStack.func_227865_b_();
    }

    private static void renderBoundingBox(MatrixStack matrixStack, IRenderTypeBuffer buffer, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72317_d(-entity.func_226277_ct_(), -entity.func_226278_cu_(), -entity.func_226281_cx_());
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)axisalignedbb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
    }

    public static void rotate(Direction facing, MatrixStack matrixStack) {
        switch (facing) {
            case NORTH: {
                matrixStack.func_227861_a_(1.0, 0.0, 1.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227861_a_(1.0, 0.0, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(270.0f));
            }
        }
    }

    @Nullable
    public ResourceLocation getEntityTexture(ImageEntity entity) {
        return EMPTY_IMAGE;
    }

    public static Entity getEntityLookingAt() {
        AxisAlignedBB extendedBoundingBox;
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null) {
            return null;
        }
        if (mc.field_71441_e == null) {
            return null;
        }
        double reachDistance = mc.field_71442_b.func_78757_d();
        Vector3d eyePosition = entity.func_174824_e(mc.func_184121_ak());
        double reachDistanceSquared = reachDistance * reachDistance;
        Vector3d lookVec = entity.func_70676_i(1.0f);
        Vector3d lookVecReach = eyePosition.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        EntityRayTraceResult result = ProjectileHelper.func_221273_a((Entity)entity, (Vector3d)eyePosition, (Vector3d)lookVecReach, (AxisAlignedBB)(extendedBoundingBox = entity.func_174813_aQ().func_216361_a(lookVec.func_186678_a(reachDistance)).func_72314_b(1.0, 1.0, 1.0)), entity1 -> true, (double)reachDistanceSquared);
        if (result == null) {
            return null;
        }
        double squareDistance = eyePosition.func_72436_e(result.func_216347_e());
        if (squareDistance > 9.0) {
            return null;
        }
        if (squareDistance >= reachDistanceSquared) {
            return null;
        }
        return result.func_216348_a();
    }
}

