/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.gui.DummyContainer;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ImageScreen
extends ContainerScreen<Container> {
    public static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private UUID imageUUID;

    public ImageScreen(ItemStack image) {
        super((Container)new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.image.title"));
        this.imageUUID = Main.IMAGE.getUUID(image);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.imageUUID == null) {
            return;
        }
        ImageScreen.drawImage(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 100.0f, this.imageUUID);
    }

    public static void drawImage(Minecraft minecraft, int width, int height, float zLevel, UUID uuid) {
        float hnew;
        float wnew;
        RenderSystem.pushMatrix();
        ResourceLocation location = TextureCache.instance().getImage(uuid);
        float imageWidth = 12.0f;
        float imageHeight = 8.0f;
        if (location == null) {
            minecraft.func_110434_K().func_110577_a(DEFAULT_IMAGE);
        } else {
            minecraft.func_110434_K().func_110577_a(location);
            NativeImage image = TextureCache.instance().getNativeImage(uuid);
            imageWidth = image.func_195702_a();
            imageHeight = image.func_195714_b();
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float scale = 0.8f;
        float ws = (float)width * scale;
        float hs = (float)height * scale;
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        buffer.func_225582_a_((double)(left += (1.0f - scale) * ws / 2.0f), (double)(top += (1.0f - scale) * hs / 2.0f), (double)zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)left, (double)(top + hnew), (double)zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(left + wnew), (double)(top + hnew), (double)zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_225582_a_((double)(left + wnew), (double)top, (double)zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
    }

    protected void func_230451_b_(MatrixStack p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }
}

