/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ResizeFrameScreen
extends ContainerScreen<Container> {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/resize_frame.png");
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 50;
    private UUID uuid;
    private float visibility;
    private Button visibilityButton;
    private long lastCheck;

    public ResizeFrameScreen(UUID uuid) {
        super((Container)new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.frame.resize"));
        this.uuid = uuid;
        this.visibility = ((Double)Main.CLIENT_CONFIG.resizeGuiOpacity.get()).floatValue();
        this.field_146999_f = 248;
        this.field_147000_g = 109;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int left = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.func_230480_a_((Widget)new Button(left + 10, this.field_230709_l_ / 2 - 10, 50, 20, (ITextComponent)new StringTextComponent(""), button -> this.sendMoveImage(MessageResizeFrame.Direction.LEFT)));
        this.func_230480_a_((Widget)new Button(left + this.field_146999_f - 50 - 10, this.field_230709_l_ / 2 - 10, 50, 20, (ITextComponent)new StringTextComponent(""), button -> this.sendMoveImage(MessageResizeFrame.Direction.RIGHT)));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 25, this.field_147009_r + 10, 50, 20, (ITextComponent)new StringTextComponent(""), button -> this.sendMoveImage(MessageResizeFrame.Direction.UP)));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 25, this.field_147009_r + this.field_147000_g - 10 - 20, 50, 20, (ITextComponent)new StringTextComponent(""), button -> this.sendMoveImage(MessageResizeFrame.Direction.DOWN)));
        this.visibilityButton = new Button(left + this.field_146999_f - 20 - 10, this.field_147009_r + 10, 20, 20, (ITextComponent)new TranslationTextComponent("tooltip.visibility_short"), button -> {
            this.visibility = (float)((double)this.visibility - 0.25);
            if (this.visibility < 0.0f) {
                this.visibility = 1.0f;
            }
            Main.CLIENT_CONFIG.resizeGuiOpacity.set((Object)this.visibility);
            Main.CLIENT_CONFIG.resizeGuiOpacity.save();
        });
        this.func_230480_a_((Widget)this.visibilityButton);
    }

    private void sendMoveImage(MessageResizeFrame.Direction direction) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageResizeFrame(this.uuid, direction, !Screen.func_231173_s_()));
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        if (this.visibility >= 1.0f) {
            this.func_230446_a_(matrixStack);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.visibility);
        this.field_230706_i_.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        String title = new TranslationTextComponent("gui.frame.resize").getString();
        int titleWidth = this.field_230712_o_.func_78256_a(title);
        float f = this.field_146999_f / 2 - titleWidth / 2;
        int n = this.field_147000_g / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238421_b_(matrixStack, title, f, (float)(n - 9 - 1), TextFormatting.DARK_GRAY.func_211163_e().intValue());
        String description = new TranslationTextComponent("gui.frame.resize_description").getString();
        int descriptionWidth = this.field_230712_o_.func_78256_a(description);
        this.field_230712_o_.func_238421_b_(matrixStack, description, (float)(this.field_146999_f / 2 - descriptionWidth / 2), (float)(this.field_147000_g / 2 + 1), TextFormatting.GRAY.func_211163_e().intValue());
        this.field_230706_i_.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        if (Screen.func_231173_s_()) {
            this.func_238474_b_(matrixStack, this.field_146999_f / 2 - 8, 12, 16, 109, 16, 16);
            this.func_238474_b_(matrixStack, this.field_146999_f / 2 - 8, this.field_147000_g - 10 - 20 + 2, 0, 109, 16, 16);
            this.func_238474_b_(matrixStack, 27, this.field_147000_g / 2 - 10 + 3, 0, 125, 16, 16);
            this.func_238474_b_(matrixStack, this.field_146999_f - 10 - 25 - 8, this.field_147000_g / 2 - 10 + 3, 16, 125, 16, 16);
        } else {
            this.func_238474_b_(matrixStack, this.field_146999_f / 2 - 8, 12, 0, 109, 16, 16);
            this.func_238474_b_(matrixStack, this.field_146999_f / 2 - 8, this.field_147000_g - 10 - 20 + 2, 16, 109, 16, 16);
            this.func_238474_b_(matrixStack, 27, this.field_147000_g / 2 - 10 + 3, 16, 125, 16, 16);
            this.func_238474_b_(matrixStack, this.field_146999_f - 10 - 25 - 8, this.field_147000_g / 2 - 10 + 3, 0, 125, 16, 16);
        }
        if (this.visibilityButton.func_230449_g_()) {
            this.func_238654_b_(matrixStack, Arrays.asList(new TranslationTextComponent("tooltip.visibility").func_241878_f()), x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            if (!this.isImagePresent()) {
                this.field_230706_i_.field_71439_g.func_71053_j();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public boolean isImagePresent() {
        AxisAlignedBB aabb = this.field_230706_i_.field_71439_g.func_174813_aQ();
        aabb = aabb.func_186662_g(32.0);
        return this.field_230706_i_.field_71441_e.func_217357_a(ImageEntity.class, aabb).stream().anyMatch(image -> image.func_110124_au().equals(this.uuid) && image.func_70032_d((Entity)this.field_230706_i_.field_71439_g) <= 32.0f);
    }
}

