/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.ImageScreen;
import de.maxhenkel.camera.items.render.ImageItemRenderer;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ImageItem
extends Item {
    public ImageItem() {
        super(new Item.Properties().func_200917_a(1).setISTER(() -> ImageItemRenderer::new));
        this.setRegistryName(new ResourceLocation("camera", "image"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.field_70170_p.field_72995_K) {
            this.openClientGui(stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ImageScreen(stack));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        long time;
        String name = this.getOwner(stack);
        if (!name.isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_owner", new Object[]{TextFormatting.DARK_GRAY + name}).func_240699_a_(TextFormatting.GRAY));
        }
        if ((time = this.getTime(stack)) > 0L) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_time", new Object[]{TextFormatting.DARK_GRAY + Main.CLIENT_CONFIG.imageDateFormat.format(new Date(time))}).func_240699_a_(TextFormatting.GRAY));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    private CompoundNBT getImageTag(ItemStack stack) {
        CompoundNBT compound;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (!(compound = stack.func_77978_p()).func_74764_b("image")) {
            compound.func_218657_a("image", (INBT)new CompoundNBT());
        }
        return compound.func_74775_l("image");
    }

    public void setUUID(ItemStack stack, UUID uuid) {
        CompoundNBT compound = this.getImageTag(stack);
        compound.func_74772_a("image_id_most", uuid.getMostSignificantBits());
        compound.func_74772_a("image_id_least", uuid.getLeastSignificantBits());
    }

    public UUID getUUID(ItemStack stack) {
        CompoundNBT compound = this.getImageTag(stack);
        if (!compound.func_74764_b("image_id_most") || !compound.func_74764_b("image_id_least")) {
            return null;
        }
        long most = compound.func_74763_f("image_id_most");
        long least = compound.func_74763_f("image_id_least");
        return new UUID(most, least);
    }

    public void setTime(ItemStack stack, long time) {
        CompoundNBT compound = this.getImageTag(stack);
        compound.func_74772_a("image_time", time);
    }

    public long getTime(ItemStack stack) {
        CompoundNBT compound = this.getImageTag(stack);
        if (!compound.func_74764_b("image_time")) {
            return 0L;
        }
        return compound.func_74763_f("image_time");
    }

    public void setOwner(ItemStack stack, String name) {
        CompoundNBT compound = this.getImageTag(stack);
        compound.func_74778_a("owner", name);
    }

    public String getOwner(ItemStack stack) {
        CompoundNBT compound = this.getImageTag(stack);
        if (!compound.func_74764_b("owner")) {
            return "";
        }
        return compound.func_74779_i("owner");
    }
}

