/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.corelib.net.Message;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageResizeFrame
implements Message<MessageResizeFrame> {
    private UUID uuid;
    private Direction direction;
    private boolean larger;

    public MessageResizeFrame() {
    }

    public MessageResizeFrame(UUID uuid, Direction direction, boolean larger) {
        this.uuid = uuid;
        this.direction = direction;
        this.larger = larger;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerWorld world;
        Entity entity;
        if (context.getSender().field_70170_p instanceof ServerWorld && context.getSender().field_71075_bZ.field_75099_e && (entity = (world = (ServerWorld)context.getSender().field_70170_p).func_217461_a(this.uuid)) instanceof ImageEntity) {
            ImageEntity image = (ImageEntity)entity;
            image.resize(this.direction, this.larger);
        }
    }

    @Override
    public MessageResizeFrame fromBytes(PacketBuffer buf) {
        this.uuid = buf.func_179253_g();
        this.direction = Direction.values()[buf.readInt()];
        this.larger = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.uuid);
        buf.writeInt(this.direction.ordinal());
        buf.writeBoolean(this.larger);
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

