/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = new ResourceLocation("camera", "textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = new ResourceLocation("camera", "textures/gui/zoom.png");
    public static final float MAX_FOV = 90.0f;
    public static final float MIN_FOV = 5.0f;
    private Minecraft mc = Minecraft.func_71410_x();
    private boolean inCameraMode = false;
    private float fov = 0.0f;
    private ResourceLocation currentShader;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
            return;
        }
        this.mc.field_71474_y.func_243229_a(PointOfView.FIRST_PERSON);
        this.drawViewFinder(event.getMatrixStack());
        this.drawZoom(event.getMatrixStack(), this.getFOVPercentage());
    }

    private void drawViewFinder(MatrixStack matrixStack) {
        float hnew;
        float wnew;
        this.mc.func_110434_K().func_110577_a(VIEWFINDER);
        float imageWidth = 192.0f;
        float imageHeight = 100.0f;
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float ws = this.mc.func_228018_at_().func_198107_o();
        float hs = this.mc.func_228018_at_().func_198087_p();
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        bufferBuilder.func_227888_a_(matrix, left, top, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, left, top + hnew, 0.0f).func_225583_a_(0.0f, 0.390625f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, left + wnew, top + hnew, 0.0f).func_225583_a_(0.75f, 0.390625f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, left + wnew, top, 0.0f).func_225583_a_(0.75f, 0.0f).func_181675_d();
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }

    private void drawZoom(MatrixStack matrixStack, float percent) {
        this.mc.func_110434_K().func_110577_a(ZOOM);
        int zoomWidth = 112;
        int zoomHeight = 20;
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int width = this.mc.func_228018_at_().func_198107_o();
        int height = this.mc.func_228018_at_().func_198087_p();
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        bufferBuilder.func_227888_a_(matrix, (float)left, (float)top, 0.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)left, (float)(top + zoomHeight / 2), 0.0f).func_225583_a_(0.0f, 0.078125f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(left + zoomWidth), (float)(top + zoomHeight / 2), 0.0f).func_225583_a_(0.875f, 0.078125f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(left + zoomWidth), (float)top, 0.0f).func_225583_a_(0.875f, 0.0f).func_181675_d();
        int percWidth = (int)(Math.max(Math.min((double)percent, 1.0), 0.0) * (double)zoomWidth);
        bufferBuilder.func_227888_a_(matrix, (float)left, (float)top, 0.0f).func_225583_a_(0.0f, 0.078125f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)left, (float)(top + zoomHeight / 2), 0.0f).func_225583_a_(0.0f, 0.15625f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(left + percWidth), (float)(top + zoomHeight / 2), 0.0f).func_225583_a_(0.875f * percent, 0.15625f).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, (float)(left + percWidth), (float)top, 0.0f).func_225583_a_(0.875f * percent, 0.078125f).func_181675_d();
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (this.inCameraMode && event.getGui() instanceof IngameMenuScreen) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDisableCameraMode());
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_77973_b().equals((Object)Main.CAMERA)) {
            return null;
        }
        return Shaders.getShader(Main.CAMERA.getShader(stack));
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            if (this.currentShader != null) {
                this.mc.field_71460_t.func_181022_b();
            }
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.field_71460_t.func_175069_a(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof CameraItem) || !Main.CAMERA.isActive(stack)) continue;
            player.func_184598_c(hand);
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        event.getPlayer().func_184602_cy();
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (event.getScrollDelta() == 0.0) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        this.fov = event.getScrollDelta() < 0.0 ? Math.min(this.fov + 5.0f, 90.0f) : Math.max(this.fov - 5.0f, 5.0f);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (!this.inCameraMode) {
            this.fov = (float)event.getFOV();
            return;
        }
        this.mc.field_71439_g.func_70107_b(this.mc.field_71439_g.func_226277_ct_(), this.mc.field_71439_g.func_226278_cu_() + 1.0E-9, this.mc.field_71439_g.func_226281_cx_());
        event.setFOV((double)this.fov);
    }

    public float getFOVPercentage() {
        return 1.0f - (this.fov - 5.0f) / 85.0f;
    }

    private ItemStack getActiveCamera() {
        if (this.mc.field_71439_g == null) {
            return null;
        }
        for (Hand hand : Hand.values()) {
            ItemStack stack = this.mc.field_71439_g.func_184586_b(hand);
            if (!stack.func_77973_b().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

