/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.sun.javafx.application.PlatformImpl;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.corelib.CommonUtils;
import de.maxhenkel.camera.corelib.client.RenderUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.stage.FileChooser;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.FolderName;

public class ImageTools {
    public static FolderName CAMERA_IMAGES = new FolderName("camera_images");
    private static final int MAX_IMAGE_SIZE = 1920;

    public static BufferedImage fromNativeImage(NativeImage nativeImage) {
        BufferedImage bufferedImage = new BufferedImage(nativeImage.func_195702_a(), nativeImage.func_195714_b(), 1);
        for (int x = 0; x < nativeImage.func_195702_a(); ++x) {
            for (int y = 0; y < nativeImage.func_195714_b(); ++y) {
                int rgba = nativeImage.func_195709_a(x, y);
                int alpha = RenderUtils.getAlpha(rgba);
                int red = RenderUtils.getRed(rgba);
                int green = RenderUtils.getGreen(rgba);
                int blue = RenderUtils.getBlue(rgba);
                bufferedImage.setRGB(x, y, RenderUtils.getArgb(alpha, blue, green, red));
            }
        }
        return bufferedImage;
    }

    public static NativeImage toNativeImage(BufferedImage bufferedImage) {
        NativeImage nativeImage = new NativeImage(bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int rgba = bufferedImage.getRGB(x, y);
                int alpha = RenderUtils.getAlpha(rgba);
                int red = RenderUtils.getRed(rgba);
                int green = RenderUtils.getGreen(rgba);
                int blue = RenderUtils.getBlue(rgba);
                nativeImage.func_195700_a(x, y, RenderUtils.getArgb(alpha, blue, green, red));
            }
        }
        return nativeImage;
    }

    public static byte[] toBytes(BufferedImage image) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", baos);
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    public static BufferedImage fromBytes(byte[] data) throws IOException {
        ImageIO.setUseCache(false);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(bais);
        bais.close();
        return image;
    }

    public static byte[] optimizeImage(BufferedImage image) throws IOException {
        byte[] data;
        float ratio = (float)image.getHeight() / (float)image.getWidth();
        int newWidth = image.getWidth();
        int newHeight = image.getHeight();
        if (image.getHeight() > 1920 || image.getWidth() > 1920) {
            if (ratio < 1.0f) {
                newHeight = (int)(1920.0f * ratio);
                newWidth = 1920;
            } else {
                newWidth = (int)(1920.0f * ratio);
                newHeight = 1920;
            }
        }
        image = ImageTools.resize(image, newWidth, newHeight);
        float factor = ((Double)Main.SERVER_CONFIG.imageCompression.get()).floatValue();
        while ((data = ImageTools.compressToBytes(image, factor)).length > (Integer)Main.SERVER_CONFIG.maxImageSize.get()) {
            Main.LOGGER.debug("Trying to compress image: {}% {} bytes (max {})", (Object)Math.round(factor * 100.0f), (Object)data.length, Main.SERVER_CONFIG.maxImageSize.get());
            if (!((factor -= 0.025f) <= 0.0f)) continue;
            throw new IOException("Image could not be compressed (too large)");
        }
        Main.LOGGER.debug("Image compressed to {}% ({} bytes)", (Object)Math.round(factor * 100.0f), (Object)data.length);
        return data;
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage bufferedImage = new BufferedImage(newW, newH, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage compress(BufferedImage img, float factor) throws IOException {
        return ImageTools.fromBytes(ImageTools.compressToBytes(img, factor));
    }

    public static byte[] compressToBytes(BufferedImage img, float factor) throws IOException {
        ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
        ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
        jpgWriteParam.setCompressionMode(2);
        jpgWriteParam.setCompressionQuality(factor);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(baos);
        jpgWriter.setOutput(stream);
        IIOImage outputImage = new IIOImage(img, null, null);
        jpgWriter.write(null, outputImage, jpgWriteParam);
        jpgWriter.dispose();
        baos.flush();
        byte[] data = baos.toByteArray();
        baos.close();
        return data;
    }

    @Deprecated
    public static File getImageFileLegacy(ServerPlayerEntity playerMP, UUID uuid) {
        File imageFolder = CommonUtils.getWorldFolder(playerMP.func_71121_q(), CAMERA_IMAGES);
        File image = new File(imageFolder, uuid.toString() + ".jpg");
        if (!image.exists()) {
            image = new File(imageFolder, uuid.toString() + ".png");
        }
        return image;
    }

    public static File getImageFile(ServerPlayerEntity playerMP, UUID uuid) {
        File imageFolder = CommonUtils.getWorldFolder(playerMP.func_71121_q(), CAMERA_IMAGES);
        return new File(imageFolder, uuid.toString() + ".jpg");
    }

    public static void saveImage(ServerPlayerEntity playerMP, UUID uuid, BufferedImage bufferedImage) throws IOException {
        File image = ImageTools.getImageFile(playerMP, uuid);
        image.mkdirs();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", image);
    }

    public static BufferedImage loadImage(ServerPlayerEntity playerMP, UUID uuid) throws IOException {
        return ImageTools.loadImage(ImageTools.getImageFileLegacy(playerMP, uuid));
    }

    public static BufferedImage loadImage(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedImage bufferedImage = ImageIO.read(fis);
        if (bufferedImage == null) {
            throw new IOException("BufferedImage is null");
        }
        return bufferedImage;
    }

    public static void chooseImage(Consumer<File> onResult) {
        PlatformImpl.startup(() -> {
            File last;
            FileChooser chooser = new FileChooser();
            String lastPath = (String)Main.CLIENT_CONFIG.lastImagePath.get();
            if (!lastPath.isEmpty() && (last = new File(lastPath)).exists()) {
                chooser.setInitialDirectory(last);
            }
            chooser.setTitle(new TranslationTextComponent("title.choose_image").getString());
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(new TranslationTextComponent("filetype.images").getString(), new String[]{"*.png", "*.jpg", "*.jpeg"});
            chooser.getExtensionFilters().clear();
            chooser.getExtensionFilters().add((Object)filter);
            chooser.setSelectedExtensionFilter(filter);
            File file = chooser.showOpenDialog(null);
            if (file != null && file.exists() && !file.isDirectory()) {
                Main.CLIENT_CONFIG.lastImagePath.set((Object)file.getParent());
                Main.CLIENT_CONFIG.lastImagePath.save();
                onResult.accept(file);
            }
        });
    }
}

