/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.gui.ResizeFrameScreen;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ImageEntity
extends Entity {
    private static final DataParameter<Optional<UUID>> ID = EntityDataManager.func_187226_a(ImageEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Direction> FACING = EntityDataManager.func_187226_a(ImageEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Integer> WIDTH = EntityDataManager.func_187226_a(ImageEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HEIGHT = EntityDataManager.func_187226_a(ImageEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(ImageEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(ImageEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final AxisAlignedBB NULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double THICKNESS = 0.0625;
    private static final int MAX_WIDTH = 8;
    private static final int MAX_HEIGHT = 8;
    private AxisAlignedBB boundingBox = NULL_AABB;

    public ImageEntity(EntityType type, World world) {
        super(type, world);
    }

    public ImageEntity(World world) {
        this(Main.IMAGE_ENTITY_TYPE, world);
    }

    public ImageEntity(World world, double x, double y, double z) {
        this(Main.IMAGE_ENTITY_TYPE, world);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public void func_70071_h_() {
        this.updateBoundingBox();
        super.func_70071_h_();
        this.checkValid();
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.canModify(player)) {
            return ActionResultType.FAIL;
        }
        if (player.func_225608_bj_()) {
            if (this.field_70170_p.field_72995_K) {
                this.openClientGui();
            }
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasImage()) {
            if (stack.func_190926_b()) {
                ItemStack containedItem = this.removeImage();
                if (!this.field_70170_p.field_72995_K) {
                    player.func_184611_a(hand, containedItem);
                    this.playRemoveSound();
                }
            } else {
                ItemStack image = this.removeImage();
                if (!this.field_70170_p.field_72995_K) {
                    this.playRemoveSound();
                    if (!player.func_191521_c(image)) {
                        this.dropItem(image);
                    }
                }
            }
        }
        if (stack.func_77973_b().equals((Object)Main.IMAGE)) {
            UUID uuid = Main.IMAGE.getUUID(stack);
            if (uuid == null) {
                return ActionResultType.SUCCESS;
            }
            ItemStack frameStack = stack.func_77979_a(1);
            this.setItem(frameStack);
            this.setImageUUID(uuid);
            player.func_184611_a(hand, stack);
            this.playAddSound();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean canModify(PlayerEntity player) {
        if (!player.field_71075_bZ.field_75099_e) {
            return false;
        }
        if (!((Boolean)Main.SERVER_CONFIG.frameOnlyOwnerModify.get()).booleanValue()) {
            return true;
        }
        if (player.func_184812_l_() && player.func_211513_k(1)) {
            return true;
        }
        if (!this.getOwner().isPresent()) {
            return true;
        }
        return this.getOwner().get().equals(player.func_110124_au());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui() {
        Minecraft.func_71410_x().func_147108_a((Screen)new ResizeFrameScreen(this.func_110124_au()));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (!(source.func_76364_f() instanceof PlayerEntity)) {
            return false;
        }
        if (!this.canModify((PlayerEntity)source.func_76364_f())) {
            return false;
        }
        if (this.hasImage()) {
            ItemStack image = this.removeImage();
            if (!this.field_70170_p.field_72995_K) {
                this.playRemoveSound();
                this.dropItem(image);
            }
            return true;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.removeFrame(source.func_76346_g());
        return true;
    }

    public boolean isValid() {
        return this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ()) && this.field_70170_p.func_175647_a(ImageEntity.class, this.func_174813_aQ().func_191195_a(this.getFacing().func_82601_c() == 0 ? 0.125 : 0.0, this.getFacing().func_96559_d() == 0 ? 0.125 : 0.0, this.getFacing().func_82599_e() == 0 ? 0.125 : 0.0), image -> image != this).isEmpty();
    }

    public void checkValid() {
        if (!this.isValid()) {
            this.removeFrame();
        }
    }

    public void onBroken(Entity entity) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.dropItem(new ItemStack((IItemProvider)Main.FRAME_ITEM));
        if (this.hasImage()) {
            this.dropItem(this.removeImage());
        }
    }

    public void resize(MessageResizeFrame.Direction direction, boolean larger) {
        int amount = larger ? 1 : -1;
        switch (direction) {
            case UP: {
                this.setFrameHeight(this.getFrameHeight() + amount);
                break;
            }
            case DOWN: {
                if (!this.setFrameHeight(this.getFrameHeight() + amount)) break;
                this.setImagePosition(this.func_233580_cy_().func_177967_a(Direction.DOWN, amount));
                break;
            }
            case RIGHT: {
                this.setFrameWidth(this.getFrameWidth() + amount);
                break;
            }
            case LEFT: {
                if (!this.setFrameWidth(this.getFrameWidth() + amount)) break;
                this.setImagePosition(this.func_233580_cy_().func_177967_a(this.getResizeOffset(), amount));
            }
        }
    }

    private Direction getResizeOffset() {
        switch (this.getFacing()) {
            default: {
                return Direction.SOUTH;
            }
            case WEST: {
                return Direction.NORTH;
            }
            case NORTH: {
                return Direction.EAST;
            }
            case SOUTH: 
        }
        return Direction.WEST;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        if (this.hasImage()) {
            return this.getItem().func_77946_l();
        }
        return new ItemStack((IItemProvider)Main.FRAME_ITEM);
    }

    private void updateBoundingBox() {
        BlockPos pos = this.func_233580_cy_();
        Direction facing = this.getFacing();
        int width = this.getFrameWidth();
        int height = this.getFrameHeight();
        if (facing.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = (float)facing.func_176736_b() * 90.0f;
        } else {
            this.field_70125_A = -90.0f * (float)facing.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.boundingBox = this.calculateBoundingBox(pos, facing, width, height);
    }

    private AxisAlignedBB calculateBoundingBox(BlockPos pos, Direction facing, double width, double height) {
        switch (facing) {
            default: {
                return new AxisAlignedBB((double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 1.0 - 0.0625, (double)pos.func_177958_n() - width + 1.0, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + width, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + 0.0625);
            }
            case WEST: {
                return new AxisAlignedBB((double)pos.func_177958_n() + 1.0 - 0.0625, (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + width);
            }
            case EAST: 
        }
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + 1.0, (double)pos.func_177958_n() + 0.0625, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() - width + 1.0);
    }

    public BlockPos getCenterPosition() {
        Vector3d center = this.getCenter(this.func_174813_aQ());
        return new BlockPos(center.field_72450_a, center.field_72448_b, center.field_72449_c);
    }

    public Vector3d getCenter(AxisAlignedBB aabb) {
        return new Vector3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
    }

    @Nullable
    public ItemEntity dropItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        BlockPos center = this.getCenterPosition();
        ItemEntity entityitem = new ItemEntity(this.field_70170_p, (double)center.func_177958_n() + 0.5, (double)center.func_177956_o() + 0.5, (double)center.func_177952_p() + 0.5, stack);
        entityitem.func_174869_p();
        this.field_70170_p.func_217376_c((Entity)entityitem);
        return entityitem;
    }

    public void removeFrame(Entity source) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.onBroken(source);
            this.func_70106_y();
        }
    }

    public void removeFrame() {
        this.removeFrame(null);
    }

    protected boolean func_142008_O() {
        return false;
    }

    public AxisAlignedBB func_174813_aQ() {
        return this.boundingBox;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void playPlaceSound() {
        this.field_70170_p.func_184133_a(null, this.getCenterPosition(), SoundEvents.field_187694_dK, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void playAddSound() {
        this.field_70170_p.func_184133_a(null, this.getCenterPosition(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void playRemoveSound() {
        this.field_70170_p.func_184133_a(null, this.getCenterPosition(), SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setOwner(UUID owner) {
        this.field_70180_af.func_187227_b(OWNER, Optional.ofNullable(owner));
    }

    public Optional<UUID> getImageUUID() {
        return (Optional)this.field_70180_af.func_187225_a(ID);
    }

    public void setImageUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(ID, Optional.ofNullable(uuid));
    }

    public int getFrameWidth() {
        return (Integer)this.field_70180_af.func_187225_a(WIDTH);
    }

    public int getFrameHeight() {
        return (Integer)this.field_70180_af.func_187225_a(HEIGHT);
    }

    public boolean setFrameWidth(int width) {
        if (width <= 0) {
            width = 1;
        } else if (width > 8) {
            width = 8;
        }
        int oldWidth = this.getFrameWidth();
        this.field_70180_af.func_187227_b(WIDTH, (Object)width);
        return oldWidth != width;
    }

    public boolean setFrameHeight(int height) {
        if (height <= 0) {
            height = 1;
        } else if (height > 8) {
            height = 8;
        }
        int oldHeight = this.getFrameHeight();
        this.field_70180_af.func_187227_b(HEIGHT, (Object)height);
        return oldHeight != height;
    }

    public ItemStack getItem() {
        return (ItemStack)this.field_70180_af.func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.field_70180_af.func_187227_b(ITEM, (Object)stack);
    }

    public void setImagePosition(BlockPos position) {
        this.func_70012_b((double)position.func_177958_n() + 0.5, position.func_177956_o(), (double)position.func_177952_p() + 0.5, this.field_70177_z, this.field_70125_A);
        this.updateBoundingBox();
    }

    public void setFacing(Direction facing) {
        this.field_70180_af.func_187227_b(FACING, (Object)facing);
        this.updateBoundingBox();
    }

    public Direction getFacing() {
        return (Direction)this.field_70180_af.func_187225_a(FACING);
    }

    private boolean hasImage() {
        return !this.getItem().func_190926_b();
    }

    private ItemStack removeImage() {
        ItemStack item = this.getItem();
        this.setItem(ItemStack.field_190927_a);
        this.setImageUUID(null);
        return item;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ID, Optional.empty());
        this.field_70180_af.func_187214_a(FACING, (Object)Direction.NORTH);
        this.field_70180_af.func_187214_a(WIDTH, (Object)1);
        this.field_70180_af.func_187214_a(HEIGHT, (Object)1);
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(OWNER, Optional.empty());
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.getImageUUID().isPresent()) {
            UUID uuid = this.getImageUUID().get();
            compound.func_74772_a("id_most", uuid.getMostSignificantBits());
            compound.func_74772_a("id_least", uuid.getLeastSignificantBits());
        }
        compound.func_74768_a("facing", this.getFacing().func_176745_a());
        compound.func_74768_a("width", this.getFrameWidth());
        compound.func_74768_a("height", this.getFrameHeight());
        compound.func_218657_a("item", (INBT)this.getItem().func_77955_b(new CompoundNBT()));
        if (this.getOwner().isPresent()) {
            compound.func_186854_a("owner", this.getOwner().get());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("id_most") && compound.func_74764_b("id_least")) {
            this.setImageUUID(new UUID(compound.func_74763_f("id_most"), compound.func_74763_f("id_least")));
        }
        this.setFacing(Direction.func_82600_a((int)compound.func_74762_e("facing")));
        this.setFrameWidth(compound.func_74762_e("width"));
        this.setFrameHeight(compound.func_74762_e("height"));
        this.setItem(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item")));
        if (compound.func_74764_b("owner")) {
            this.setOwner(compound.func_186857_a("owner"));
        }
        this.updateBoundingBox();
    }
}

