/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.corelib.inventory.ScreenBase;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageSetShader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class CameraScreen
extends ScreenBase<Container> {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/camera.png");
    private static final int FONT_COLOR = 0x404040;
    private static final int PADDING = 10;
    private static final int BUTTON_WIDTH = 70;
    private static final int BUTTON_HEIGHT = 20;
    private int index = 0;

    public CameraScreen(String currentShader) {
        super(CAMERA_TEXTURE, new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.camera.title"));
        this.field_146999_f = 248;
        this.field_147000_g = 109;
        for (int i = 0; i < Shaders.SHADER_LIST.size(); ++i) {
            String s = Shaders.SHADER_LIST.get(i);
            if (currentShader == null) {
                if (!s.equals("none")) continue;
                this.index = i;
                break;
            }
            if (!s.equals(currentShader)) continue;
            this.index = i;
            break;
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        Button prev = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + 10, this.field_147009_r + this.field_147000_g / 2 - 10, 70, 20, (ITextComponent)new TranslationTextComponent("button.camera.prev"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = Shaders.SHADER_LIST.size() - 1;
            }
            this.sendShader();
        }));
        prev.field_230693_o_ = false;
        Button next = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - 70 - 10, this.field_147009_r + this.field_147000_g / 2 - 10, 70, 20, (ITextComponent)new TranslationTextComponent("button.camera.next"), button -> {
            ++this.index;
            if (this.index >= Shaders.SHADER_LIST.size()) {
                this.index = 0;
            }
            this.sendShader();
        }));
        next.field_230693_o_ = false;
        if (((Boolean)Main.SERVER_CONFIG.allowImageUpload.get()).booleanValue()) {
            this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f / 2 - 35, this.field_230709_l_ / 2 + this.field_147000_g / 2 - 20 - 10, 70, 20, (ITextComponent)new TranslationTextComponent("button.camera.upload"), button -> ImageTools.chooseImage(file -> {
                try {
                    UUID uuid = UUID.randomUUID();
                    BufferedImage image = ImageTools.loadImage(file);
                    ClientImageUploadManager.addImage(uuid, image);
                    Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRequestUploadCustomImage(uuid));
                }
                catch (IOException e) {
                    this.field_213127_e.field_70458_d.func_145747_a((ITextComponent)new TranslationTextComponent("message.upload_error", new Object[]{e.getMessage()}), this.field_213127_e.field_70458_d.func_110124_au());
                    e.printStackTrace();
                }
                this.field_230706_i_.field_71462_r = null;
            })));
        }
    }

    private void sendShader() {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSetShader(Shaders.SHADER_LIST.get(this.index)));
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        String title = new TranslationTextComponent("gui.camera.choosefilter").getString();
        int titleWidth = this.field_230712_o_.func_78256_a(title);
        this.field_230712_o_.func_238421_b_(matrixStack, title, (float)(this.field_146999_f / 2 - titleWidth / 2), 10.0f, 0x404040);
        String shaderName = new TranslationTextComponent("shader." + Shaders.SHADER_LIST.get(this.index)).getString();
        int shaderWidth = this.field_230712_o_.func_78256_a(shaderName);
        float f = this.field_146999_f / 2 - shaderWidth / 2;
        int n = this.field_147000_g / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238421_b_(matrixStack, shaderName, f, (float)(n - 9 / 2), TextFormatting.WHITE.func_211163_e().intValue());
        if (this.isHoveringButton(mouseX, mouseY)) {
            ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
            list.add(new TranslationTextComponent("message.camera.filters_unavailable").func_241878_f());
            this.func_238654_b_(matrixStack, list, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private boolean isHoveringButton(int mouseX, int mouseY) {
        if (mouseX >= this.field_147003_i + 10 && mouseX < this.field_147003_i + 10 + 70 && mouseY >= this.field_147009_r + this.field_147000_g / 2 - 10 && mouseY < this.field_147009_r + this.field_147000_g / 2 - 10 + 20) {
            return true;
        }
        return mouseX >= this.field_147003_i + this.field_146999_f - 70 - 10 && mouseX < this.field_147003_i + this.field_146999_f - 10 && mouseY >= this.field_147009_r + this.field_147000_g / 2 - 10 && mouseY < this.field_147009_r + this.field_147000_g / 2 + 10;
    }
}

