/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.corelib.net.Message;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageImage
implements Message<MessageImage> {
    private UUID uuid;
    private byte[] image;

    public MessageImage() {
    }

    public MessageImage(UUID uuid, byte[] image) throws IOException {
        this.uuid = uuid;
        this.image = image;
        if (image.length > 1000000) {
            throw new IOException("Image too large: " + image.length + " bytes (max 1.000.000)");
        }
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
        try {
            BufferedImage img = ImageTools.fromBytes(this.image);
            Minecraft.func_71410_x().func_213165_a(() -> TextureCache.instance().addImage(this.uuid, img));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MessageImage fromBytes(PacketBuffer buf) {
        this.uuid = buf.func_179253_g();
        this.image = buf.func_179251_a();
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.uuid);
        buf.func_179250_a(this.image);
    }
}

