/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class BulletTrail {
    private int entityId;
    private Vec3d position;
    private Vec3d motion;
    private float yaw;
    private float pitch;
    private boolean dead;
    private ItemStack item;
    private int trailColor;
    private double trailLengthMultiplier;
    private int age;
    private int maxAge;
    private double gravity;
    private int shooterId;

    public BulletTrail(int entityId, Vec3d position, Vec3d motion, ItemStack item, int trailColor, double trailMultiplier, int maxAge, double gravity, int shooterId) {
        this.entityId = entityId;
        this.position = position;
        this.motion = motion;
        this.item = item;
        this.trailColor = trailColor;
        this.trailLengthMultiplier = trailMultiplier;
        this.maxAge = maxAge;
        this.gravity = gravity;
        this.shooterId = shooterId;
        this.updateYawPitch();
    }

    private void updateYawPitch() {
        float horizontalLength = MathHelper.func_76133_a((double)(this.motion.field_72450_a * this.motion.field_72450_a + this.motion.field_72449_c * this.motion.field_72449_c));
        this.yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)this.motion.field_72450_a, (double)this.motion.field_72449_c));
        this.pitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)this.motion.field_72448_b, (double)horizontalLength));
    }

    public void tick() {
        Entity entity;
        double distance;
        ++this.age;
        this.position = this.position.func_178787_e(this.motion);
        if (this.gravity != 0.0) {
            this.motion = this.motion.func_72441_c(0.0, this.gravity, 0.0);
            this.updateYawPitch();
        }
        double d = distance = (entity = Minecraft.func_71410_x().func_175606_aa()) != null ? Math.sqrt(entity.func_195048_a(this.position)) : Double.MAX_VALUE;
        if (this.age >= this.maxAge || distance > 256.0) {
            this.dead = true;
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public Vec3d getMotion() {
        return this.motion;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getAge() {
        return this.age;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public boolean isTrailVisible() {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        return entity != null && entity.func_145782_y() != this.shooterId;
    }

    public int hashCode() {
        return this.entityId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BulletTrail) {
            return ((BulletTrail)obj).entityId == this.entityId;
        }
        return false;
    }
}

