/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.client.handler.ControllerHandler;
import com.mrcrayfish.guns.client.handler.CrosshairHandler;
import com.mrcrayfish.guns.client.render.crosshair.Crosshair;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageAim;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class AimingHandler {
    private static AimingHandler instance;
    private static final double MAX_AIM_PROGRESS = 4.0;
    private final AimTracker localTracker = new AimTracker();
    private final Map<PlayerEntity, AimTracker> aimingMap = new WeakHashMap<PlayerEntity, AimTracker>();
    private double normalisedAdsProgress;
    private boolean aiming = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    private AimingHandler() {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        PlayerEntity player = event.player;
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            tracker.handleAiming(player, player.func_184586_b(Hand.MAIN_HAND));
            if (!tracker.isAiming()) {
                this.aimingMap.remove(player);
            }
        }
    }

    @Nullable
    private AimTracker getAimTracker(PlayerEntity player) {
        if (((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.AIMING)).booleanValue() && !this.aimingMap.containsKey(player)) {
            this.aimingMap.put(player, new AimTracker());
        }
        return this.aimingMap.get(player);
    }

    public float getAimProgress(PlayerEntity player, float partialTicks) {
        if (player.func_175144_cb()) {
            return (float)this.localTracker.getNormalProgress(partialTicks);
        }
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            return (float)tracker.getNormalProgress(partialTicks);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.isAiming()) {
            if (!this.aiming) {
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.AIMING, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(true));
                this.aiming = true;
            }
        } else if (this.aiming) {
            SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.AIMING, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(false));
            this.aiming = false;
        }
        this.localTracker.handleAiming((PlayerEntity)player, player.func_184586_b(Hand.MAIN_HAND));
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && !mc.field_71439_g.func_184614_ca().func_190926_b() && mc.field_71474_y.field_74320_O == 0 && (heldItem = mc.field_71439_g.func_184614_ca()).func_77973_b() instanceof GunItem) {
            Gun modifiedGun;
            GunItem gunItem = (GunItem)heldItem.func_77973_b();
            if (AimingHandler.get().isAiming() && !((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue() && (modifiedGun = gunItem.getModifiedGun(heldItem)).getModules().getZoom() != null) {
                float newFov = modifiedGun.getModules().getZoom().getFovModifier();
                Scope scope = Gun.getScope(heldItem);
                if (scope != null) {
                    newFov -= scope.getAdditionalZoom();
                }
                event.setNewfov(newFov + (1.0f - newFov) * (1.0f - (float)this.normalisedAdsProgress));
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.aimingMap.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTicks());
        Crosshair crosshair = CrosshairHandler.get().getCurrentCrosshair();
        if (this.normalisedAdsProgress > 0.0 && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (crosshair == null || crosshair.isDefault())) {
            event.setCanceled(true);
        }
    }

    public boolean isAiming() {
        boolean zooming;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return false;
        }
        if (mc.field_71439_g.func_175149_v()) {
            return false;
        }
        if (mc.field_71462_r != null) {
            return false;
        }
        ItemStack heldItem = mc.field_71439_g.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return false;
        }
        Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
        if (gun.getModules().getZoom() == null) {
            return false;
        }
        if (!this.localTracker.isAiming() && this.isLookingAtInteractableBlock()) {
            return false;
        }
        if (((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue()) {
            return false;
        }
        boolean bl = zooming = GLFW.glfwGetMouseButton((long)mc.func_228018_at_().func_198092_i(), (int)1) == 1;
        if (GunMod.controllableLoaded) {
            zooming |= ControllerHandler.isAiming();
        }
        return zooming;
    }

    public boolean isLookingAtInteractableBlock() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71476_x != null && mc.field_71441_e != null) {
            if (mc.field_71476_x instanceof BlockRayTraceResult) {
                BlockRayTraceResult result = (BlockRayTraceResult)mc.field_71476_x;
                BlockState state = mc.field_71441_e.func_180495_p(result.func_216350_a());
                Block block = state.func_177230_c();
                return block instanceof ContainerBlock || block.hasTileEntity(state) || block == Blocks.field_150462_ai || block == ModBlocks.WORKBENCH.get() || BlockTags.field_200029_f.func_199685_a_((Object)block) || BlockTags.field_212185_E.func_199685_a_((Object)block) || Tags.Blocks.CHESTS.func_199685_a_((Object)block) || Tags.Blocks.FENCE_GATES.func_199685_a_((Object)block);
            }
            if (mc.field_71476_x instanceof EntityRayTraceResult) {
                EntityRayTraceResult result = (EntityRayTraceResult)mc.field_71476_x;
                return result.func_216348_a() instanceof ItemFrameEntity;
            }
        }
        return false;
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public class AimTracker {
        private double currentAim;
        private double previousAim;

        private void handleAiming(PlayerEntity player, ItemStack heldItem) {
            this.previousAim = this.currentAim;
            if (((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.AIMING)).booleanValue() || player.func_175144_cb() && AimingHandler.this.isAiming()) {
                if (this.currentAim < 4.0) {
                    double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                    speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                    this.currentAim += speed;
                    if (this.currentAim > 4.0) {
                        this.currentAim = 4.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                this.currentAim -= speed;
                if (this.currentAim < 0.0) {
                    this.currentAim = 0.0;
                }
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        public double getNormalProgress(float partialTicks) {
            return (this.previousAim + (this.currentAim - this.previousAim) * (double)(this.previousAim == 0.0 || this.previousAim == 4.0 ? 0.0f : partialTicks)) / 4.0;
        }
    }
}

