/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.audio.StunRingingSound;
import com.mrcrayfish.guns.init.ModEffects;
import java.lang.reflect.Field;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ChannelManager;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SoundHandler {
    private static SoundHandler instance;
    private final Map<ISound, Float> soundVolumes = new ConcurrentHashMap<ISound, Float>();
    private boolean isDeafened;
    private Field playingSounds;
    private SoundEngine soundEngine;
    private StunRingingSound ringing;

    public static SoundHandler get() {
        if (instance == null) {
            instance = new SoundHandler();
        }
        return instance;
    }

    private SoundHandler() {
        this.initReflection();
    }

    private void initReflection() {
        this.playingSounds = ObfuscationReflectionHelper.findField(SoundEngine.class, (String)"field_217942_m");
    }

    @SubscribeEvent
    public void deafenPlayer(TickEvent.ClientTickEvent event) {
        Map playingSounds;
        if (event.phase == TickEvent.Phase.START || Minecraft.func_71410_x().field_71439_g == null || this.soundEngine == null) {
            return;
        }
        EffectInstance effect = Minecraft.func_71410_x().field_71439_g.func_70660_b((Effect)ModEffects.DEAFENED.get());
        if (effect == null && !this.isDeafened) {
            return;
        }
        if ((Double)Config.SERVER.ringVolume.get() > 0.0 && (this.ringing == null || !Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)this.ringing))) {
            this.ringing = new StunRingingSound();
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.ringing);
            return;
        }
        try {
            playingSounds = (Map)this.playingSounds.get(this.soundEngine);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return;
        }
        if (effect != null) {
            try {
                playingSounds.forEach((sound, entry) -> {
                    if (sound == null || sound instanceof ITickableSound || this.isStunGrenade(sound.func_184364_b().func_188719_a())) {
                        return;
                    }
                    float volume = sound instanceof SoundMuted ? ((SoundMuted)sound).getVolumeInitial() : sound.func_147653_e();
                    this.soundVolumes.put((ISound)sound, Float.valueOf(volume));
                    entry.func_217888_a(soundSource -> soundSource.func_216430_b(this.getMutedVolume(effect.func_76459_b(), volume)));
                });
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.isDeafened = true;
        } else if (this.isDeafened) {
            this.isDeafened = false;
            for (Map.Entry<ISound, Float> entry2 : this.soundVolumes.entrySet()) {
                ChannelManager.Entry entry1 = (ChannelManager.Entry)playingSounds.get(entry2.getKey());
                if (entry1 == null) continue;
                entry1.func_217888_a(soundSource -> soundSource.func_216430_b(((Float)entry2.getValue()).floatValue()));
            }
            this.soundVolumes.clear();
        }
    }

    @SubscribeEvent
    public void lowerInitialVolume(PlaySoundEvent event) {
        if (this.soundEngine == null) {
            this.soundEngine = event.getManager();
        }
        if (!this.isDeafened || Minecraft.func_71410_x().field_71439_g == null || event.getSound() instanceof ITickableSound) {
            return;
        }
        ResourceLocation loc = event.getSound().func_147650_b();
        EffectInstance effect = Minecraft.func_71410_x().field_71439_g.func_70660_b((Effect)ModEffects.DEAFENED.get());
        int duration = effect != null ? effect.func_76459_b() : 0;
        boolean isStunGrenade = this.isStunGrenade(loc);
        if (duration == 0 && isStunGrenade) {
            return;
        }
        event.getSound().func_184366_a(Minecraft.func_71410_x().func_147118_V());
        event.setResultSound((ISound)new SoundMuted(event.getSound(), duration, isStunGrenade));
    }

    private boolean isStunGrenade(ResourceLocation loc) {
        return loc.toString().equals("cgm:grenade_stun_explosion");
    }

    private float getMutedVolume(float duration, float volumeBase) {
        float volumeMin = (float)((double)volumeBase * (Double)Config.SERVER.soundPercentage.get());
        float percent = Math.min(duration / (float)((Integer)Config.SERVER.soundFadeThreshold.get()).intValue(), 1.0f);
        return volumeMin + (1.0f - percent) * (volumeBase - volumeMin);
    }

    public static class SoundMuted
    implements ISound {
        private ISound parent;
        private float volume;
        private float volumeInitial;

        public SoundMuted(ISound parent, int duration, boolean isStunGrenade) {
            this.parent = parent;
            this.volumeInitial = MathHelper.func_76131_a((float)parent.func_147653_e(), (float)0.0f, (float)1.0f);
            this.volume = SoundHandler.get().getMutedVolume(duration, this.volumeInitial);
            if (isStunGrenade) {
                this.volumeInitial = this.volume;
            }
        }

        public float func_147653_e() {
            return this.volume;
        }

        public float getVolumeInitial() {
            return this.volumeInitial;
        }

        public ResourceLocation func_147650_b() {
            return this.parent.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(net.minecraft.client.audio.SoundHandler handler) {
            return this.parent.func_184366_a(handler);
        }

        public Sound func_184364_b() {
            return this.parent.func_184364_b();
        }

        public SoundCategory func_184365_d() {
            return this.parent.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.parent.func_147657_c();
        }

        public boolean func_217861_m() {
            return false;
        }

        public int func_147652_d() {
            return this.parent.func_147652_d();
        }

        public float func_147655_f() {
            return this.parent.func_147655_f();
        }

        public float func_147649_g() {
            return this.parent.func_147649_g();
        }

        public float func_147654_h() {
            return this.parent.func_147654_h();
        }

        public float func_147651_i() {
            return this.parent.func_147651_i();
        }

        public ISound.AttenuationType func_147656_j() {
            return this.parent.func_147656_j();
        }
    }
}

