/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.render.pose;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.handler.ReloadHandler;
import com.mrcrayfish.guns.client.render.pose.AimPose;
import com.mrcrayfish.guns.client.render.pose.LimbPose;
import com.mrcrayfish.guns.client.render.pose.WeaponPose;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.common.GripType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TwoHandedPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose upPose = new AimPose();
        upPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(60.0f, 0.0f, 10.0f)).setRightArm(new LimbPose().setRotationAngleX(-120.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-160.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-30.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        upPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(40.0f, 0.0f, 30.0f)).setItemTranslate(new Vector3f(-1.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-140.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-170.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-35.0f).setRotationPointY(1.0f).setRotationPointZ(0.0f));
        return upPose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose forwardPose = new AimPose();
        forwardPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(30.0f, -11.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-60.0f).setRotationAngleY(-55.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f).setRotationPointZ(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-65.0f).setRotationAngleY(-10.0f).setRotationAngleZ(5.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        forwardPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(5.0f, -21.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-85.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(-15.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f).setRotationPointZ(0.0f));
        return forwardPose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose downPose = new AimPose();
        downPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-15.0f, -5.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 0.5f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-5.0f).setRotationAngleY(-20.0f).setRotationAngleZ(20.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        downPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-20.0f, -5.0f, -10.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-10.0f).setRotationAngleY(-20.0f).setRotationAngleZ(30.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        return downPose;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(PlayerEntity player, PlayerModel model, Hand hand, float aimProgress) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            boolean right = mc.field_71474_y.field_186715_A == HandSide.RIGHT ? hand == Hand.MAIN_HAND : hand == Hand.OFF_HAND;
            ModelRenderer mainArm = right ? model.field_178723_h : model.field_178724_i;
            ModelRenderer secondaryArm = right ? model.field_178724_i : model.field_178723_h;
            mainArm.field_78795_f = model.field_78116_c.field_78795_f;
            mainArm.field_78796_g = model.field_78116_c.field_78796_g;
            mainArm.field_78808_h = model.field_78116_c.field_78808_h;
            secondaryArm.field_78795_f = model.field_78116_c.field_78795_f;
            secondaryArm.field_78796_g = model.field_78116_c.field_78796_g;
            secondaryArm.field_78808_h = model.field_78116_c.field_78808_h;
            mainArm.field_78795_f = (float)Math.toRadians(-55.0f + aimProgress * -30.0f);
            mainArm.field_78796_g = (float)Math.toRadians((-45.0f + aimProgress * -20.0f) * (right ? 1.0f : -1.0f));
            secondaryArm.field_78795_f = (float)Math.toRadians(-42.0f + aimProgress * -48.0f);
            secondaryArm.field_78796_g = (float)Math.toRadians((-15.0f + aimProgress * 5.0f) * (right ? 1.0f : -1.0f));
        } else {
            super.applyPlayerModelRotation(player, model, hand, aimProgress);
            float angle = this.getPlayerPitch(player);
            model.field_78116_c.field_78795_f = (float)Math.toRadians((double)angle > 0.0 ? (double)(angle * 70.0f) : (double)(angle * 90.0f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerPreRender(PlayerEntity player, Hand hand, float aimProgress, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? hand == Hand.MAIN_HAND : hand == Hand.OFF_HAND;
            player.field_70760_ar = player.field_70126_B + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
            player.field_70761_aq = player.field_70177_z + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
        } else {
            super.applyPlayerPreRender(player, hand, aimProgress, matrixStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(PlayerEntity player, Hand hand, float aimProgress, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            if (hand == Hand.MAIN_HAND) {
                boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? hand == Hand.MAIN_HAND : hand == Hand.OFF_HAND;
                matrixStack.func_227861_a_(0.0, 0.0, 0.05);
                float invertRealProgress = 1.0f - aimProgress;
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(25.0f * invertRealProgress * (right ? 1.0f : -1.0f)));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((30.0f * invertRealProgress + aimProgress * -20.0f) * (right ? 1.0f : -1.0f)));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(25.0f * invertRealProgress + aimProgress * 5.0f));
            }
        } else {
            super.applyHeldItemTransforms(player, hand, aimProgress, matrixStack, buffer);
        }
    }

    @Override
    public void renderFirstPersonArms(ClientPlayerEntity player, HandSide hand, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, float partialTicks) {
        matrixStack.func_227861_a_(0.0, 0.0, -1.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227860_a_();
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks);
        matrixStack.func_227861_a_((double)reloadProgress * 0.5, (double)(-reloadProgress), (double)(-reloadProgress) * 0.5);
        int side = hand.func_188468_a() == HandSide.RIGHT ? 1 : -1;
        matrixStack.func_227861_a_((double)(6 * side) * 0.0625, -0.585, -0.5);
        if (Minecraft.func_71410_x().field_71439_g.func_175154_l().equals("slim") && hand.func_188468_a() == HandSide.LEFT) {
            matrixStack.func_227861_a_((double)(0.03125f * (float)(-side)), 0.0, 0.0);
        }
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(80.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(15.0f * (float)(-side)));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(15.0f * (float)(-side)));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-35.0f));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderFirstPersonArm(player, hand.func_188468_a(), matrixStack, buffer, light);
        matrixStack.func_227865_b_();
        double centerOffset = 2.5;
        if (Minecraft.func_71410_x().field_71439_g.func_175154_l().equals("slim")) {
            centerOffset += hand == HandSide.RIGHT ? 0.2 : 0.8;
        }
        centerOffset = hand == HandSide.RIGHT ? -centerOffset : centerOffset;
        matrixStack.func_227861_a_(centerOffset * 0.0625, -0.4, -0.975);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(80.0f));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderFirstPersonArm(player, hand, matrixStack, buffer, light);
    }

    @Override
    public boolean applyOffhandTransforms(PlayerEntity player, PlayerModel model, ItemStack stack, MatrixStack matrixStack, float partialTicks) {
        return GripType.applyBackTransforms(player, matrixStack);
    }
}

