/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.render.pose;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.guns.client.render.IHeldAnimation;
import com.mrcrayfish.guns.client.render.pose.AimPose;
import com.mrcrayfish.guns.client.render.pose.LimbPose;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class WeaponPose
implements IHeldAnimation {
    private AimPose upPose = this.getUpPose();
    private AimPose forwardPose = this.getForwardPose();
    private AimPose downPose = this.getDownPose();

    protected abstract AimPose getUpPose();

    protected abstract AimPose getForwardPose();

    protected abstract AimPose getDownPose();

    protected boolean hasAimPose() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(PlayerEntity player, PlayerModel model, Hand hand, float aimProgress) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean right = mc.field_71474_y.field_186715_A == HandSide.RIGHT ? hand == Hand.MAIN_HAND : hand == Hand.OFF_HAND;
        ModelRenderer mainArm = right ? model.field_178723_h : model.field_178724_i;
        ModelRenderer secondaryArm = right ? model.field_178724_i : model.field_178723_h;
        float angle = this.getPlayerPitch(player);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        this.applyAimPose(targetPose, mainArm, secondaryArm, angleAbs, zoom, right ? 1.0f : -1.0f, model.field_228270_o_);
    }

    protected float getPlayerPitch(PlayerEntity player) {
        if (Minecraft.func_71410_x().func_175606_aa() == player && Minecraft.func_71410_x().field_71462_r != null) {
            return 0.0f;
        }
        return MathHelper.func_219799_g((float)Minecraft.func_71410_x().func_184121_ak(), (float)player.field_70127_C, (float)player.field_70125_A) / 90.0f;
    }

    private void applyAimPose(AimPose targetPose, ModelRenderer rightArm, ModelRenderer leftArm, float partial, float zoom, float offhand, boolean sneaking) {
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getRightArm(), targetPose.getAiming().getRightArm(), this.forwardPose.getIdle().getRightArm(), this.forwardPose.getAiming().getRightArm(), rightArm, partial, zoom, offhand, sneaking);
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getLeftArm(), targetPose.getAiming().getLeftArm(), this.forwardPose.getIdle().getLeftArm(), this.forwardPose.getAiming().getLeftArm(), leftArm, partial, zoom, offhand, sneaking);
    }

    private void applyLimbPoseToModelRenderer(LimbPose targetIdlePose, LimbPose targetAimingPose, LimbPose idlePose, LimbPose aimingPose, ModelRenderer renderer, float partial, float zoom, float leftHanded, boolean sneaking) {
        renderer.field_78795_f = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleX(), targetAimingPose.getRotationAngleX(), idlePose.getRotationAngleX(), aimingPose.getRotationAngleX(), Float.valueOf(renderer.field_78795_f), partial, zoom, 1.0f));
        renderer.field_78796_g = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleY(), targetAimingPose.getRotationAngleY(), idlePose.getRotationAngleY(), aimingPose.getRotationAngleY(), Float.valueOf(renderer.field_78796_g), partial, zoom, leftHanded));
        renderer.field_78808_h = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleZ(), targetAimingPose.getRotationAngleZ(), idlePose.getRotationAngleZ(), aimingPose.getRotationAngleZ(), Float.valueOf(renderer.field_78808_h), partial, zoom, leftHanded));
        renderer.field_78800_c = this.getValue(targetIdlePose.getRotationPointX(), targetAimingPose.getRotationPointX(), idlePose.getRotationPointX(), aimingPose.getRotationPointX(), Float.valueOf(renderer.field_78800_c), partial, zoom, leftHanded);
        renderer.field_78797_d = this.getValue(targetIdlePose.getRotationPointY(), targetAimingPose.getRotationPointY(), idlePose.getRotationPointY(), aimingPose.getRotationPointY(), Float.valueOf(renderer.field_78797_d), partial, zoom, 1.0f) + (sneaking ? 2.0f : 0.0f);
        renderer.field_78798_e = this.getValue(targetIdlePose.getRotationPointZ(), targetAimingPose.getRotationPointZ(), idlePose.getRotationPointZ(), aimingPose.getRotationPointZ(), Float.valueOf(renderer.field_78798_e), partial, zoom, 1.0f);
    }

    private float getValue(@Nullable Float t1, @Nullable Float t2, Float s1, Float s2, Float def, float partial, float zoom, float leftHanded) {
        float start;
        float f = t1 != null && s1 != null ? (s1.floatValue() + (t1.floatValue() - s1.floatValue()) * partial) * leftHanded : (start = s1 != null ? s1.floatValue() * leftHanded : def.floatValue());
        float end = t2 != null && s2 != null ? (s2.floatValue() + (t2.floatValue() - s2.floatValue()) * partial) * leftHanded : (s2 != null ? s2.floatValue() * leftHanded : def.floatValue());
        return MathHelper.func_219799_g((float)zoom, (float)start, (float)end);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerPreRender(PlayerEntity player, Hand hand, float aimProgress, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? hand == Hand.MAIN_HAND : hand == Hand.OFF_HAND;
        float angle = this.getPlayerPitch(player);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        float rightOffset = this.getValue(Float.valueOf(targetPose.getIdle().getRenderYawOffset()), Float.valueOf(targetPose.getAiming().getRenderYawOffset()), Float.valueOf(this.forwardPose.getIdle().getRenderYawOffset()), Float.valueOf(this.forwardPose.getAiming().getRenderYawOffset()), Float.valueOf(0.0f), angleAbs, zoom, right ? 1.0f : -1.0f);
        player.field_70760_ar = player.field_70126_B + rightOffset;
        player.field_70761_aq = player.field_70177_z + rightOffset;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(PlayerEntity player, Hand hand, float aimProgress, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        if (hand == Hand.MAIN_HAND) {
            boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT;
            float leftHanded = right ? 1.0f : -1.0f;
            matrixStack.func_227861_a_(0.0, 0.0, 0.05);
            float angle = this.getPlayerPitch(player);
            float angleAbs = Math.abs(angle);
            float zoom = this.hasAimPose() ? aimProgress : 0.0f;
            AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
            float translateX = this.getValue(Float.valueOf(targetPose.getIdle().getItemTranslate().func_195899_a()), Float.valueOf(targetPose.getAiming().getItemTranslate().func_195899_a()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().func_195899_a()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().func_195899_a()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float translateY = this.getValue(Float.valueOf(targetPose.getIdle().getItemTranslate().func_195900_b()), Float.valueOf(targetPose.getAiming().getItemTranslate().func_195900_b()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().func_195900_b()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().func_195900_b()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float translateZ = this.getValue(Float.valueOf(targetPose.getIdle().getItemTranslate().func_195902_c()), Float.valueOf(targetPose.getAiming().getItemTranslate().func_195902_c()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().func_195902_c()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().func_195902_c()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            matrixStack.func_227861_a_((double)translateX * 0.0625 * (double)leftHanded, (double)translateY * 0.0625, (double)translateZ * 0.0625);
            float rotateX = this.getValue(Float.valueOf(targetPose.getIdle().getItemRotation().func_195899_a()), Float.valueOf(targetPose.getAiming().getItemRotation().func_195899_a()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().func_195899_a()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().func_195899_a()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float rotateY = this.getValue(Float.valueOf(targetPose.getIdle().getItemRotation().func_195900_b()), Float.valueOf(targetPose.getAiming().getItemRotation().func_195900_b()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().func_195900_b()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().func_195900_b()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            float rotateZ = this.getValue(Float.valueOf(targetPose.getIdle().getItemRotation().func_195902_c()), Float.valueOf(targetPose.getAiming().getItemRotation().func_195902_c()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().func_195902_c()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().func_195902_c()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotateX));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotateY * leftHanded));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotateZ * leftHanded));
        }
    }
}

