/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.guns.client.handler.GunRenderingHandler;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.common.container.AttachmentContainer;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class AttachmentScreen
extends ContainerScreen<AttachmentContainer> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("cgm:textures/gui/attachments.png");
    private final PlayerInventory playerInventory;
    private final IInventory weaponInventory;
    private boolean showHelp = true;
    private int windowZoom = 10;
    private int windowX;
    private int windowY;
    private float windowRotationX;
    private float windowRotationY;
    private boolean mouseGrabbed;
    private int mouseGrabbedButton;
    private int mouseClickedX;
    private int mouseClickedY;

    public AttachmentScreen(AttachmentContainer screenContainer, PlayerInventory playerInventory, ITextComponent titleIn) {
        super((Container)screenContainer, playerInventory, titleIn);
        this.playerInventory = playerInventory;
        this.weaponInventory = screenContainer.getWeaponInventory();
        this.field_147000_g = 184;
    }

    public void tick() {
        super.tick();
        if (this.minecraft != null && this.minecraft.field_71439_g != null && !(this.minecraft.field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem)) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, startX + 7, startY + 16 + i * 18, 18, 18)) continue;
            IAttachment.Type type = IAttachment.Type.values()[i];
            if (!((AttachmentContainer)this.field_147002_h).func_75139_a(i).func_111238_b()) {
                this.renderTooltip(Arrays.asList(I18n.func_135052_a((String)("slot.cgm.attachment." + type.getTranslationKey()), (Object[])new Object[0]), I18n.func_135052_a((String)"slot.cgm.attachment.not_applicable", (Object[])new Object[0])), mouseX, mouseY, this.minecraft.field_71466_p);
                continue;
            }
            if (!this.weaponInventory.func_70301_a(i).func_190926_b()) continue;
            this.renderTooltip(Collections.singletonList(I18n.func_135052_a((String)("slot.cgm.attachment." + type.getTranslationKey()), (Object[])new Object[0])), mouseX, mouseY, this.minecraft.field_71466_p);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71466_p.func_211126_b(this.title.func_150254_d(), 8.0f, 6.0f, 0x404040);
        minecraft.field_71466_p.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        GL11.glEnable((int)3089);
        int left = (this.width - this.field_146999_f) / 2;
        int top = (this.height - this.field_147000_g) / 2;
        RenderUtil.scissor(left + 26, top + 17, 142, 70);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)96.0f, (float)50.0f, (float)100.0f);
        RenderSystem.translated((double)(this.windowX + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseX - this.mouseClickedX : 0)), (double)0.0, (double)0.0);
        RenderSystem.translated((double)0.0, (double)(this.windowY + (this.mouseGrabbed && this.mouseGrabbedButton == 0 ? mouseY - this.mouseClickedY : 0)), (double)0.0);
        RenderSystem.rotatef((float)-30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)(this.windowRotationY - (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseY - this.mouseClickedY : 0)), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)(this.windowRotationX + (float)(this.mouseGrabbed && this.mouseGrabbedButton == 1 ? mouseX - this.mouseClickedX : 0)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)150.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.scalef((float)((float)this.windowZoom / 10.0f), (float)((float)this.windowZoom / 10.0f), (float)((float)this.windowZoom / 10.0f));
        RenderSystem.scalef((float)90.0f, (float)-90.0f, (float)90.0f);
        RenderSystem.rotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IRenderTypeBuffer.Impl buffer = this.minecraft.func_228019_au_().func_228487_b_();
        GunRenderingHandler.get().renderWeapon((LivingEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_184614_ca(), ItemCameraTransforms.TransformType.GROUND, new MatrixStack(), (IRenderTypeBuffer)buffer, 0xF000F0, 0.0f);
        buffer.func_228461_a_();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
        GL11.glDisable((int)3089);
        if (this.showHelp) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            minecraft.field_71466_p.func_211126_b(I18n.func_135052_a((String)"container.cgm.attachments.window_help", (Object[])new Object[0]), 56.0f, 38.0f, 0xFFFFFF);
            RenderSystem.popMatrix();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(GUI_TEXTURES);
        int left = (this.width - this.field_146999_f) / 2;
        int top = (this.height - this.field_147000_g) / 2;
        this.blit(left, top, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int i = 0; i < IAttachment.Type.values().length; ++i) {
            if (!((AttachmentContainer)this.field_147002_h).func_75139_a(i).func_111238_b()) {
                this.blit(left + 8, top + 17 + i * 18, 176, 0, 16, 16);
                continue;
            }
            if (!this.weaponInventory.func_70301_a(i).func_190926_b()) continue;
            this.blit(left + 8, top + 17 + i * 18, 176, 16 + i * 16, 16, 16);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 142, 70)) {
            if (scroll < 0.0 && this.windowZoom > 0) {
                this.showHelp = false;
                --this.windowZoom;
            } else if (scroll > 0.0) {
                this.showHelp = false;
                ++this.windowZoom;
            }
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        if (RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, startX + 26, startY + 17, 142, 70) && !this.mouseGrabbed && (button == 0 || button == 1)) {
            this.mouseGrabbed = true;
            this.mouseGrabbedButton = button == 1 ? 1 : 0;
            this.mouseClickedX = (int)mouseX;
            this.mouseClickedY = (int)mouseY;
            this.showHelp = false;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.mouseGrabbed) {
            if (this.mouseGrabbedButton == 0 && button == 0) {
                this.mouseGrabbed = false;
                this.windowX = (int)((double)this.windowX + (mouseX - (double)this.mouseClickedX - 1.0));
                this.windowY = (int)((double)this.windowY + (mouseY - (double)this.mouseClickedY));
            } else if (this.mouseGrabbedButton == 1 && button == 1) {
                this.mouseGrabbed = false;
                this.windowRotationX = (float)((double)this.windowRotationX + (mouseX - (double)this.mouseClickedX));
                this.windowRotationY = (float)((double)this.windowRotationY - (mouseY - (double)this.mouseClickedY));
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

