/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.guns.client.screen.CheckBox;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.common.NetworkGunManager;
import com.mrcrayfish.guns.common.container.WorkbenchContainer;
import com.mrcrayfish.guns.crafting.WorkbenchRecipe;
import com.mrcrayfish.guns.crafting.WorkbenchRecipes;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.IAmmo;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageCraft;
import com.mrcrayfish.guns.tileentity.WorkbenchTileEntity;
import com.mrcrayfish.guns.util.InventoryUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class WorkbenchScreen
extends ContainerScreen<WorkbenchContainer> {
    private static final ResourceLocation GUI_BASE = new ResourceLocation("cgm:textures/gui/workbench.png");
    private static boolean showRemaining = false;
    private Tab currentTab;
    private List<Tab> tabs = new ArrayList<Tab>();
    private List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private PlayerInventory playerInventory;
    private WorkbenchTileEntity workbench;
    private Button btnCraft;
    private CheckBox checkBoxMaterials;
    private ItemStack displayStack;

    public WorkbenchScreen(WorkbenchContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.workbench = container.getWorkbench();
        this.field_146999_f = 256;
        this.field_147000_g = 184;
        this.materials = new ArrayList<MaterialItem>();
        this.createTabs(WorkbenchRecipes.getAll(playerInventory.field_70458_d.field_70170_p));
        if (!this.tabs.isEmpty()) {
            this.field_147000_g += 28;
        }
    }

    private void createTabs(NonNullList<WorkbenchRecipe> recipes) {
        ArrayList<WorkbenchRecipe> weapons = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> attachments = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> ammo = new ArrayList<WorkbenchRecipe>();
        ArrayList<WorkbenchRecipe> misc = new ArrayList<WorkbenchRecipe>();
        for (WorkbenchRecipe recipe : recipes) {
            ItemStack output = recipe.getItem();
            if (output.func_77973_b() instanceof GunItem) {
                weapons.add(recipe);
                continue;
            }
            if (output.func_77973_b() instanceof IAttachment) {
                attachments.add(recipe);
                continue;
            }
            if (this.isAmmo(output)) {
                ammo.add(recipe);
                continue;
            }
            misc.add(recipe);
        }
        if (!weapons.isEmpty()) {
            ItemStack icon = new ItemStack((IItemProvider)ModItems.ASSAULT_RIFLE.get());
            icon.func_196082_o().func_74768_a("AmmoCount", ((GunItem)ModItems.ASSAULT_RIFLE.get()).getGun().getGeneral().getMaxAmmo());
            this.tabs.add(new Tab(icon, "weapons", weapons));
        }
        if (!attachments.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((IItemProvider)ModItems.LONG_SCOPE.get()), "attachments", attachments));
        }
        if (!ammo.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((IItemProvider)ModItems.SHELL.get()), "ammo", ammo));
        }
        if (!misc.isEmpty()) {
            this.tabs.add(new Tab(new ItemStack((IItemProvider)Items.field_221803_eL), "misc", misc));
        }
        if (!this.tabs.isEmpty()) {
            this.currentTab = this.tabs.get(0);
        }
    }

    private boolean isAmmo(ItemStack stack) {
        if (stack.func_77973_b() instanceof IAmmo) {
            return true;
        }
        ResourceLocation id = stack.func_77973_b().getRegistryName();
        Objects.requireNonNull(id);
        for (GunItem gunItem : NetworkGunManager.getClientRegisteredGuns()) {
            if (!id.equals((Object)gunItem.getModifiedGun(stack).getProjectile().getItem())) continue;
            return true;
        }
        return false;
    }

    public void init() {
        super.init();
        if (!this.tabs.isEmpty()) {
            this.field_147009_r += 28;
        }
        this.addButton((Widget)new Button(this.field_147003_i + 9, this.field_147009_r + 18, 15, 20, "<", button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index - 1 < 0) {
                this.loadItem(this.currentTab.getRecipes().size() - 1);
            } else {
                this.loadItem(index - 1);
            }
        }));
        this.addButton((Widget)new Button(this.field_147003_i + 153, this.field_147009_r + 18, 15, 20, ">", button -> {
            int index = this.currentTab.getCurrentIndex();
            if (index + 1 >= this.currentTab.getRecipes().size()) {
                this.loadItem(0);
            } else {
                this.loadItem(index + 1);
            }
        }));
        this.btnCraft = (Button)this.addButton((Widget)new Button(this.field_147003_i + 195, this.field_147009_r + 16, 74, 20, I18n.func_135052_a((String)"gui.cgm.workbench.assemble", (Object[])new Object[0]), button -> {
            int index = this.currentTab.getCurrentIndex();
            WorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
            ResourceLocation registryName = recipe.func_199560_c();
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageCraft(registryName, this.workbench.func_174877_v()));
        }));
        this.btnCraft.active = false;
        this.checkBoxMaterials = (CheckBox)this.addButton(new CheckBox(this.field_147003_i + 172, this.field_147009_r + 51, I18n.func_135052_a((String)"gui.cgm.workbench.show_remaining", (Object[])new Object[0])));
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadItem(this.currentTab.getCurrentIndex());
    }

    public void tick() {
        super.tick();
        for (MaterialItem material : this.materials) {
            material.update();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        this.btnCraft.active = canCraft;
        this.updateColor();
    }

    private void updateColor() {
        ItemStack item;
        if (this.currentTab != null && (item = this.displayStack).func_77973_b() instanceof IColored && ((IColored)item.func_77973_b()).canColor(item)) {
            IColored colored = (IColored)item.func_77973_b();
            if (!this.workbench.func_70301_a(0).func_190926_b()) {
                ItemStack dyeStack = this.workbench.func_70301_a(0);
                if (dyeStack.func_77973_b() instanceof DyeItem) {
                    DyeColor color = ((DyeItem)dyeStack.func_77973_b()).func_195962_g();
                    float[] components = color.func_193349_f();
                    int red = (int)(components[0] * 255.0f);
                    int green = (int)(components[1] * 255.0f);
                    int blue = (int)(components[2] * 255.0f);
                    colored.setColor(item, (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
                } else {
                    colored.removeColor(item);
                }
            } else {
                colored.removeColor(item);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.mouseClicked(mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (!RenderUtil.isMouseWithin((int)mouseX, (int)mouseY, this.field_147003_i + 28 * i, this.field_147009_r - 28, 28, 28)) continue;
            this.currentTab = this.tabs.get(i);
            this.loadItem(this.currentTab.getCurrentIndex());
            this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return result;
    }

    private void loadItem(int index) {
        WorkbenchRecipe recipe = this.currentTab.getRecipes().get(index);
        this.displayStack = recipe.getItem().func_77946_l();
        this.updateColor();
        this.materials.clear();
        ImmutableList<ItemStack> materials = recipe.getMaterials();
        if (materials != null) {
            for (ItemStack material : materials) {
                MaterialItem item = new MaterialItem(material);
                item.update();
                this.materials.add(item);
            }
            this.currentTab.setCurrentIndex(index);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int startX = this.field_147003_i;
        int startY = this.field_147009_r;
        for (i = 0; i < this.tabs.size(); ++i) {
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, startX + 28 * i, startY - 28, 28, 28)) continue;
            this.renderTooltip(new TranslationTextComponent(this.tabs.get(i).getTabKey(), new Object[0]).func_150254_d(), mouseX, mouseY);
            return;
        }
        for (i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 172;
            int itemY = startY + i * 19 + 63;
            if (!RenderUtil.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)).getStack().func_190926_b()) continue;
            this.renderTooltip(materialItem.getStack(), mouseX, mouseY);
            return;
        }
        if (RenderUtil.isMouseWithin(mouseX, mouseY, startX + 8, startY + 38, 160, 48)) {
            this.renderTooltip(this.displayStack, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offset = this.tabs.isEmpty() ? 0 : 28;
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, (float)(-22 + offset), 0x404040);
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 - 9 + offset), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        int startX = this.field_147003_i;
        int startY = this.field_147009_r;
        RenderSystem.enableBlend();
        for (i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (tab == this.currentTab) continue;
            this.minecraft.func_110434_K().func_110577_a(GUI_BASE);
            this.blit(startX + 28 * i, startY - 28, 80, 184, 28, 32);
            Minecraft.func_71410_x().func_175599_af().func_180450_b(tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.font, tab.getIcon(), startX + 28 * i + 6, startY - 28 + 8, null);
        }
        this.minecraft.func_110434_K().func_110577_a(GUI_BASE);
        this.blit(startX, startY, 0, 0, 173, 184);
        WorkbenchScreen.blit((int)(startX + 173), (int)startY, (int)78, (int)184, (float)173.0f, (float)0.0f, (int)1, (int)184, (int)256, (int)256);
        this.blit(startX + 251, startY, 174, 0, 24, 184);
        this.blit(startX + 172, startY + 16, 198, 0, 20, 20);
        if (this.currentTab != null) {
            i = this.tabs.indexOf(this.currentTab);
            int u = i == 0 ? 80 : 108;
            this.minecraft.func_110434_K().func_110577_a(GUI_BASE);
            this.blit(startX + 28 * i, startY - 28, u, 214, 28, 32);
            Minecraft.func_71410_x().func_175599_af().func_180450_b(this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8);
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.font, this.currentTab.getIcon(), startX + 28 * i + 6, startY - 28 + 8, null);
        }
        this.minecraft.func_110434_K().func_110577_a(GUI_BASE);
        if (this.workbench.func_70301_a(0).func_190926_b()) {
            this.blit(startX + 174, startY + 18, 165, 199, 16, 16);
        }
        ItemStack currentItem = this.displayStack;
        StringBuilder builder = new StringBuilder(currentItem.func_200301_q().getString());
        if (currentItem.func_190916_E() > 1) {
            builder.append(TextFormatting.GOLD);
            builder.append(TextFormatting.BOLD);
            builder.append(" x ");
            builder.append(currentItem.func_190916_E());
        }
        this.drawCenteredString(this.font, builder.toString(), startX + 88, startY + 22, Color.WHITE.getRGB());
        GL11.glEnable((int)3089);
        RenderUtil.scissor(startX + 8, startY + 17, 160, 70);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(startX + 88), (float)(startY + 60), (float)100.0f);
        RenderSystem.scalef((float)50.0f, (float)-50.0f, (float)50.0f);
        RenderSystem.rotatef((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IRenderTypeBuffer.Impl buffer = this.minecraft.func_228019_au_().func_228487_b_();
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(currentItem, ItemCameraTransforms.TransformType.FIXED, false, new MatrixStack(), (IRenderTypeBuffer)buffer, 0xF000F0, OverlayTexture.field_229196_a_, RenderUtil.getModel(currentItem));
        buffer.func_228461_a_();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
        GL11.glDisable((int)3089);
        this.filteredMaterials = this.getMaterials();
        for (int i2 = 0; i2 < this.filteredMaterials.size(); ++i2) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(GUI_BASE);
            MaterialItem materialItem = this.filteredMaterials.get(i2);
            ItemStack stack = materialItem.stack;
            if (stack.func_190926_b()) continue;
            RenderHelper.func_74518_a();
            if (materialItem.isEnabled()) {
                this.blit(startX + 172, startY + i2 * 19 + 63, 0, 184, 80, 19);
            } else {
                this.blit(startX + 172, startY + i2 * 19 + 63, 0, 222, 80, 19);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = stack.func_200301_q().getString();
            if (this.font.func_78256_a(name) > 55) {
                name = this.font.func_78269_a(name, 50).trim() + "...";
            }
            this.font.func_211126_b(name, (float)(startX + 172 + 22), (float)(startY + i2 * 19 + 6 + 63), Color.WHITE.getRGB());
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, startX + 172 + 2, startY + i2 * 19 + 1 + 63);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack);
                stack = stack.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() - count);
            }
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.font, stack, startX + 172 + 2, startY + i2 * 19 + 1 + 63, null);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.func_191197_a((int)6, (Object)new MaterialItem(ItemStack.field_190927_a));
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : !((MaterialItem)materialItem).stack.func_190926_b()).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, filteredMaterials.get(i));
        }
        return materials;
    }

    public List<Tab> getTabs() {
        return ImmutableList.copyOf(this.tabs);
    }

    private static class Tab {
        private final ItemStack icon;
        private final String id;
        private final List<WorkbenchRecipe> items;
        private int currentIndex;

        public Tab(ItemStack icon, String id, List<WorkbenchRecipe> items) {
            this.icon = icon;
            this.id = id;
            this.items = items;
        }

        public ItemStack getIcon() {
            return this.icon;
        }

        public String getTabKey() {
            return "gui.cgm.workbench.tab." + this.id;
        }

        public void setCurrentIndex(int currentIndex) {
            this.currentIndex = currentIndex;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public List<WorkbenchRecipe> getRecipes() {
            return this.items;
        }
    }

    public static class MaterialItem {
        public static final MaterialItem EMPTY = new MaterialItem();
        private boolean enabled = false;
        private ItemStack stack = ItemStack.field_190927_a;

        private MaterialItem() {
        }

        private MaterialItem(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void update() {
            if (!this.stack.func_190926_b()) {
                this.enabled = InventoryUtil.hasItemStack((PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.stack);
            }
        }

        public boolean isEnabled() {
            return this.stack.func_190926_b() || this.enabled;
        }
    }
}

