/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.settings;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.OptionButton;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.util.text.ITextComponent;

public class GunEnumOption<E extends Enum<E>>
extends AbstractOption {
    private Class<E> enumClass;
    private int ordinal = 0;
    private Function<GameSettings, E> getter;
    private BiConsumer<GameSettings, E> setter;
    private BiFunction<GameSettings, GunEnumOption<E>, ITextComponent> displayNameGetter;

    public GunEnumOption(String title, Class<E> enumClass, Function<GameSettings, E> getter, BiConsumer<GameSettings, E> setter, BiFunction<GameSettings, GunEnumOption<E>, ITextComponent> displayNameGetter) {
        super(title);
        this.enumClass = enumClass;
        this.getter = getter;
        this.setter = setter;
        this.displayNameGetter = displayNameGetter;
    }

    private void nextEnum(GameSettings options) {
        this.set(options, this.getEnum(++this.ordinal));
    }

    public void set(GameSettings options, E e) {
        this.setter.accept(options, e);
        this.ordinal = ((Enum)e).ordinal();
    }

    public E get(GameSettings options) {
        Enum e = (Enum)this.getter.apply(options);
        this.ordinal = e.ordinal();
        return (E)e;
    }

    public Widget func_216586_a(GameSettings options, int x, int y, int width) {
        return new OptionButton(x, y, width, 20, (AbstractOption)this, this.getTitle(options).func_150254_d(), button -> {
            this.nextEnum(options);
            button.setMessage(this.getTitle(options).func_150254_d());
        });
    }

    public ITextComponent getTitle(GameSettings options) {
        return this.displayNameGetter.apply(options, this);
    }

    private E getEnum(int ordinal) {
        Enum[] e = (Enum[])this.enumClass.getEnumConstants();
        if (ordinal >= e.length) {
            ordinal = 0;
        }
        return (E)e[ordinal];
    }
}

