/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.common.headshot.BasicHeadshotBox;
import com.mrcrayfish.guns.common.headshot.ChildHeadshotBox;
import com.mrcrayfish.guns.common.headshot.NoChildHeadshotBox;
import com.mrcrayfish.guns.common.headshot.NoChildRotatedHeadshotBox;
import com.mrcrayfish.guns.common.headshot.RotatedHeadshotBox;
import com.mrcrayfish.guns.interfaces.IHeadshotBox;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class BoundingBoxManager {
    private static Map<EntityType<?>, IHeadshotBox<?>> headshotBoxes = new HashMap();
    private static WeakHashMap<PlayerEntity, LinkedList<AxisAlignedBB>> playerBoxes = new WeakHashMap();

    public static <T extends LivingEntity> void registerHeadshotBox(EntityType<T> type, IHeadshotBox<T> headshotBox) {
        headshotBoxes.putIfAbsent(type, headshotBox);
    }

    @Nullable
    public static <T extends Entity> IHeadshotBox<T> getHeadshotBoxes(EntityType<T> type) {
        return headshotBoxes.get(type);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!((Boolean)Config.COMMON.gameplay.improvedHitboxes.get()).booleanValue()) {
            return;
        }
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            if (event.player.func_175149_v()) {
                playerBoxes.remove(event.player);
                return;
            }
            LinkedList boxes = playerBoxes.computeIfAbsent(event.player, player -> new LinkedList());
            boxes.addFirst(event.player.func_174813_aQ());
            if (boxes.size() > 20) {
                boxes.removeLast();
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        playerBoxes.remove(event.getPlayer());
    }

    public static AxisAlignedBB getBoundingBox(PlayerEntity entity, int ping) {
        if (playerBoxes.containsKey(entity)) {
            LinkedList<AxisAlignedBB> boxes = playerBoxes.get(entity);
            int index = MathHelper.func_76125_a((int)ping, (int)0, (int)(boxes.size() - 1));
            return boxes.get(index);
        }
        return entity.func_174813_aQ();
    }

    static {
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200729_aH, entity -> {
            AxisAlignedBB headBox = new AxisAlignedBB(-0.25, 0.0, -0.25, 0.25, 0.5, 0.25);
            double scale = 0.9375;
            if (entity.func_203007_ba()) {
                headBox = headBox.func_72317_d(0.0, 0.1875, 0.0);
                Vec3d pos = Vec3d.func_189986_a((float)entity.field_70125_A, (float)entity.field_70761_aq).func_72432_b().func_186678_a(0.8);
                headBox = headBox.func_191194_a(pos);
            } else {
                headBox = headBox.func_72317_d(0.0, entity.func_225608_bj_() ? 1.25 : 1.5, 0.0);
            }
            return new AxisAlignedBB(headBox.field_72340_a * scale, headBox.field_72338_b * scale, headBox.field_72339_c * scale, headBox.field_72336_d * scale, headBox.field_72337_e * scale, headBox.field_72334_f * scale);
        });
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200725_aD, new ChildHeadshotBox(8.0, 24.0, 0.75, 0.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200763_C, new ChildHeadshotBox(8.0, 24.0, 0.75, 0.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200741_ag, new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200750_ap, new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200797_k, new BasicHeadshotBox(8.0, 18.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200748_an, new RotatedHeadshotBox(8.0, 5.0, 7.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_204724_o, new BasicHeadshotBox(8.0, 24.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200756_av, new NoChildHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200727_aF, new NoChildHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200758_ax, new NoChildHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200806_t, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_220350_aJ, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200764_D, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_220351_aK, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200759_ay, new BasicHeadshotBox(8.0, 9.0, 23.0));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200737_ac, new RotatedHeadshotBox(7.5, 8.0, 15.0, 9.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200795_i, new NoChildRotatedHeadshotBox(4.0, 6.0, 9.0, 5.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200796_j, new NoChildRotatedHeadshotBox(7.5, 8.0, 16.0, 10.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200780_T, new NoChildRotatedHeadshotBox(7.5, 8.0, 16.0, 10.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200784_X, new NoChildRotatedHeadshotBox(8.0, 8.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200762_B, new RotatedHeadshotBox(10.0, 26.0, 16.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200742_ah, new RotatedHeadshotBox(10.0, 26.0, 16.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200798_l, new RotatedHeadshotBox(7.5, 8.0, 20.0, 13.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200779_S, new RotatedHeadshotBox(7.5, 8.0, 21.0, 14.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200769_I, new RotatedHeadshotBox(8.0, 26.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_220354_ax, new RotatedHeadshotBox(8.0, 26.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200786_Z, new RotatedHeadshotBox(9.0, 12.0, 20.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200745_ak, new BasicHeadshotBox(10.0, 20.5));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_203099_aq, new RotatedHeadshotBox(6.0, 5.0, 1.0, 10.0, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_200757_aw, new RotatedHeadshotBox(8.0, 10.0, 33.0, 3.5, false, true));
        BoundingBoxManager.registerHeadshotBox(EntityType.field_203097_aH, new RotatedHeadshotBox(6.0, 3.0, 1.5, 6.5, true, true));
    }
}

