/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.guns.client.render.IHeldAnimation;
import com.mrcrayfish.guns.client.render.pose.BazookaPose;
import com.mrcrayfish.guns.client.render.pose.MiniGunPose;
import com.mrcrayfish.guns.client.render.pose.OneHandedPose;
import com.mrcrayfish.guns.client.render.pose.TwoHandedPose;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;

public class GripType {
    public static final GripType ONE_HANDED = new GripType(new ResourceLocation("cgm", "one_handed"), new OneHandedPose());
    public static final GripType TWO_HANDED = new GripType(new ResourceLocation("cgm", "two_handed"), new TwoHandedPose());
    public static final GripType MINI_GUN = new GripType(new ResourceLocation("cgm", "mini_gun"), new MiniGunPose());
    public static final GripType BAZOOKA = new GripType(new ResourceLocation("cgm", "bazooka"), new BazookaPose());
    private static Map<ResourceLocation, GripType> gripTypeMap = new HashMap<ResourceLocation, GripType>();
    private final ResourceLocation id;
    private final IHeldAnimation heldAnimation;

    public static boolean applyBackTransforms(PlayerEntity player, MatrixStack matrixStack) {
        if (player.func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == Items.field_185160_cR) {
            return false;
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        if (player.func_213453_ef()) {
            matrixStack.func_227861_a_(0.0, -0.4375, -0.25);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        } else {
            matrixStack.func_227861_a_(0.0, -0.3125, -0.125);
        }
        if (!player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
            matrixStack.func_227861_a_(0.0, 0.0, -0.0625);
        }
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-45.0f));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        return true;
    }

    public static void registerType(GripType type) {
        gripTypeMap.putIfAbsent(type.getId(), type);
    }

    public static GripType getType(ResourceLocation id) {
        return gripTypeMap.getOrDefault(id, ONE_HANDED);
    }

    public GripType(ResourceLocation id, IHeldAnimation heldAnimation) {
        this.id = id;
        this.heldAnimation = heldAnimation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IHeldAnimation getHeldAnimation() {
        return this.heldAnimation;
    }

    static {
        GripType.registerType(ONE_HANDED);
        GripType.registerType(TWO_HANDED);
        GripType.registerType(MINI_GUN);
        GripType.registerType(BAZOOKA);
    }
}

